/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class XVisualInfo {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] XVisualInfo_size = new int[]{40, 40, 40, 40, 40, 40, 64, 48};
    private static final int[] visual_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] visualid_offset = new int[]{4, 4, 4, 4, 4, 4, 8, 8};
    private static final int[] screen_offset = new int[]{8, 8, 8, 8, 8, 8, 16, 12};
    private static final int[] depth_offset = new int[]{12, 12, 12, 12, 12, 12, 20, 16};
    private static final int[] c_class_offset = new int[]{16, 16, 16, 16, 16, 16, 24, 20};
    private static final int[] red_mask_offset = new int[]{20, 20, 20, 20, 20, 20, 32, 24};
    private static final int[] green_mask_offset = new int[]{24, 24, 24, 24, 24, 24, 40, 28};
    private static final int[] blue_mask_offset = new int[]{28, 28, 28, 28, 28, 28, 48, 32};
    private static final int[] colormap_size_offset = new int[]{32, 32, 32, 32, 32, 32, 56, 36};
    private static final int[] bits_per_rgb_offset = new int[]{36, 36, 36, 36, 36, 36, 60, 40};

    public static int size() {
        return XVisualInfo_size[mdIdx];
    }

    public static XVisualInfo create() {
        return XVisualInfo.create(Buffers.newDirectByteBuffer(XVisualInfo.size()));
    }

    public static XVisualInfo create(ByteBuffer byteBuffer) {
        return new XVisualInfo(byteBuffer);
    }

    XVisualInfo(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[XVisualInfo.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public XVisualInfo setVisual(long l) {
        this.accessor.setLongAt(visual_offset[mdIdx], l, this.md.pointerSizeInBytes());
        return this;
    }

    public long getVisual() {
        return this.accessor.getLongAt(visual_offset[mdIdx], this.md.pointerSizeInBytes());
    }

    public XVisualInfo setVisualid(long l) {
        this.accessor.setLongAt(visualid_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getVisualid() {
        return this.accessor.getLongAt(visualid_offset[mdIdx], this.md.longSizeInBytes());
    }

    public XVisualInfo setScreen(int n) {
        this.accessor.setIntAt(screen_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getScreen() {
        return this.accessor.getIntAt(screen_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XVisualInfo setDepth(int n) {
        this.accessor.setIntAt(depth_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getDepth() {
        return this.accessor.getIntAt(depth_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XVisualInfo setC_class(int n) {
        this.accessor.setIntAt(c_class_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getC_class() {
        return this.accessor.getIntAt(c_class_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XVisualInfo setRed_mask(long l) {
        this.accessor.setLongAt(red_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getRed_mask() {
        return this.accessor.getLongAt(red_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public XVisualInfo setGreen_mask(long l) {
        this.accessor.setLongAt(green_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getGreen_mask() {
        return this.accessor.getLongAt(green_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public XVisualInfo setBlue_mask(long l) {
        this.accessor.setLongAt(blue_mask_offset[mdIdx], l, this.md.longSizeInBytes());
        return this;
    }

    public long getBlue_mask() {
        return this.accessor.getLongAt(blue_mask_offset[mdIdx], this.md.longSizeInBytes());
    }

    public XVisualInfo setColormap_size(int n) {
        this.accessor.setIntAt(colormap_size_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getColormap_size() {
        return this.accessor.getIntAt(colormap_size_offset[mdIdx], this.md.intSizeInBytes());
    }

    public XVisualInfo setBits_per_rgb(int n) {
        this.accessor.setIntAt(bits_per_rgb_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getBits_per_rgb() {
        return this.accessor.getIntAt(bits_per_rgb_offset[mdIdx], this.md.intSizeInBytes());
    }

    public static XVisualInfo create(XVisualInfo xVisualInfo) {
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.getBuffer().put(xVisualInfo.getBuffer());
        xVisualInfo2.getBuffer().rewind();
        xVisualInfo.getBuffer().rewind();
        return xVisualInfo2;
    }
}

