/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.GeometryState;
import java.awt.Dimension;
import java.awt.Point;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.DepthComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Raster;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Point3f;

public class RasterState
extends GeometryState {
    int image;
    int depthComponent;

    public RasterState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.image = controller.getSymbolTable().addReference(((Raster)this.node).getImage());
            this.depthComponent = controller.getSymbolTable().addReference(((Raster)this.node).getDepthComponent());
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.image);
        dataOutput.writeInt(this.depthComponent);
        Point3f point3f = new Point3f();
        ((Raster)this.node).getPosition(point3f);
        this.control.writePoint3f(dataOutput, point3f);
        dataOutput.writeInt(((Raster)this.node).getType());
        dataOutput.writeInt(((Raster)this.node).getClipMode());
        Point point = new Point();
        ((Raster)this.node).getSrcOffset(point);
        dataOutput.writeInt(point.x);
        dataOutput.writeInt(point.y);
        Dimension dimension = new Dimension();
        ((Raster)this.node).getSize(dimension);
        dataOutput.writeInt(dimension.width);
        dataOutput.writeInt(dimension.height);
        ((Raster)this.node).getDstOffset(point);
        dataOutput.writeInt(point.x);
        dataOutput.writeInt(point.y);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        this.image = dataInput.readInt();
        this.depthComponent = dataInput.readInt();
        ((Raster)this.node).setPosition(this.control.readPoint3f(dataInput));
        ((Raster)this.node).setType(dataInput.readInt());
        ((Raster)this.node).setClipMode(dataInput.readInt());
        ((Raster)this.node).setSrcOffset(new Point(dataInput.readInt(), dataInput.readInt()));
        ((Raster)this.node).setSize(new Dimension(dataInput.readInt(), dataInput.readInt()));
        ((Raster)this.node).setDstOffset(new Point(dataInput.readInt(), dataInput.readInt()));
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.image);
        this.control.getSymbolTable().incNodeComponentRefCount(this.depthComponent);
    }

    public void buildGraph() {
        ((Raster)this.node).setImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.image));
        ((Raster)this.node).setDepthComponent((DepthComponent)this.control.getSymbolTable().getJ3dNode(this.depthComponent));
        super.buildGraph();
    }

    protected SceneGraphObject createNode() {
        return new Raster();
    }
}

