/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.android.event;

import android.content.Context;
import android.os.Handler;
import android.os.SystemClock;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.accessibility.AccessibilityEvent;
import com.jogamp.common.os.AndroidVersion;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.NEWTEvent;
import com.jogamp.newt.event.WindowEvent;
import jogamp.newt.Debug;
import jogamp.newt.driver.android.WindowDriver;

public class AndroidNewtEventFactory {
    private static final boolean DEBUG_MOUSE_EVENT = Debug.debug("Android.MouseEvent");
    private static final boolean DEBUG_KEY_EVENT = Debug.debug("Android.KeyEvent");
    private static final int ACTION_SCROLL = 8;
    private static float maxPressure = 0.7f;
    private final int touchSlop;

    private static final MouseEvent.PointerType aToolType2PointerType(int n) {
        switch (n) {
            case 1: {
                return MouseEvent.PointerType.TouchScreen;
            }
            case 3: {
                return MouseEvent.PointerType.Mouse;
            }
            case 2: 
            case 4: {
                return MouseEvent.PointerType.Pen;
            }
        }
        return MouseEvent.PointerType.Undefined;
    }

    private static final short aMotionEventType2Newt(int n) {
        switch (n) {
            case 0: 
            case 5: {
                return 203;
            }
            case 1: 
            case 3: 
            case 6: {
                return 204;
            }
            case 2: {
                return 206;
            }
            case 4: {
                return 205;
            }
            case 8: {
                return 207;
            }
        }
        return 0;
    }

    private static final short aAccessibilityEventType2Newt(int n) {
        switch (n) {
            case 8: {
                return 103;
            }
        }
        return 0;
    }

    private static final short aKeyEventType2NewtEventType(int n) {
        switch (n) {
            case 0: 
            case 2: {
                return 300;
            }
            case 1: {
                return 301;
            }
        }
        return 0;
    }

    private static final short aKeyCode2NewtKeyCode(int n, boolean bl) {
        if (7 <= n && n <= 16) {
            return (short)(48 + (n - 7));
        }
        if (29 <= n && n <= 54) {
            return (short)(65 + (n - 29));
        }
        if (131 <= n && n <= 142) {
            return (short)(97 + (n - 131));
        }
        if (144 <= n && n <= 153) {
            return (short)(128 + (n - 144));
        }
        switch (n) {
            case 55: {
                return 44;
            }
            case 56: {
                return 46;
            }
            case 57: {
                return 18;
            }
            case 58: {
                return 19;
            }
            case 59: {
                return 15;
            }
            case 60: {
                return 15;
            }
            case 61: {
                return 9;
            }
            case 62: {
                return 32;
            }
            case 66: {
                return 13;
            }
            case 67: {
                return 8;
            }
            case 69: {
                return 45;
            }
            case 70: {
                return 61;
            }
            case 71: {
                return 40;
            }
            case 72: {
                return 41;
            }
            case 73: {
                return 92;
            }
            case 74: {
                return 59;
            }
            case 76: {
                return 47;
            }
            case 77: {
                return 64;
            }
            case 92: {
                return 16;
            }
            case 93: {
                return 11;
            }
            case 111: {
                return 27;
            }
            case 113: {
                return 17;
            }
            case 114: {
                return 17;
            }
            case 4: {
                if (!bl) break;
                return 27;
            }
            case 3: {
                if (!bl) break;
                return 2;
            }
        }
        return 0;
    }

    private static final int aKeyModifiers2Newt(int n) {
        int n2 = 0;
        if ((n & 4) != 0) {
            n2 |= 4;
        }
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 8;
        }
        return n2;
    }

    public static WindowEvent createWindowEvent(AccessibilityEvent accessibilityEvent, Window window) {
        int n = accessibilityEvent.getEventType();
        short s = AndroidNewtEventFactory.aAccessibilityEventType2Newt(n);
        if (0 != s) {
            return new WindowEvent(s, null == window ? null : window, accessibilityEvent.getEventTime());
        }
        return null;
    }

    public static com.jogamp.newt.event.KeyEvent createKeyEvent(KeyEvent keyEvent, Window window, boolean bl) {
        com.jogamp.newt.event.KeyEvent keyEvent2;
        short s = AndroidNewtEventFactory.aKeyEventType2NewtEventType(keyEvent.getAction());
        if (0 != s) {
            short s2 = AndroidNewtEventFactory.aKeyCode2NewtKeyCode(keyEvent.getKeyCode(), bl);
            keyEvent2 = AndroidNewtEventFactory.createKeyEventImpl(keyEvent, s, s2, window);
        } else {
            keyEvent2 = null;
        }
        if (DEBUG_KEY_EVENT) {
            System.err.println("createKeyEvent0: " + keyEvent + " -> " + keyEvent2);
        }
        return keyEvent2;
    }

    public static com.jogamp.newt.event.KeyEvent createKeyEvent(KeyEvent keyEvent, short s, Window window, boolean bl) {
        short s2 = AndroidNewtEventFactory.aKeyCode2NewtKeyCode(keyEvent.getKeyCode(), bl);
        com.jogamp.newt.event.KeyEvent keyEvent2 = AndroidNewtEventFactory.createKeyEventImpl(keyEvent, s, s2, window);
        if (DEBUG_KEY_EVENT) {
            System.err.println("createKeyEvent1: newtType " + NEWTEvent.toHexString(s) + ", " + keyEvent + " -> " + keyEvent2);
        }
        return keyEvent2;
    }

    public static com.jogamp.newt.event.KeyEvent createKeyEvent(KeyEvent keyEvent, short s, short s2, Window window) {
        com.jogamp.newt.event.KeyEvent keyEvent2 = AndroidNewtEventFactory.createKeyEventImpl(keyEvent, s2, s, window);
        if (DEBUG_KEY_EVENT) {
            System.err.println("createKeyEvent2: newtType " + NEWTEvent.toHexString(s2) + ", " + keyEvent + " -> " + keyEvent2);
        }
        return keyEvent2;
    }

    private static com.jogamp.newt.event.KeyEvent createKeyEventImpl(KeyEvent keyEvent, short s, short s2, Window window) {
        if (0 != s && 0 != s2) {
            Window window2 = null == window ? null : window;
            long l = System.currentTimeMillis() + (keyEvent.getEventTime() - SystemClock.uptimeMillis());
            int n = AndroidNewtEventFactory.aKeyModifiers2Newt(keyEvent.getMetaState());
            return com.jogamp.newt.event.KeyEvent.create(s, window2, l, n, s2, s2, (char)keyEvent.getUnicodeChar());
        }
        return null;
    }

    public static float getMaxPressure() {
        return maxPressure;
    }

    public AndroidNewtEventFactory(Context context, Handler handler) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.touchSlop = viewConfiguration.getScaledTouchSlop();
        int n = viewConfiguration.getScaledDoubleTapSlop();
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("AndroidNewtEventFactory    scrollSlop (scaled) " + this.touchSlop);
            System.err.println("AndroidNewtEventFactory doubleTapSlop (scaled) " + n);
        }
    }

    private static void collectPointerData(MotionEvent motionEvent, int n, int[] nArray, int[] nArray2, float[] fArray, short[] sArray, MouseEvent.PointerType[] pointerTypeArray) {
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)motionEvent.getX(i);
            nArray2[i] = (int)motionEvent.getY(i);
            fArray[i] = motionEvent.getPressure(i);
            sArray[i] = (short)motionEvent.getPointerId(i);
            if (fArray[i] > maxPressure) {
                maxPressure = fArray[i];
            }
            pointerTypeArray[i] = AndroidNewtEventFactory.aToolType2PointerType(motionEvent.getToolType(i));
            if (!DEBUG_MOUSE_EVENT) continue;
            System.err.println("createMouseEvent: ptr-data[" + i + "] " + nArray[i] + "/" + nArray2[i] + ", pressure " + fArray[i] + ", id " + sArray[i] + ", type " + pointerTypeArray[i]);
        }
    }

    public boolean sendPointerEvent(boolean bl, boolean bl2, boolean bl3, boolean bl4, MotionEvent motionEvent, WindowDriver windowDriver) {
        if (DEBUG_MOUSE_EVENT) {
            System.err.println("createMouseEvent: isOnTouchEvent " + bl4 + ", " + motionEvent);
        }
        if (motionEvent.getPressure() > maxPressure) {
            maxPressure = motionEvent.getPressure();
        }
        int n = motionEvent.getActionMasked();
        short s = AndroidNewtEventFactory.aMotionEventType2Newt(n);
        float f = this.touchSlop;
        float[] fArray = new float[]{0.0f, 0.0f, 0.0f};
        if (0 != s) {
            short s2;
            int n2;
            int n3;
            int n4 = 0;
            switch (n) {
                case 5: 
                case 6: {
                    n3 = motionEvent.getActionIndex();
                    n2 = motionEvent.getPointerId(n3) + 1;
                    if (1 <= n2 && n2 <= 16) {
                        s2 = (short)n2;
                        break;
                    }
                    s2 = 1;
                    break;
                }
                case 8: {
                    if (AndroidVersion.SDK_INT >= 12) {
                        fArray[0] = motionEvent.getAxisValue(0) / f;
                        fArray[1] = motionEvent.getAxisValue(1) / f;
                        if (fArray[0] * fArray[0] > fArray[1] * fArray[1]) {
                            n4 |= 1;
                        }
                        if (DEBUG_MOUSE_EVENT) {
                            System.err.println("createMouseEvent: SDK-12 Scroll " + fArray[0] + "/" + fArray[1] + ", " + f + ", mods " + n4);
                        }
                    }
                }
                default: {
                    n3 = 0;
                    s2 = 1;
                }
            }
            n2 = motionEvent.getPointerCount();
            switch (n) {
                case 0: 
                case 5: {
                    if (!bl3) break;
                    windowDriver.focusChanged(false, true);
                }
            }
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            float[] fArray2 = new float[n2];
            short[] sArray = new short[n2];
            MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n2];
            if (0 < n2) {
                if (DEBUG_MOUSE_EVENT) {
                    System.err.println("createMouseEvent: collect ptr-data [0.." + (n2 - 1) + ", count " + n2 + ", action " + n3 + "], aType " + n + ", button " + s2);
                }
                AndroidNewtEventFactory.collectPointerData(motionEvent, n2, nArray, nArray2, fArray2, sArray, pointerTypeArray);
            }
            windowDriver.doPointerEvent(bl, bl2, pointerTypeArray, s, n4, n3, sArray, s2, nArray, nArray2, fArray2, maxPressure, fArray, f);
            return true;
        }
        return false;
    }
}

