/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.opengl;

import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.opengl.BuildStaticGLInfo;
import com.jogamp.gluegen.opengl.GLEmitter;
import com.jogamp.gluegen.procaddress.ProcAddressConfiguration;
import com.jogamp.gluegen.runtime.opengl.GLNameResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class GLConfiguration
extends ProcAddressConfiguration {
    private final List<String> glSemHeaders = new ArrayList<String>();
    private final Set<String> ignoredExtensions = new HashSet<String>();
    private final Set<String> forcedExtensions = new HashSet<String>();
    private final Set<String> renameExtensionsIntoCore = new HashSet<String>();
    private BuildStaticGLInfo glSemInfo;
    boolean dropDocInfo = false;
    private final List<String> glDocHeaders = new ArrayList<String>();
    private BuildStaticGLInfo glDocInfo;
    private final Map<String, String> javaDocSymbolRenames = new HashMap<String, String>();
    private final Map<String, Set<String>> javaDocRenamedSymbols = new HashMap<String, Set<String>>();
    private final Map<String, GLEmitter.BufferObjectKind> bufferObjectKinds = new HashMap<String, GLEmitter.BufferObjectKind>();
    private final Set<String> bufferObjectOnly = new HashSet<String>();
    private final GLEmitter emitter;
    private final Set<String> dropUniqVendorExtensions = new HashSet<String>();
    private boolean autoUnifyExtensions = false;
    private boolean allowNonGLExtensions = false;

    public GLConfiguration(GLEmitter gLEmitter) {
        this.emitter = gLEmitter;
        try {
            this.setProcAddressNameExpr("PFN $UPPERCASE({0}) PROC");
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error configuring ProcAddressNameExpr", noSuchElementException);
        }
    }

    @Override
    protected void dispatch(String string, StringTokenizer stringTokenizer, File file, String string2, int n) throws IOException {
        if (string.equalsIgnoreCase("IgnoreExtension")) {
            String string3 = this.readString("IgnoreExtension", stringTokenizer, string2, n);
            this.ignoredExtensions.add(string3);
        } else if (string.equalsIgnoreCase("ForceExtension")) {
            String string4 = this.readString("ForceExtension", stringTokenizer, string2, n);
            this.forcedExtensions.add(string4);
        } else if (string.equalsIgnoreCase("RenameExtensionIntoCore")) {
            String string5 = this.readString("RenameExtensionIntoCore", stringTokenizer, string2, n);
            this.renameExtensionsIntoCore.add(string5);
        } else if (string.equalsIgnoreCase("AllowNonGLExtensions")) {
            this.allowNonGLExtensions = this.readBoolean("AllowNonGLExtensions", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("AutoUnifyExtensions")) {
            this.autoUnifyExtensions = this.readBoolean("AutoUnifyExtensions", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("GLSemHeader")) {
            String string6 = this.readString("GLSemHeader", stringTokenizer, string2, n);
            if (!this.glSemHeaders.contains(string6)) {
                this.glSemHeaders.add(string6);
            }
            if (!this.dropDocInfo && !this.glDocHeaders.contains(string6)) {
                this.glDocHeaders.add(string6);
            }
        } else if (string.equalsIgnoreCase("GLDocHeader")) {
            String string7 = this.readString("GLDocHeader", stringTokenizer, string2, n);
            if (!this.dropDocInfo && !this.glDocHeaders.contains(string7)) {
                this.glDocHeaders.add(string7);
            }
        } else if (string.equalsIgnoreCase("DropAllGLDocHeader")) {
            this.dropDocInfo = this.readBoolean("DropAllGLDocHeader", stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("BufferObjectKind")) {
            this.readBufferObjectKind(stringTokenizer, string2, n);
        } else if (string.equalsIgnoreCase("BufferObjectOnly")) {
            String string8 = this.readString("BufferObjectOnly", stringTokenizer, string2, n);
            this.bufferObjectOnly.add(string8);
        } else if (string.equalsIgnoreCase("DropUniqVendorExtensions")) {
            String string9 = this.readString("DropUniqVendorExtensions", stringTokenizer, string2, n);
            this.dropUniqVendorExtensions.add(string9);
        } else {
            super.dispatch(string, stringTokenizer, file, string2, n);
        }
    }

    protected void readBufferObjectKind(StringTokenizer stringTokenizer, String string, int n) {
        try {
            String string2 = stringTokenizer.nextToken();
            GLEmitter.BufferObjectKind bufferObjectKind = null;
            String string3 = stringTokenizer.nextToken();
            if (string2.equalsIgnoreCase("UnpackPixel")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.UNPACK_PIXEL;
            } else if (string2.equalsIgnoreCase("PackPixel")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.PACK_PIXEL;
            } else if (string2.equalsIgnoreCase("Array")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.ARRAY;
            } else if (string2.equalsIgnoreCase("Element")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.ELEMENT;
            } else if (string2.equalsIgnoreCase("Indirect")) {
                bufferObjectKind = GLEmitter.BufferObjectKind.INDIRECT;
            } else {
                throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + n + " in file \"" + string + "\": illegal BufferObjectKind \"" + string2 + "\", expected one of UnpackPixel, PackPixel, Array, Element or Indirect");
            }
            this.bufferObjectKinds.put(string3, bufferObjectKind);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new RuntimeException("Error parsing \"BufferObjectKind\" command at line " + n + " in file \"" + string + "\"", noSuchElementException);
        }
    }

    @Override
    public List<String> javaPrologueForMethod(MethodBinding methodBinding, boolean bl, boolean bl2) {
        List<String> list = super.javaPrologueForMethod(methodBinding, bl, bl2);
        GLEmitter.BufferObjectKind bufferObjectKind = this.getBufferObjectKind(methodBinding.getCSymbol());
        if (bufferObjectKind != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (list != null) {
                arrayList.addAll(list);
            }
            list = arrayList;
            String string = "check";
            if (bufferObjectKind == GLEmitter.BufferObjectKind.UNPACK_PIXEL) {
                string = string + "UnpackPBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.PACK_PIXEL) {
                string = string + "PackPBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.ARRAY) {
                string = string + "ArrayVBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.ELEMENT) {
                string = string + "ElementVBO";
            } else if (bufferObjectKind == GLEmitter.BufferObjectKind.INDIRECT) {
                string = string + "IndirectVBO";
            } else {
                throw new RuntimeException("Unknown BufferObjectKind " + (Object)((Object)bufferObjectKind));
            }
            string = this.emitter.isBufferObjectMethodBinding(methodBinding) ? string + "Bound" : string + "Unbound";
            string = string + "(true);";
            list.add(0, string);
            if (this.emitter.isBufferObjectMethodBinding(methodBinding)) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = iterator.next();
                    if (string2.indexOf("Buffers.rangeCheck") < 0) continue;
                    iterator.remove();
                }
            }
        }
        return list;
    }

    @Override
    public void logIgnores() {
        this.LOG.log(Level.INFO, "GL Ignored extensions: {0}", (Object)this.ignoredExtensions.size());
        for (String string : this.ignoredExtensions) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)string);
        }
        this.LOG.log(Level.INFO, "GL Forced extensions: {0}", (Object)this.forcedExtensions.size());
        for (String string : this.forcedExtensions) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)string);
        }
        super.logIgnores();
    }

    @Override
    public void logRenames() {
        this.LOG.log(Level.INFO, "GL Renamed extensions into core: {0}", (Object)this.renameExtensionsIntoCore.size());
        for (String string : this.renameExtensionsIntoCore) {
            this.LOG.log(Level.INFO, "\t{0}", (Object)string);
        }
        super.logRenames();
    }

    protected boolean shouldIgnoreExtension(AliasedSymbol aliasedSymbol) {
        Object object;
        boolean bl;
        Set<String> set = this.glSemInfo.getExtension(aliasedSymbol.getName());
        Set<String> set2 = null != set ? set : new HashSet<String>();
        if (aliasedSymbol.hasAliases()) {
            set = aliasedSymbol.getAliasedNames();
            for (String object2 : set) {
                Set<String> set3 = this.glSemInfo.getExtension(object2);
                if (null == set3 || set3.size() <= 0) continue;
                set2.addAll((Collection<String>)set3);
            }
        }
        boolean bl2 = bl = set2.size() > 0 && this.ignoredExtensions.containsAll(set2);
        if (this.LOG.isLoggable(Level.INFO)) {
            object = new HashSet();
            HashSet<String> bl3 = new HashSet<String>();
            for (String string : set2) {
                if (null != string && this.ignoredExtensions.contains(string)) {
                    object.add(string);
                    continue;
                }
                bl3.add(string);
            }
            if (bl) {
                this.LOG.log(Level.INFO, GLConfiguration.getASTLocusTag(aliasedSymbol), "Ignored symbol {0} of all extensions <{1}>", aliasedSymbol, set2);
            } else if (object.size() > 0) {
                this.LOG.log(Level.INFO, GLConfiguration.getASTLocusTag(aliasedSymbol), "Not ignored symbol {0};  Ignored in <{1}>, but active in <{2}>", aliasedSymbol, object, bl3);
            }
        }
        if (!bl) {
            String string;
            object = aliasedSymbol.getName();
            boolean bl3 = GLNameResolver.isGLEnumeration((String)object);
            boolean bl4 = GLNameResolver.isGLFunction((String)object);
            string = null;
            if ((bl4 || bl3) && GLNameResolver.isExtensionVEN((String)object, bl4) && this.getDropUniqVendorExtensions(string = GLNameResolver.getExtensionSuffix((String)object, bl4))) {
                this.LOG.log(Level.INFO, GLConfiguration.getASTLocusTag(aliasedSymbol), "Ignore UniqVendorEXT: {0}, vendor {1}, isGLFunc {2}, isGLEnum {3}", aliasedSymbol, string, bl4, bl3);
                bl = true;
            }
            if (!bl) {
                this.LOG.log(Level.INFO, GLConfiguration.getASTLocusTag(aliasedSymbol), "Not ignored UniqVendorEXT: {0}, vendor {1}, isGLFunc {2}, isGLEnum {3}", aliasedSymbol, string, bl4, bl3);
            }
        }
        if (bl) {
            bl = !this.shouldForceExtension(aliasedSymbol, set2);
        }
        return bl;
    }

    public boolean shouldForceExtension(AliasedSymbol aliasedSymbol, Set<String> set) {
        for (String string : set) {
            if (string == null || !this.forcedExtensions.contains(string)) continue;
            this.LOG.log(Level.INFO, GLConfiguration.getASTLocusTag(aliasedSymbol), "Not ignored symbol {0} of extension <{1}>", aliasedSymbol, string);
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldIgnoreInInterface(AliasedSymbol aliasedSymbol) {
        return this.shouldIgnoreExtension(aliasedSymbol) || this.shouldIgnoreInInterface_Int(aliasedSymbol);
    }

    @Override
    public boolean shouldIgnoreInImpl(AliasedSymbol aliasedSymbol) {
        return this.shouldIgnoreExtension(aliasedSymbol) || this.shouldIgnoreInImpl_Int(aliasedSymbol);
    }

    public boolean getAutoUnifyExtensions() {
        return this.autoUnifyExtensions;
    }

    public boolean getAllowNonGLExtensions() {
        return this.allowNonGLExtensions;
    }

    public boolean getDropUniqVendorExtensions(String string) {
        return this.dropUniqVendorExtensions.contains(string);
    }

    GLEmitter.BufferObjectKind getBufferObjectKind(AliasedSymbol aliasedSymbol) {
        String string = aliasedSymbol.getName();
        Set<String> set = aliasedSymbol.getAliasedNames();
        GLEmitter.BufferObjectKind bufferObjectKind = this.bufferObjectKinds.get(string);
        if (null == bufferObjectKind) {
            bufferObjectKind = GLConfiguration.oneInMap(this.bufferObjectKinds, set);
        }
        return bufferObjectKind;
    }

    public boolean isBufferObjectFunction(AliasedSymbol aliasedSymbol) {
        return null != this.getBufferObjectKind(aliasedSymbol);
    }

    public boolean isBufferObjectOnly(String string) {
        return this.bufferObjectOnly.contains(string);
    }

    public void parseGLSemHeaders(GlueEmitterControls glueEmitterControls) throws IOException {
        this.glSemInfo = new BuildStaticGLInfo();
        this.glSemInfo.setDebug(GlueGen.debug());
        if (!this.glSemHeaders.isEmpty()) {
            for (String string : this.glSemHeaders) {
                String string2 = glueEmitterControls.findHeaderFile(string);
                if (string2 == null) {
                    throw new IOException("Unable to locate header file \"" + string + "\"");
                }
                this.glSemInfo.parse(string2);
            }
        }
    }

    public BuildStaticGLInfo getGLSemInfo() {
        return this.glSemInfo;
    }

    public void parseGLDocHeaders(GlueEmitterControls glueEmitterControls) throws IOException {
        this.glDocInfo = new BuildStaticGLInfo();
        this.glDocInfo.setDebug(GlueGen.debug());
        if (!this.glDocHeaders.isEmpty()) {
            for (String string : this.glDocHeaders) {
                String string2 = glueEmitterControls.findHeaderFile(string);
                if (string2 == null) {
                    throw new IOException("Unable to locate header file \"" + string + "\"");
                }
                this.glDocInfo.parse(string2);
            }
        }
    }

    @Override
    public Set<String> getAliasedDocNames(AliasedSymbol aliasedSymbol) {
        return this.getRenamedJavaDocSymbols(aliasedSymbol.getName());
    }

    public BuildStaticGLInfo getGLDocInfo() {
        return this.glDocInfo;
    }

    public Set<String> getRenamedJavaDocSymbols(String string) {
        return this.javaDocRenamedSymbols.get(string);
    }

    @Override
    public void addJavaSymbolRename(String string, String string2) {
        super.addJavaSymbolRename(string, string2);
        if (!this.dropDocInfo) {
            this.addJavaDocSymbolRename(string, string2);
        }
    }

    public void addJavaDocSymbolRename(String string, String string2) {
        this.LOG.log(Level.INFO, "\tDoc Rename {0} -> {1}", string, string2);
        String string3 = this.javaDocSymbolRenames.put(string, string2);
        if (null != string3 && !string3.equals(string2)) {
            throw new RuntimeException("Doc-Rename-Override Attampt: " + string + " -> " + string2 + ", but " + string + " -> " + string3 + " already exist. Run in 'debug' mode to analyze!");
        }
        Set<String> set = this.javaDocRenamedSymbols.get(string2);
        if (null == set) {
            set = new HashSet<String>();
            this.javaDocRenamedSymbols.put(string2, set);
        }
        set.add(string);
    }

    public Set<String> getExtensionsRenamedIntoCore() {
        return this.renameExtensionsIntoCore;
    }
}

