/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry.compression;

import com.sun.j3d.internal.BufferWrapper;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.compression.CommandStream;
import com.sun.j3d.utils.geometry.compression.CompressionStreamColor;
import com.sun.j3d.utils.geometry.compression.CompressionStreamElement;
import com.sun.j3d.utils.geometry.compression.CompressionStreamNormal;
import com.sun.j3d.utils.geometry.compression.CompressionStreamVertex;
import com.sun.j3d.utils.geometry.compression.HuffmanTable;
import com.sun.j3d.utils.geometry.compression.MeshBuffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryStripArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedGeometryStripArray;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.J3DBuffer;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Material;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class CompressionStream {
    private static final boolean debug = false;
    private static final boolean benchmark = false;
    private static final boolean noMeshNormalSubstitution = true;
    static final int RESTART = 1;
    static final int REPLACE_MIDDLE = 2;
    static final int REPLACE_OLDEST = 3;
    static final int MESH_PUSH = 1;
    static final int NO_MESH_PUSH = 0;
    static final float ByteToFloatScale = 0.003921569f;
    int streamType;
    int vertexComponents;
    boolean vertexColors;
    boolean vertexColor3;
    boolean vertexColor4;
    boolean vertexNormals;
    boolean vertexTextures;
    boolean vertexTexture2;
    boolean vertexTexture3;
    boolean vertexTexture4;
    Point3d[] mcBounds = new Point3d[2];
    Point3d[] ncBounds = new Point3d[2];
    Point3i[] qcBounds = new Point3i[2];
    double[] center = new double[3];
    double positionRangeMaximum;
    double scale;
    int positionQuant;
    int colorQuant;
    int normalQuant;
    boolean positionQuantChanged;
    boolean colorQuantChanged;
    boolean normalQuantChanged;
    int[] lastPosition = new int[3];
    int[] lastColor = new int[4];
    int lastSextant;
    int lastOctant;
    int lastU;
    int lastV;
    boolean lastSpecialNormal;
    boolean firstPosition;
    boolean firstColor;
    boolean firstNormal;
    int byteCount = 0;
    int vertexCount = 0;
    int meshReferenceCount = 0;
    MeshBuffer meshBuffer = new MeshBuffer();
    private Collection stream;
    private boolean lastElementColor = false;
    private boolean lastLastElementColor = false;
    private boolean lastElementNormal = false;
    private boolean lastLastElementNormal = false;
    private Point3f p3f = new Point3f();
    private Color3f c3f = new Color3f();
    private Color4f c4f = new Color4f();
    private Vector3f n3f = new Vector3f();

    private CompressionStream() {
        this.stream = new LinkedList();
        this.mcBounds[0] = new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.mcBounds[1] = new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.qcBounds[0] = new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.qcBounds[1] = new Point3i(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        this.ncBounds[0] = new Point3d();
        this.ncBounds[1] = new Point3d();
    }

    CompressionStream(int n, int n2) {
        this();
        this.streamType = n;
        this.vertexComponents = this.getVertexComponents(n2);
    }

    private int getVertexComponents(int n) {
        int n2 = 0;
        this.vertexTexture4 = false;
        this.vertexTexture3 = false;
        this.vertexTexture2 = false;
        this.vertexTextures = false;
        this.vertexNormals = false;
        this.vertexColor4 = false;
        this.vertexColor3 = false;
        this.vertexColors = false;
        if ((n & 2) != 0) {
            this.vertexNormals = true;
            n2 &= 2;
        }
        if ((n & 4) != 0) {
            this.vertexColors = true;
            if ((n & 0xC) != 0) {
                this.vertexColor4 = true;
                n2 &= 0xC;
            } else {
                this.vertexColor3 = true;
                n2 &= 4;
            }
        }
        if ((n & 0x20) != 0) {
            this.vertexTextures = true;
            this.vertexTexture2 = true;
            n2 &= 0x20;
        } else if ((n & 0x40) != 0) {
            this.vertexTextures = true;
            this.vertexTexture3 = true;
            n2 &= 0x40;
        } else if ((n & 0x400) != 0) {
            this.vertexTextures = true;
            this.vertexTexture4 = true;
            n2 &= 0x400;
        }
        if (this.vertexTextures) {
            throw new UnsupportedOperationException("\ncompression of texture coordinates is not supported");
        }
        return n2;
    }

    private int getStreamType(GeometryArray geometryArray) {
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray || geometryArray instanceof TriangleArray || geometryArray instanceof IndexedTriangleArray || geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
            return 2;
        }
        if (geometryArray instanceof LineArray || geometryArray instanceof IndexedLineArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            return 1;
        }
        return 0;
    }

    void quantize(HuffmanTable huffmanTable) {
        this.positionQuant = 16;
        this.colorQuant = 9;
        this.normalQuant = 6;
        this.center[0] = (this.mcBounds[1].x + this.mcBounds[0].x) / 2.0;
        this.center[1] = (this.mcBounds[1].y + this.mcBounds[0].y) / 2.0;
        this.center[2] = (this.mcBounds[1].z + this.mcBounds[0].z) / 2.0;
        double d = this.mcBounds[1].x - this.mcBounds[0].x;
        double d2 = this.mcBounds[1].y - this.mcBounds[0].y;
        double d3 = this.mcBounds[1].z - this.mcBounds[0].z;
        this.positionRangeMaximum = d > d2 ? d : d2;
        if (d3 > this.positionRangeMaximum) {
            this.positionRangeMaximum = d3;
        }
        this.scale = 2.0 / this.positionRangeMaximum * 0.999969482421875;
        this.normalQuantChanged = true;
        this.colorQuantChanged = true;
        this.positionQuantChanged = true;
        this.firstNormal = true;
        this.firstColor = true;
        this.firstPosition = true;
        for (Object e : this.stream) {
            if (!(e instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e).quantize(this, huffmanTable);
            this.lastLastElementColor = this.lastElementColor;
            this.lastLastElementNormal = this.lastElementNormal;
            this.lastElementNormal = false;
            this.lastElementColor = false;
            if (e instanceof CompressionStreamColor) {
                this.lastElementColor = true;
                continue;
            }
            if (!(e instanceof CompressionStreamNormal)) continue;
            this.lastElementNormal = true;
        }
        this.ncBounds[0].x = (double)this.qcBounds[0].x / 32768.0;
        this.ncBounds[0].y = (double)this.qcBounds[0].y / 32768.0;
        this.ncBounds[0].z = (double)this.qcBounds[0].z / 32768.0;
        this.ncBounds[1].x = (double)this.qcBounds[1].x / 32768.0;
        this.ncBounds[1].y = (double)this.qcBounds[1].y / 32768.0;
        this.ncBounds[1].z = (double)this.qcBounds[1].z / 32768.0;
    }

    void outputCommands(HuffmanTable huffmanTable, CommandStream commandStream) {
        int n = this.vertexNormals ? 1 : 0;
        int n2 = this.vertexColor3 || this.vertexColor4 ? 1 : 0;
        int n3 = this.vertexColor4 ? 1 : 0;
        int n4 = 0x18 | n;
        long l = n2 << 2 | n3 << 1;
        commandStream.addCommand(n4, 8, l, 3);
        huffmanTable.outputCommands(commandStream);
        for (Object e : this.stream) {
            if (!(e instanceof CompressionStreamElement)) continue;
            ((CompressionStreamElement)e).outputCommand(huffmanTable, commandStream);
        }
        commandStream.end();
    }

    int getByteCount() {
        return this.byteCount;
    }

    int getVertexCount() {
        return this.vertexCount;
    }

    int getMeshReferenceCount() {
        return this.meshReferenceCount;
    }

    void addVertex(Point3f point3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n, 0));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n, 0));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n, 0));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n, 0));
    }

    void addVertex(Point3f point3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, (Color3f)null, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)null, n, n2));
    }

    void addVertex(Point3f point3f, Color3f color3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color3f, n, n2));
    }

    void addVertex(Point3f point3f, Color4f color4f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, (Vector3f)null, color4f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color3f color3f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color3f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Color4f color4f, int n, int n2) {
        this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, color4f, n, n2));
    }

    void addVertex(Point3f point3f, Vector3f vector3f, Object object, int n, int n2) {
        if (this.vertexColor3) {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color3f)object, n, n2));
        } else {
            this.stream.add(new CompressionStreamVertex(this, point3f, vector3f, (Color4f)object, n, n2));
        }
    }

    void addMeshReference(int n, int n2) {
        this.stream.add(new MeshReference(n, n2));
    }

    void addColor(Color3f color3f) {
        this.stream.add(new CompressionStreamColor(this, color3f));
    }

    void addColor(Color4f color4f) {
        this.stream.add(new CompressionStreamColor(this, color4f));
    }

    void addNormal(Vector3f vector3f) {
        this.stream.add(new CompressionStreamNormal(this, vector3f));
    }

    void addPositionQuantization(int n) {
        this.stream.add(new PositionQuant(n));
    }

    void addColorQuantization(int n) {
        this.stream.add(new ColorQuant(n));
    }

    void addNormalQuantization(int n) {
        this.stream.add(new NormalQuant(n));
    }

    private void getIndexArrays(GeometryArray geometryArray, IndexArrays indexArrays) {
        IndexedGeometryArray indexedGeometryArray = (IndexedGeometryArray)geometryArray;
        int n = indexedGeometryArray.getInitialIndexIndex();
        int n2 = indexedGeometryArray.getValidIndexCount();
        int n3 = indexedGeometryArray.getVertexFormat();
        boolean bl = false;
        if ((n3 & 0x200) != 0) {
            bl = true;
        }
        indexArrays.positionIndices = new int[n2];
        indexedGeometryArray.getCoordinateIndices(n, indexArrays.positionIndices);
        if (this.vertexNormals) {
            if (bl) {
                indexArrays.normalIndices = indexArrays.positionIndices;
            } else {
                indexArrays.normalIndices = new int[n2];
                indexedGeometryArray.getNormalIndices(n, indexArrays.normalIndices);
            }
        }
        if (this.vertexColor3 || this.vertexColor4) {
            if (bl) {
                indexArrays.colorIndices = indexArrays.positionIndices;
            } else {
                indexArrays.colorIndices = new int[n2];
                indexedGeometryArray.getColorIndices(n, indexArrays.colorIndices);
            }
        }
    }

    private void getVertexIndices(int n, IndexArrays indexArrays, VertexIndices vertexIndices) {
        vertexIndices.pi = indexArrays.positionIndices[n];
        if (this.vertexNormals) {
            vertexIndices.ni = indexArrays.normalIndices[n];
        }
        if (this.vertexColors) {
            vertexIndices.ci = indexArrays.colorIndices[n];
        }
    }

    private void processVertexCopy(VertexCopy vertexCopy, int n) {
        int n2 = this.meshBuffer.getMeshReference(vertexCopy.p);
        if (n2 == -1 || this.vertexNormals && !vertexCopy.n.equals((Tuple3f)this.meshBuffer.getNormal(n2))) {
            this.addVertex(vertexCopy.p, vertexCopy.n, vertexCopy.c, n, 1);
            this.meshBuffer.push(vertexCopy.p, vertexCopy.c, vertexCopy.n);
        } else {
            if (this.vertexNormals) {
                // empty if block
            }
            if (this.vertexColor3 && !vertexCopy.c3.equals((Tuple3f)this.meshBuffer.getColor3(n2))) {
                this.addColor(vertexCopy.c3);
            } else if (this.vertexColor4 && !vertexCopy.c4.equals((Tuple4f)this.meshBuffer.getColor4(n2))) {
                this.addColor(vertexCopy.c4);
            }
            this.addMeshReference(n, n2);
        }
    }

    private void processIndexedVertexCopy(VertexCopy vertexCopy, VertexIndices vertexIndices, int n) {
        int n2 = this.meshBuffer.getMeshReference(vertexIndices.pi);
        if (n2 == -1 || this.vertexNormals && vertexIndices.ni != this.meshBuffer.getNormalIndex(n2)) {
            this.addVertex(vertexCopy.p, vertexCopy.n, vertexCopy.c, n, 1);
            this.meshBuffer.push(vertexIndices.pi, vertexIndices.ci, vertexIndices.ni);
        } else {
            if (this.vertexNormals) {
                // empty if block
            }
            if (this.vertexColor3 && vertexIndices.ci != this.meshBuffer.getColorIndex(n2)) {
                this.addColor(vertexCopy.c3);
            } else if (this.vertexColor4 && vertexIndices.ci != this.meshBuffer.getColorIndex(n2)) {
                this.addColor(vertexCopy.c4);
            }
            this.addMeshReference(n, n2);
        }
    }

    void addGeometryArray(GeometryArray geometryArray) {
        int n = 0;
        int n2 = 0;
        int n3 = geometryArray.getVertexFormat();
        GeometryAccessor geometryAccessor = null;
        if (this.streamType != this.getStreamType(geometryArray)) {
            throw new IllegalArgumentException("GeometryArray has inconsistent dimensionality");
        }
        if (this.vertexComponents != this.getVertexComponents(n3)) {
            throw new IllegalArgumentException("GeometryArray has inconsistent vertex components");
        }
        boolean bl = (n3 & 0x800) != 0;
        boolean bl2 = (n3 & 0x80) != 0;
        boolean bl3 = (n3 & 0x100) != 0;
        boolean bl4 = geometryArray instanceof IndexedGeometryArray;
        if (bl4) {
            n = 0;
            n2 = ((IndexedGeometryArray)geometryArray).getValidIndexCount();
        }
        if (!bl2) {
            if (bl4) {
                geometryAccessor = new IndexedByCopyGeometry(geometryArray);
            } else {
                n = 0;
                n2 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByCopyGeometry(geometryArray);
            }
        } else if (bl3 && bl) {
            if (bl4) {
                geometryAccessor = new IndexedInterleavedGeometryNIO(geometryArray);
            } else {
                n = geometryArray.getInitialVertexIndex();
                n2 = geometryArray.getValidVertexCount();
                geometryAccessor = new InterleavedGeometryNIO(geometryArray);
            }
        } else if (bl3 && !bl) {
            if (bl4) {
                geometryAccessor = new IndexedInterleavedGeometryFloat(geometryArray);
            } else {
                n = geometryArray.getInitialVertexIndex();
                n2 = geometryArray.getValidVertexCount();
                geometryAccessor = new InterleavedGeometryFloat(geometryArray);
            }
        } else if (!bl3 && bl) {
            if (bl4) {
                geometryAccessor = new IndexedByRefGeometryNIO(geometryArray);
            } else {
                n = 0;
                n2 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByRefGeometryNIO(geometryArray);
            }
        } else if (!bl3 && !bl) {
            if (bl4) {
                geometryAccessor = new IndexedByRefGeometry(geometryArray);
            } else {
                n = 0;
                n2 = geometryArray.getValidVertexCount();
                geometryAccessor = new ByRefGeometry(geometryArray);
            }
        }
        int n4 = 0;
        int[] nArray = null;
        int n5 = 0;
        int n6 = 1;
        boolean bl5 = false;
        boolean bl6 = false;
        if (geometryArray instanceof TriangleStripArray || geometryArray instanceof IndexedTriangleStripArray || geometryArray instanceof LineStripArray || geometryArray instanceof IndexedLineStripArray) {
            bl5 = true;
            n6 = 3;
        } else if (geometryArray instanceof TriangleFanArray || geometryArray instanceof IndexedTriangleFanArray) {
            bl5 = true;
            n6 = 2;
        } else if (geometryArray instanceof QuadArray || geometryArray instanceof IndexedQuadArray) {
            bl6 = true;
            n5 = 4;
            n6 = 2;
        }
        if (bl5) {
            GeometryArray geometryArray2;
            if (bl4) {
                geometryArray2 = (IndexedGeometryStripArray)geometryArray;
                n4 = ((IndexedGeometryStripArray)geometryArray2).getNumStrips();
                nArray = new int[n4];
                ((IndexedGeometryStripArray)geometryArray2).getStripIndexCounts(nArray);
            } else {
                geometryArray2 = (GeometryStripArray)geometryArray;
                n4 = ((GeometryStripArray)geometryArray2).getNumStrips();
                nArray = new int[n4];
                ((GeometryStripArray)geometryArray2).getStripVertexCounts(nArray);
            }
        }
        int n7 = n;
        if (bl5) {
            for (int i = 0; i < n4; ++i) {
                geometryAccessor.processVertex(n7++, 1);
                for (int j = 1; j < nArray[i]; ++j) {
                    geometryAccessor.processVertex(n7++, n6);
                }
            }
        } else if (bl6) {
            while (n7 < n + n2) {
                geometryAccessor.processVertex(n7++, 1);
                for (int i = 1; i < n5; ++i) {
                    geometryAccessor.processVertex(n7++, n6);
                }
            }
        } else {
            while (n7 < n + n2) {
                geometryAccessor.processVertex(n7++, 1);
            }
        }
    }

    void print() {
        System.out.println("\nstream has " + this.stream.size() + " entries");
        System.out.println("uncompressed size " + this.byteCount + " bytes");
        System.out.println("upper position bound: " + this.mcBounds[1].toString());
        System.out.println("lower position bound: " + this.mcBounds[0].toString());
        System.out.println("X, Y, Z centers (" + (float)this.center[0] + " " + (float)this.center[1] + " " + (float)this.center[2] + ")\n" + "scale " + (float)this.scale + "\n");
        Iterator iterator = this.stream.iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next().toString() + "\n");
        }
    }

    public CompressionStream(int n, int n2, int n3, Shape3D[] shape3DArray) {
        this();
        if (shape3DArray == null) {
            throw new IllegalArgumentException("null Shape3D array");
        }
        if (shape3DArray.length == 0) {
            throw new IllegalArgumentException("zero-length Shape3D array");
        }
        if (shape3DArray[0] == null) {
            throw new IllegalArgumentException("Shape3D at index 0 is null");
        }
        long l = 0L;
        Geometry geometry = shape3DArray[0].getGeometry();
        if (!(geometry instanceof GeometryArray)) {
            throw new IllegalArgumentException("Shape3D at index 0 is not a GeometryArray");
        }
        GeometryArray geometryArray = (GeometryArray)geometry;
        this.streamType = this.getStreamType(geometryArray);
        this.vertexComponents = this.getVertexComponents(geometryArray.getVertexFormat());
        this.addPositionQuantization(n);
        this.addColorQuantization(n2);
        this.addNormalQuantization(n3);
        for (int i = 0; i < shape3DArray.length; ++i) {
            Material material;
            geometry = shape3DArray[i].getGeometry();
            if (!(geometry instanceof GeometryArray)) {
                throw new IllegalArgumentException("Shape3D at index " + i + " is not a GeometryArray");
            }
            Appearance appearance = shape3DArray[i].getAppearance();
            if (appearance != null && (material = appearance.getMaterial()) != null) {
                material.getDiffuseColor(this.c3f);
                if (this.vertexColor4) {
                    this.c4f.set(this.c3f.x, this.c3f.y, this.c3f.z, 1.0f);
                    this.addColor(this.c4f);
                } else {
                    this.addColor(this.c3f);
                }
            }
            this.addGeometryArray((GeometryArray)geometry);
        }
    }

    public CompressionStream(Shape3D[] shape3DArray) {
        this(16, 9, 6, shape3DArray);
    }

    public CompressionStream(int n, int n2, int n3, GeometryInfo[] geometryInfoArray) {
        this();
        if (geometryInfoArray == null) {
            throw new IllegalArgumentException("null GeometryInfo array");
        }
        if (geometryInfoArray.length == 0) {
            throw new IllegalArgumentException("zero-length GeometryInfo array");
        }
        if (geometryInfoArray[0] == null) {
            throw new IllegalArgumentException("GeometryInfo at index 0 is null");
        }
        long l = 0L;
        GeometryArray geometryArray = geometryInfoArray[0].getGeometryArray();
        this.streamType = this.getStreamType(geometryArray);
        this.vertexComponents = this.getVertexComponents(geometryArray.getVertexFormat());
        this.addPositionQuantization(n);
        this.addColorQuantization(n2);
        this.addNormalQuantization(n3);
        for (int i = 0; i < geometryInfoArray.length; ++i) {
            this.addGeometryArray(geometryInfoArray[i].getGeometryArray());
        }
    }

    public CompressionStream(GeometryInfo[] geometryInfoArray) {
        this(16, 9, 6, geometryInfoArray);
    }

    public Point3d[] getModelBounds() {
        Point3d[] point3dArray = new Point3d[]{new Point3d(this.mcBounds[0]), new Point3d(this.mcBounds[1])};
        return point3dArray;
    }

    public Point3d[] getNormalizedBounds() {
        Point3d[] point3dArray = new Point3d[]{new Point3d(this.ncBounds[0]), new Point3d(this.ncBounds[1])};
        return point3dArray;
    }

    private class IndexedByRefGeometryNIO
    extends ByRefGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n, int n2) {
            CompressionStream.this.getVertexIndices(n, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n2);
        }
    }

    private class ByRefGeometryNIO
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        ByteBuffer colorsB = null;
        FloatBuffer colorsF = null;
        FloatBuffer normals = null;
        FloatBuffer positionsF = null;
        DoubleBuffer positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometryNIO(GeometryArray geometryArray) {
            J3DBuffer j3DBuffer = geometryArray.getCoordRefBuffer();
            this.initialPositionIndex = geometryArray.getInitialCoordIndex();
            switch (BufferWrapper.getBufferType(j3DBuffer)) {
                case 3: {
                    this.positionsF = (FloatBuffer)j3DBuffer.getBuffer();
                    break;
                }
                case 4: {
                    this.positionsD = (DoubleBuffer)j3DBuffer.getBuffer();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\nposition buffer must be FloatBuffer or DoubleBuffer");
                }
            }
            if (CompressionStream.this.vertexColors) {
                j3DBuffer = geometryArray.getColorRefBuffer();
                this.initialColorIndex = geometryArray.getInitialColorIndex();
                switch (BufferWrapper.getBufferType(j3DBuffer)) {
                    case 2: {
                        this.colorsB = (ByteBuffer)j3DBuffer.getBuffer();
                        break;
                    }
                    case 3: {
                        this.colorsF = (FloatBuffer)j3DBuffer.getBuffer();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\ncolor buffer must be ByteBuffer or FloatBuffer");
                    }
                }
            }
            if (CompressionStream.this.vertexNormals) {
                j3DBuffer = geometryArray.getNormalRefBuffer();
                this.initialNormalIndex = geometryArray.getInitialNormalIndex();
                switch (BufferWrapper.getBufferType(j3DBuffer)) {
                    case 3: {
                        this.normals = (FloatBuffer)j3DBuffer.getBuffer();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("\nnormal buffer must be FloatBuffer");
                    }
                }
            }
        }

        void copyVertex(int n, int n2, int n3, VertexCopy vertexCopy) {
            vertexCopy.p = this.positionsF != null ? new Point3f(this.positionsF.get(n + 0), this.positionsF.get(n + 1), this.positionsF.get(n + 2)) : new Point3f((float)this.positionsD.get((n *= 3) + 0), (float)this.positionsD.get(n + 1), (float)this.positionsD.get(n + 2));
            n2 *= 3;
            if (CompressionStream.this.vertexNormals) {
                vertexCopy.n = new Vector3f(this.normals.get(n2 + 0), this.normals.get(n2 + 1), this.normals.get(n2 + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                vertexCopy.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB.get(n3 + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n3 + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n3 + 2) & 0xFF) * 0.003921569f) : new Color3f(this.colorsF.get((n3 *= 3) + 0), this.colorsF.get(n3 + 1), this.colorsF.get(n3 + 2));
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vertexCopy.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB.get(n3 + 0) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n3 + 1) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n3 + 2) & 0xFF) * 0.003921569f, (float)(this.colorsB.get(n3 + 3) & 0xFF) * 0.003921569f) : new Color4f(this.colorsF.get((n3 *= 4) + 0), this.colorsF.get(n3 + 1), this.colorsF.get(n3 + 2), this.colorsF.get(n3 + 3));
                vertexCopy.c = vertexCopy.c4;
            }
        }

        public void processVertex(int n, int n2) {
            this.copyVertex(n + this.initialPositionIndex, n + this.initialNormalIndex, n + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n2);
        }
    }

    private class IndexedByRefGeometry
    extends ByRefGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByRefGeometry(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n, int n2) {
            CompressionStream.this.getVertexIndices(n, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n2);
        }
    }

    private class ByRefGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        byte[] colorsB = null;
        float[] colorsF = null;
        float[] normals = null;
        float[] positionsF = null;
        double[] positionsD = null;
        int initialPositionIndex = 0;
        int initialNormalIndex = 0;
        int initialColorIndex = 0;

        ByRefGeometry(GeometryArray geometryArray) {
            this.positionsF = geometryArray.getCoordRefFloat();
            this.positionsD = geometryArray.getCoordRefDouble();
            if (this.positionsF == null && this.positionsD == null) {
                throw new UnsupportedOperationException("\nby-reference access to Point3{d,f} arrays");
            }
            this.initialPositionIndex = geometryArray.getInitialCoordIndex();
            if (CompressionStream.this.vertexColors) {
                this.colorsB = geometryArray.getColorRefByte();
                this.colorsF = geometryArray.getColorRefFloat();
                if (this.colorsB == null && this.colorsF == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Color{3b,3f,4b,4f} arrays");
                }
                this.initialColorIndex = geometryArray.getInitialColorIndex();
            }
            if (CompressionStream.this.vertexNormals) {
                this.normals = geometryArray.getNormalRefFloat();
                if (this.normals == null) {
                    throw new UnsupportedOperationException("\nby-reference access to Normal3f array");
                }
                this.initialNormalIndex = geometryArray.getInitialNormalIndex();
            }
        }

        void copyVertex(int n, int n2, int n3, VertexCopy vertexCopy) {
            vertexCopy.p = this.positionsF != null ? new Point3f(this.positionsF[n + 0], this.positionsF[n + 1], this.positionsF[n + 2]) : new Point3f((float)this.positionsD[(n *= 3) + 0], (float)this.positionsD[n + 1], (float)this.positionsD[n + 2]);
            n2 *= 3;
            if (CompressionStream.this.vertexNormals) {
                vertexCopy.n = new Vector3f(this.normals[n2 + 0], this.normals[n2 + 1], this.normals[n2 + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                vertexCopy.c3 = this.colorsB != null ? new Color3f((float)(this.colorsB[n3 + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[n3 + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[n3 + 2] & 0xFF) * 0.003921569f) : new Color3f(this.colorsF[(n3 *= 3) + 0], this.colorsF[n3 + 1], this.colorsF[n3 + 2]);
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                vertexCopy.c4 = this.colorsB != null ? new Color4f((float)(this.colorsB[n3 + 0] & 0xFF) * 0.003921569f, (float)(this.colorsB[n3 + 1] & 0xFF) * 0.003921569f, (float)(this.colorsB[n3 + 2] & 0xFF) * 0.003921569f, (float)(this.colorsB[n3 + 3] & 0xFF) * 0.003921569f) : new Color4f(this.colorsF[(n3 *= 4) + 0], this.colorsF[n3 + 1], this.colorsF[n3 + 2], this.colorsF[n3 + 3]);
                vertexCopy.c = vertexCopy.c4;
            }
        }

        public void processVertex(int n, int n2) {
            this.copyVertex(n + this.initialPositionIndex, n + this.initialNormalIndex, n + this.initialColorIndex, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n2);
        }
    }

    private class IndexedInterleavedGeometryNIO
    extends InterleavedGeometryNIO {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n, int n2) {
            CompressionStream.this.getVertexIndices(n, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n2);
        }
    }

    private class InterleavedGeometryNIO
    extends InterleavedGeometry {
        FloatBuffer fbw;

        InterleavedGeometryNIO(GeometryArray geometryArray) {
            super(geometryArray);
            this.fbw = null;
            J3DBuffer j3DBuffer = geometryArray.getInterleavedVertexBuffer();
            if (BufferWrapper.getBufferType(j3DBuffer) != 3) {
                throw new IllegalArgumentException("\ninterleaved vertex buffer must be FloatBuffer");
            }
            this.fbw = (FloatBuffer)j3DBuffer.getBuffer();
        }

        void copyVertex(int n, int n2, int n3, VertexCopy vertexCopy) {
            int n4 = n * this.vstride;
            vertexCopy.p = new Point3f(this.fbw.get(n4 + this.poffset + 0), this.fbw.get(n4 + this.poffset + 1), this.fbw.get(n4 + this.poffset + 2));
            if (CompressionStream.this.vertexNormals) {
                n4 = n2 * this.vstride;
                vertexCopy.n = new Vector3f(this.fbw.get(n4 + this.noffset + 0), this.fbw.get(n4 + this.noffset + 1), this.fbw.get(n4 + this.noffset + 2));
            }
            if (CompressionStream.this.vertexColor3) {
                n4 = n3 * this.vstride;
                vertexCopy.c3 = new Color3f(this.fbw.get(n4 + this.coffset + 0), this.fbw.get(n4 + this.coffset + 1), this.fbw.get(n4 + this.coffset + 2));
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                n4 = n3 * this.vstride;
                vertexCopy.c4 = new Color4f(this.fbw.get(n4 + this.coffset + 0), this.fbw.get(n4 + this.coffset + 1), this.fbw.get(n4 + this.coffset + 2), this.fbw.get(n4 + this.coffset + 3));
                vertexCopy.c = vertexCopy.c4;
            }
        }
    }

    private class IndexedInterleavedGeometryFloat
    extends InterleavedGeometryFloat {
        IndexArrays ia;
        VertexIndices vi;

        IndexedInterleavedGeometryFloat(GeometryArray geometryArray) {
            super(geometryArray);
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n, int n2) {
            CompressionStream.this.getVertexIndices(n, this.ia, this.vi);
            this.copyVertex(this.vi.pi, this.vi.ni, this.vi.ci, this.vc);
            CompressionStream.this.processIndexedVertexCopy(this.vc, this.vi, n2);
        }
    }

    private class InterleavedGeometryFloat
    extends InterleavedGeometry {
        float[] vdata;

        InterleavedGeometryFloat(GeometryArray geometryArray) {
            super(geometryArray);
            this.vdata = null;
            this.vdata = geometryArray.getInterleavedVertices();
        }

        void copyVertex(int n, int n2, int n3, VertexCopy vertexCopy) {
            int n4 = n * this.vstride;
            vertexCopy.p = new Point3f(this.vdata[n4 + this.poffset + 0], this.vdata[n4 + this.poffset + 1], this.vdata[n4 + this.poffset + 2]);
            if (CompressionStream.this.vertexNormals) {
                n4 = n2 * this.vstride;
                vertexCopy.n = new Vector3f(this.vdata[n4 + this.noffset + 0], this.vdata[n4 + this.noffset + 1], this.vdata[n4 + this.noffset + 2]);
            }
            if (CompressionStream.this.vertexColor3) {
                n4 = n3 * this.vstride;
                vertexCopy.c3 = new Color3f(this.vdata[n4 + this.coffset + 0], this.vdata[n4 + this.coffset + 1], this.vdata[n4 + this.coffset + 2]);
                vertexCopy.c = vertexCopy.c3;
            } else if (CompressionStream.this.vertexColor4) {
                n4 = n3 * this.vstride;
                vertexCopy.c4 = new Color4f(this.vdata[n4 + this.coffset + 0], this.vdata[n4 + this.coffset + 1], this.vdata[n4 + this.coffset + 2], this.vdata[n4 + this.coffset + 3]);
                vertexCopy.c = vertexCopy.c4;
            }
        }
    }

    private abstract class InterleavedGeometry
    implements GeometryAccessor {
        VertexCopy vc = new VertexCopy();
        int vstride = 0;
        int coffset = 0;
        int noffset = 0;
        int poffset = 0;
        int tstride = 0;
        int tcount = 0;

        InterleavedGeometry(GeometryArray geometryArray) {
            if (CompressionStream.this.vertexTextures) {
                if (CompressionStream.this.vertexTexture2) {
                    this.tstride = 2;
                } else if (CompressionStream.this.vertexTexture3) {
                    this.tstride = 3;
                } else if (CompressionStream.this.vertexTexture4) {
                    this.tstride = 4;
                }
                this.tcount = geometryArray.getTexCoordSetCount();
                this.vstride += this.tcount * this.tstride;
            }
            if (CompressionStream.this.vertexColors) {
                this.coffset = this.vstride;
                this.vstride = CompressionStream.this.vertexColor3 ? (this.vstride += 3) : (this.vstride += 4);
            }
            if (CompressionStream.this.vertexNormals) {
                this.noffset = this.vstride;
                this.vstride += 3;
            }
            this.poffset = this.vstride;
            this.vstride += 3;
        }

        abstract void copyVertex(int var1, int var2, int var3, VertexCopy var4);

        public void processVertex(int n, int n2) {
            this.copyVertex(n, n, n, this.vc);
            CompressionStream.this.processVertexCopy(this.vc, n2);
        }
    }

    private static class VertexCopy {
        Object c = null;
        Point3f p = null;
        Vector3f n = null;
        Color3f c3 = null;
        Color4f c4 = null;

        private VertexCopy() {
        }
    }

    private class IndexedByCopyGeometry
    extends ByCopyGeometry {
        IndexArrays ia;
        VertexIndices vi;

        IndexedByCopyGeometry(GeometryArray geometryArray) {
            super(geometryArray, 0, geometryArray.getVertexCount());
            this.ia = new IndexArrays();
            this.vi = new VertexIndices();
            CompressionStream.this.getIndexArrays(geometryArray, this.ia);
        }

        public void processVertex(int n, int n2) {
            CompressionStream.this.getVertexIndices(n, this.ia, this.vi);
            int n3 = CompressionStream.this.meshBuffer.getMeshReference(this.vi.pi);
            MeshBuffer cfr_ignored_0 = CompressionStream.this.meshBuffer;
            if (n3 == -1 || CompressionStream.this.vertexNormals && this.vi.ni != CompressionStream.this.meshBuffer.getNormalIndex(n3)) {
                Vector3f vector3f;
                Point3f point3f = this.positions[this.vi.pi];
                Vector3f vector3f2 = vector3f = CompressionStream.this.vertexNormals ? this.normals[this.vi.ni] : null;
                Color3f color3f = CompressionStream.this.vertexColor3 ? this.colors3[this.vi.ci] : (CompressionStream.this.vertexColor4 ? this.colors4[this.vi.ci] : null);
                CompressionStream.this.addVertex(point3f, vector3f, (Object)color3f, n2, 1);
                CompressionStream.this.meshBuffer.push(this.vi.pi, this.vi.ci, this.vi.ni);
            } else {
                if (CompressionStream.this.vertexNormals) {
                    // empty if block
                }
                if (CompressionStream.this.vertexColor3 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(n3)) {
                    CompressionStream.this.addColor(this.colors3[this.vi.ci]);
                } else if (CompressionStream.this.vertexColor4 && this.vi.ci != CompressionStream.this.meshBuffer.getColorIndex(n3)) {
                    CompressionStream.this.addColor(this.colors4[this.vi.ci]);
                }
                CompressionStream.this.addMeshReference(n2, n3);
            }
        }
    }

    private static class VertexIndices {
        int pi;
        int ni;
        int ci;

        private VertexIndices() {
        }
    }

    private static class IndexArrays {
        int[] colorIndices = null;
        int[] normalIndices = null;
        int[] positionIndices = null;

        private IndexArrays() {
        }
    }

    private class ByCopyGeometry
    implements GeometryAccessor {
        Point3f[] positions = null;
        Vector3f[] normals = null;
        Color3f[] colors3 = null;
        Color4f[] colors4 = null;

        ByCopyGeometry(GeometryArray geometryArray) {
            this(geometryArray, geometryArray.getInitialVertexIndex(), geometryArray.getValidVertexCount());
        }

        ByCopyGeometry(GeometryArray geometryArray, int n, int n2) {
            int n3;
            this.positions = new Point3f[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.positions[n3] = new Point3f();
            }
            geometryArray.getCoordinates(n, this.positions);
            if (CompressionStream.this.vertexNormals) {
                this.normals = new Vector3f[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.normals[n3] = new Vector3f();
                }
                geometryArray.getNormals(n, this.normals);
            }
            if (CompressionStream.this.vertexColor3) {
                this.colors3 = new Color3f[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.colors3[n3] = new Color3f();
                }
                geometryArray.getColors(n, this.colors3);
            } else if (CompressionStream.this.vertexColor4) {
                this.colors4 = new Color4f[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    this.colors4[n3] = new Color4f();
                }
                geometryArray.getColors(n, this.colors4);
            }
        }

        public void processVertex(int n, int n2) {
            Point3f point3f = this.positions[n];
            int n3 = CompressionStream.this.meshBuffer.getMeshReference(point3f);
            MeshBuffer cfr_ignored_0 = CompressionStream.this.meshBuffer;
            if (n3 == -1 || CompressionStream.this.vertexNormals && !this.normals[n].equals((Tuple3f)CompressionStream.this.meshBuffer.getNormal(n3))) {
                Vector3f vector3f;
                Vector3f vector3f2 = vector3f = CompressionStream.this.vertexNormals ? this.normals[n] : null;
                Color3f color3f = CompressionStream.this.vertexColor3 ? this.colors3[n] : (CompressionStream.this.vertexColor4 ? this.colors4[n] : null);
                CompressionStream.this.addVertex(point3f, vector3f, (Object)color3f, n2, 1);
                CompressionStream.this.meshBuffer.push(point3f, (Object)color3f, vector3f);
            } else {
                if (CompressionStream.this.vertexNormals) {
                    // empty if block
                }
                if (CompressionStream.this.vertexColor3 && !this.colors3[n].equals((Tuple3f)CompressionStream.this.meshBuffer.getColor3(n3))) {
                    CompressionStream.this.addColor(this.colors3[n]);
                } else if (CompressionStream.this.vertexColor4 && !this.colors4[n].equals((Tuple4f)CompressionStream.this.meshBuffer.getColor4(n3))) {
                    CompressionStream.this.addColor(this.colors4[n]);
                }
                CompressionStream.this.addMeshReference(n2, n3);
            }
        }
    }

    private static interface GeometryAccessor {
        public void processVertex(int var1, int var2);
    }

    private class MeshReference
    extends CompressionStreamElement {
        int stripFlag;
        int meshIndex;

        MeshReference(int n, int n2) {
            this.stripFlag = n;
            this.meshIndex = n2;
            ++CompressionStream.this.meshReferenceCount;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStreamVertex compressionStreamVertex = CompressionStream.this.meshBuffer.getVertex(this.meshIndex);
            CompressionStream.this.lastPosition[0] = compressionStreamVertex.xAbsolute;
            CompressionStream.this.lastPosition[1] = compressionStreamVertex.yAbsolute;
            CompressionStream.this.lastPosition[2] = compressionStreamVertex.zAbsolute;
            if (!(compressionStreamVertex.color == null || CompressionStream.this.lastElementColor || CompressionStream.this.lastElementNormal && CompressionStream.this.lastLastElementColor)) {
                CompressionStream.this.lastColor[0] = compressionStreamVertex.color.rAbsolute;
                CompressionStream.this.lastColor[1] = compressionStreamVertex.color.gAbsolute;
                CompressionStream.this.lastColor[2] = compressionStreamVertex.color.bAbsolute;
                CompressionStream.this.lastColor[3] = compressionStreamVertex.color.aAbsolute;
            }
            if (!(compressionStreamVertex.normal == null || CompressionStream.this.lastElementNormal || CompressionStream.this.lastElementColor && CompressionStream.this.lastLastElementNormal)) {
                CompressionStream.this.lastSextant = compressionStreamVertex.normal.sextant;
                CompressionStream.this.lastOctant = compressionStreamVertex.normal.octant;
                CompressionStream.this.lastU = compressionStreamVertex.normal.uAbsolute;
                CompressionStream.this.lastV = compressionStreamVertex.normal.vAbsolute;
                CompressionStream.this.lastSpecialNormal = compressionStreamVertex.normal.specialNormal;
            }
        }

        void outputCommand(HuffmanTable huffmanTable, CommandStream commandStream) {
            int n = 32;
            long l = this.stripFlag & 1;
            commandStream.addCommand(n |= (this.meshIndex & 0xF) << 1 | this.stripFlag >> 1, 8, l, 1);
        }

        public String toString() {
            return "meshReference: stripFlag " + this.stripFlag + " meshIndex " + this.meshIndex;
        }
    }

    private class ColorQuant
    extends CompressionStreamElement {
        int value;

        ColorQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.colorQuant = this.value;
            CompressionStream.this.colorQuantChanged = true;
        }

        public String toString() {
            return "colorQuant: " + this.value;
        }
    }

    private class NormalQuant
    extends CompressionStreamElement {
        int value;

        NormalQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.normalQuant = this.value;
            CompressionStream.this.normalQuantChanged = true;
        }

        public String toString() {
            return "normalQuant: " + this.value;
        }
    }

    private class PositionQuant
    extends CompressionStreamElement {
        int value;

        PositionQuant(int n) {
            this.value = n;
        }

        void quantize(CompressionStream compressionStream, HuffmanTable huffmanTable) {
            CompressionStream.this.positionQuant = this.value;
            CompressionStream.this.positionQuantChanged = true;
            CompressionStream.this.scale = 2.0 / CompressionStream.this.positionRangeMaximum * ((double)((1 << this.value - 1) - 1) / (double)(1 << this.value - 1));
        }

        public String toString() {
            return "positionQuant: " + this.value;
        }
    }
}

