/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.test.util;

import com.jogamp.common.util.locks.SingletonInstance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class UITestCase {
    @Rule
    public TestName _unitTestName = new TestName();
    public static final String SINGLE_INSTANCE_LOCK_FILE = "UITestCase.lock";
    public static final int SINGLE_INSTANCE_LOCK_PORT = 59999;
    public static final long SINGLE_INSTANCE_LOCK_TO = 360000L;
    public static final long SINGLE_INSTANCE_LOCK_POLL = 1000L;
    private static volatile SingletonInstance singletonInstance;
    private static volatile boolean testSupported;
    private static volatile int maxMethodNameLen;
    static final String unsupportedTestMsg = "Test not supported on this platform.";

    private static final synchronized void initSingletonInstance() {
        if (null == singletonInstance && !(singletonInstance = SingletonInstance.createServerSocket(1000L, 59999)).tryLock(360000L)) {
            throw new RuntimeException("Fatal: Could not lock single instance: " + singletonInstance.getName());
        }
    }

    public static boolean isTestSupported() {
        return testSupported;
    }

    public static void setTestSupported(boolean bl) {
        System.err.println("setTestSupported: " + bl);
        testSupported = bl;
    }

    public int getMaxTestNameLen() {
        if (0 == maxMethodNameLen) {
            int n = 0;
            TestClass testClass = new TestClass(this.getClass());
            List list = testClass.getAnnotatedMethods(Test.class);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n2 = ((FrameworkMethod)iterator.next()).getName().length();
                if (n >= n2) continue;
                n = n2;
            }
            maxMethodNameLen = n;
        }
        return maxMethodNameLen;
    }

    public final String getTestMethodName() {
        return this._unitTestName.getMethodName();
    }

    public final String getSimpleTestName(String string) {
        return this.getClass().getSimpleName() + string + this.getTestMethodName();
    }

    public final String getFullTestName(String string) {
        return this.getClass().getName() + string + this.getTestMethodName();
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        UITestCase.initSingletonInstance();
    }

    @AfterClass
    public static void oneTimeTearDown() {
        System.gc();
        singletonInstance.unlock();
    }

    @Before
    public void setUp() {
        System.err.print("++++ UITestCase.setUp: " + this.getFullTestName(" - "));
        if (!testSupported) {
            System.err.println(" - Test not supported on this platform.");
            Assume.assumeTrue((boolean)testSupported);
        }
        System.err.println();
    }

    @After
    public void tearDown() {
        System.err.println("++++ UITestCase.tearDown: " + this.getFullTestName(" - "));
    }

    public static void waitForKey(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.err.println(string + "> Press enter to continue");
        try {
            System.err.println(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        testSupported = true;
        maxMethodNameLen = 0;
    }
}

