/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opencl.gl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opencl.CLCommandQueue;
import com.jogamp.opencl.CLDevice;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLMemory;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.CLProgram;
import com.jogamp.opencl.gl.CLGLBuffer;
import com.jogamp.opencl.gl.CLGLContext;
import com.jogamp.opencl.gl.CLGLTexture2d;
import com.jogamp.opencl.test.util.UITestCase;
import com.jogamp.opencl.util.CLDeviceFilters;
import com.jogamp.opencl.util.CLPlatformFilters;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class CLGLTest
extends UITestCase {
    private static GLContext glcontext;
    private static GLWindow glWindow;
    private static Window window;

    public static void initGL() {
        window = NewtFactory.createWindow(new GLCapabilities(GLProfile.getDefault()));
        Assert.assertNotNull((Object)window);
        window.setSize(640, 480);
        glWindow = GLWindow.create(window);
        Assert.assertNotNull((Object)glWindow);
        glWindow.setVisible(true);
        glcontext = glWindow.getContext();
    }

    private void deinitGL() throws GLException {
        glcontext.release();
        glWindow.destroy();
        window.destroy();
        glcontext = null;
        glWindow = null;
        window = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void createContextTest() {
        System.out.println(" - - - glcl; createContextTest - - - ");
        CLGLTest.initGL();
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.glSharing());
        CLDevice cLDevice = cLPlatform.getMaxFlopsDevice(CLDeviceFilters.glSharing());
        if (cLDevice == null) {
            System.out.println("Aborting test: no GLCL capable devices found.");
            return;
        }
        System.out.println("isGLMemorySharingSupported==true on: \n    " + cLDevice);
        System.out.println(cLDevice.getPlatform());
        Assert.assertNotNull((Object)glcontext);
        this.makeGLCurrent();
        Assert.assertTrue((boolean)glcontext.isCurrent());
        CLGLContext cLGLContext = CLGLContext.create(glcontext, cLDevice);
        Assert.assertNotNull((Object)cLGLContext);
        try {
            System.out.println(cLGLContext);
        }
        finally {
            cLGLContext.release();
            this.deinitGL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=15000L)
    public void vboSharing() {
        System.out.println(" - - - glcl; vboSharing - - - ");
        CLGLTest.initGL();
        this.makeGLCurrent();
        Assert.assertTrue((boolean)glcontext.isCurrent());
        CLPlatform cLPlatform = CLPlatform.getDefault(CLPlatformFilters.glSharing(glcontext));
        if (cLPlatform == null) {
            System.out.println("test aborted");
            return;
        }
        CLDevice cLDevice = cLPlatform.getMaxFlopsDevice(CLDeviceFilters.glSharing());
        System.out.println(cLDevice);
        CLGLContext cLGLContext = CLGLContext.create(glcontext, cLDevice);
        try {
            System.out.println(cLGLContext);
            GL2 gL2 = glcontext.getGL().getGL2();
            int[] nArray = new int[1];
            gL2.glGenBuffers(nArray.length, nArray, 0);
            IntBuffer intBuffer = Buffers.newDirectIntBuffer(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8});
            intBuffer.rewind();
            gL2.glEnableClientState(32884);
            gL2.glBindBuffer(34962, nArray[0]);
            gL2.glBufferData(34962, intBuffer.capacity() * 4, intBuffer, 35044);
            gL2.glBindBuffer(34962, 0);
            gL2.glDisableClientState(32884);
            gL2.glFinish();
            IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(9);
            CLGLBuffer<IntBuffer> cLGLBuffer = cLGLContext.createFromGLBuffer(intBuffer2, nArray[0], (long)(intBuffer.capacity() * 4), CLMemory.Mem.READ_ONLY);
            Assert.assertEquals((long)intBuffer.capacity(), (long)cLGLBuffer.getCLCapacity());
            Assert.assertEquals((long)(intBuffer.capacity() * 4), (long)cLGLBuffer.getCLSize());
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            cLCommandQueue.putAcquireGLObject(cLGLBuffer).putReadBuffer(cLGLBuffer, true).putReleaseGLObject(cLGLBuffer);
            while (intBuffer2.hasRemaining()) {
                Assert.assertEquals((long)intBuffer.get(), (long)intBuffer2.get());
            }
            System.out.println(cLGLBuffer);
            cLGLBuffer.release();
            gL2.glDeleteBuffers(1, nArray, 0);
        }
        finally {
            cLGLContext.release();
            this.deinitGL();
        }
    }

    @Test(timeout=15000L)
    public void textureSharing() {
        System.out.println(" - - - glcl; textureSharing - - - ");
        CLGLTest.initGL();
        this.makeGLCurrent();
        Assert.assertTrue((boolean)glcontext.isCurrent());
        CLPlatform[] cLPlatformArray = CLPlatform.listCLPlatforms(CLPlatformFilters.glSharing(glcontext));
        if (cLPlatformArray.length == 0) {
            System.out.println("no platform that supports OpenGL-OpenCL interoperability");
            return;
        }
        for (CLPlatform cLPlatform : cLPlatformArray) {
            CLDevice[] cLDeviceArray;
            for (CLDevice cLDevice : cLDeviceArray = cLPlatform.listCLDevices(CLDeviceFilters.glSharing())) {
                System.out.println(cLDevice);
                this.textureSharingInner(cLDevice);
            }
        }
        this.deinitGL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void textureSharingInner(CLDevice cLDevice) {
        CLGLContext cLGLContext = CLGLContext.create(glcontext, cLDevice);
        try {
            System.out.println(cLGLContext);
            GL2 gL2 = glcontext.getGL().getGL2();
            int[] nArray = new int[1];
            gL2.glGenTextures(nArray.length, nArray, 0);
            gL2.glActiveTexture(33984);
            gL2.glBindTexture(3553, nArray[0]);
            gL2.glTexImage2D(3553, 0, 6408, 2, 2, 0, 6408, 5121, null);
            gL2.glBindTexture(3553, 0);
            gL2.glFinish();
            ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(16);
            CLGLTexture2d<ByteBuffer> cLGLTexture2d = cLGLContext.createFromGLTexture2d(byteBuffer, 3553, nArray[0], 0, CLMemory.Mem.WRITE_ONLY);
            CLProgram cLProgram = cLGLContext.createProgram("__kernel void writeTexture (__write_only image2d_t imageTex, unsigned w, unsigned h ) \n{                                                                        \n    for(unsigned y=1; y<=h; ++y) {                                       \n        for(unsigned x=1; x<=w; ++x) {                                   \n            write_imagef(imageTex, (int2)(x-1,y-1), (float4)(((float)x)/((float)(4*w)), ((float)y)/((float)(4*h)), 0.0f, 1.0f)); \n        }                                                                \n    }                                                                    \n}");
            cLProgram.build();
            System.out.println(cLProgram.getBuildStatus());
            System.out.println(cLProgram.getBuildLog());
            Assert.assertTrue((boolean)cLProgram.isExecutable());
            CLKernel cLKernel = cLProgram.createCLKernel("writeTexture").putArg(cLGLTexture2d).putArg(2).putArg(2).rewind();
            CLCommandQueue cLCommandQueue = cLDevice.createCommandQueue();
            cLCommandQueue.putAcquireGLObject(cLGLTexture2d).put1DRangeKernel(cLKernel, 0L, 1L, 1L).putReadImage(cLGLTexture2d, true).putReleaseGLObject(cLGLTexture2d).finish();
            for (int i = 1; i <= 2; ++i) {
                for (int j = 1; j <= 2; ++j) {
                    byte by = byteBuffer.get();
                    byte by2 = byteBuffer.get();
                    byte by3 = byteBuffer.get();
                    byte by4 = byteBuffer.get();
                    byte by5 = (byte)((float)j / 8.0f * 256.0f);
                    byte by6 = (byte)((float)i / 8.0f * 256.0f);
                    Assert.assertEquals((long)by5, (long)by);
                    Assert.assertEquals((long)by6, (long)by2);
                    Assert.assertEquals((long)0L, (long)by3);
                    Assert.assertEquals((long)-1L, (long)by4);
                }
            }
            System.out.println(cLGLTexture2d);
            cLGLTexture2d.release();
            gL2.glDeleteBuffers(1, nArray, 0);
        }
        finally {
            cLGLContext.release();
        }
    }

    private void makeGLCurrent() {
        while (true) {
            try {
                glcontext.makeCurrent();
            }
            catch (RuntimeException runtimeException) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = CLGLTest.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }
}

