/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.TypeConfig;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import java.util.regex.Pattern;

public class ConstantDefinition
extends AliasedSymbol.AliasedSymbolImpl
implements TypeComparator.AliasedSemanticSymbol,
ASTLocusTag.ASTLocusTagProvider {
    private final boolean relaxedEqSem = TypeConfig.relaxedEqualSemanticsTest();
    private final String sValue;
    private final long iValue;
    private final boolean hasIntValue;
    private final boolean isEnum;
    private final String enumName;
    private final ASTLocusTag astLocus;
    public static Pattern patternHexNumber = Pattern.compile("0[xX][0-9a-fA-F]+[lLfFuU]?");
    public static Pattern patternDecimalNumber;
    private static String fpRegex;
    public static Pattern patternCPPOperand;

    public ConstantDefinition(String string, long l, String string2, ASTLocusTag aSTLocusTag) {
        super(string);
        this.sValue = String.valueOf(l);
        this.iValue = l;
        this.hasIntValue = true;
        this.isEnum = true;
        this.enumName = string2;
        this.astLocus = aSTLocusTag;
    }

    public ConstantDefinition(String string, String string2, ASTLocusTag aSTLocusTag) {
        super(string);
        boolean bl;
        long l;
        this.sValue = string2;
        try {
            l = Long.decode(string2);
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            l = 0L;
            bl = false;
        }
        this.iValue = l;
        this.hasIntValue = bl;
        this.isEnum = false;
        this.enumName = null;
        this.astLocus = aSTLocusTag;
    }

    @Override
    public ASTLocusTag getASTLocusTag() {
        return this.astLocus;
    }

    public final int hashCode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ConstantDefinition)) {
            return false;
        }
        ConstantDefinition constantDefinition = (ConstantDefinition)object;
        return ConstantDefinition.equals(this.getName(), constantDefinition.getName());
    }

    @Override
    public final int hashCodeSemantics() {
        int n = 31 + (null != this.getName() ? this.getName().hashCode() : 0);
        n = (n << 5) - n + (null != this.sValue ? this.sValue.hashCode() : 0);
        return (n << 5) - n + (null != this.enumName ? this.enumName.hashCode() : 0);
    }

    @Override
    public final boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
        if (semanticEqualityOp == this) {
            return true;
        }
        if (!(semanticEqualityOp instanceof ConstantDefinition)) {
            return false;
        }
        ConstantDefinition constantDefinition = (ConstantDefinition)semanticEqualityOp;
        if (!ConstantDefinition.equals(this.getName(), constantDefinition.getName()) || !ConstantDefinition.equals(this.enumName, constantDefinition.enumName)) {
            return false;
        }
        if (this.hasIntValue) {
            return this.iValue == constantDefinition.iValue;
        }
        return this.relaxedEqSem || ConstantDefinition.equals(this.sValue, constantDefinition.sValue);
    }

    public String getValue() {
        return this.sValue;
    }

    public String getEnumName() {
        return this.enumName;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public String toString() {
        return "ConstantDefinition [name " + this.getName() + ", value " + this.sValue + " (isInt " + this.hasIntValue + "), enumName " + this.enumName + ", isEnum " + this.isEnum + "]";
    }

    private static boolean equals(String string, String string2) {
        if (string == null || string2 == null) {
            return string == null && string2 == null;
        }
        return string.equals(string2);
    }

    public static boolean isConstantExpression(String string) {
        if (null != string && string.length() > 0) {
            if (ConstantDefinition.isNumber(string)) {
                return true;
            }
            String[] stringArray = string.split("[\\s\\(\\)]");
            int n = 0;
            for (String string2 : stringArray) {
                if (string2.length() <= 0 || ConstantDefinition.isCPPOperand(string2)) continue;
                if (ConstantDefinition.isNumber(string2)) {
                    ++n;
                    continue;
                }
                return false;
            }
            boolean bl = n > 0;
            return bl;
        }
        return false;
    }

    public static boolean isIdentifier(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (i == 0) {
                if (!Character.isJavaIdentifierStart(c)) continue;
                bl = true;
                continue;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static boolean isNumber(String string) {
        if (ConstantDefinition.isHexNumber(string)) {
            return true;
        }
        return ConstantDefinition.isDecimalNumber(string);
    }

    public static boolean isHexNumber(String string) {
        return patternHexNumber.matcher(string).matches();
    }

    public static boolean isDecimalNumber(String string) {
        return patternDecimalNumber.matcher(string).matches();
    }

    public static boolean isCPPOperand(String string) {
        return patternCPPOperand.matcher(string).matches();
    }

    static {
        fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
        patternDecimalNumber = Pattern.compile(fpRegex);
        patternCPPOperand = Pattern.compile("(?!" + fpRegex + ")[\\+\\-\\*\\/\\|\\&\\(\\)]|(\\<\\<)|(\\>\\>)");
    }
}

