/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Fog;
import javax.media.j3d.LinearFog;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

class LwsFog
extends TextfileParser {
    float minDist;
    float maxDist;
    float minAmount;
    float maxAmount;
    int backdropFog;
    Color3f color;
    int type;
    Fog fogObject = null;

    LwsFog(StreamTokenizer streamTokenizer, int n) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(n);
        this.debugOutput(1, "LwsFog()");
        this.color = new Color3f(0.0f, 0.0f, 0.0f);
        while (!this.isCurrentToken(streamTokenizer, "DitherIntensity")) {
            this.debugOutputLn(8, "currentToken = " + streamTokenizer.sval);
            if (this.isCurrentToken(streamTokenizer, "FogMinDist")) {
                this.minDist = (float)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "FogMaxDist")) {
                this.maxDist = (float)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "FogMinAmount")) {
                this.minAmount = (float)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "FogMaxAmount")) {
                this.maxAmount = (float)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "BackdropFog")) {
                this.backdropFog = (int)this.getNumber(streamTokenizer);
            } else if (this.isCurrentToken(streamTokenizer, "FogColor")) {
                this.color.x = (float)this.getNumber(streamTokenizer) / 255.0f;
                this.color.y = (float)this.getNumber(streamTokenizer) / 255.0f;
                this.color.z = (float)this.getNumber(streamTokenizer) / 255.0f;
            }
            try {
                streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
        streamTokenizer.pushBack();
    }

    void createJava3dObject() {
        this.fogObject = new LinearFog(this.color, (double)this.minDist, (double)this.maxDist);
        this.debugOutputLn(2, "just set linearFog with color, minDist, maxDist = " + this.color + ", " + this.minDist + ", " + this.maxDist);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        this.fogObject.setInfluencingBounds(boundingSphere);
    }

    Fog getObjectNode() {
        return this.fogObject;
    }

    void printVals() {
        this.debugOutputLn(2, "  FOG vals: ");
    }
}

