/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.Feature;
import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.LexerSource;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.Token;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nonnull;

public class CppReader
extends Reader
implements Closeable {
    private final Preprocessor cpp;
    private String token;
    private int idx;

    public CppReader(final @Nonnull Reader reader) {
        this.cpp = new Preprocessor(new LexerSource(reader, true){

            @Override
            public String getName() {
                return "<CppReader Input@" + System.identityHashCode(reader) + ">";
            }
        });
        this.token = "";
        this.idx = 0;
    }

    public CppReader(@Nonnull Preprocessor preprocessor) {
        this.cpp = preprocessor;
        this.token = "";
        this.idx = 0;
    }

    @Nonnull
    public Preprocessor getPreprocessor() {
        return this.cpp;
    }

    public void addMacro(@Nonnull String string) throws LexerException {
        this.cpp.addMacro(string);
    }

    public void addMacro(@Nonnull String string, @Nonnull String string2) throws LexerException {
        this.cpp.addMacro(string, string2);
    }

    private boolean refill() throws IOException {
        try {
            assert (this.cpp != null) : "cpp is null : was it closed?";
            if (this.token == null) {
                return false;
            }
            while (this.idx >= this.token.length()) {
                Token token = this.cpp.token();
                switch (token.getType()) {
                    case 265: {
                        this.token = null;
                        return false;
                    }
                    case 260: 
                    case 261: {
                        if (!this.cpp.getFeature(Feature.KEEPCOMMENTS)) {
                            this.token = " ";
                            break;
                        }
                    }
                    default: {
                        this.token = token.getText();
                    }
                }
                this.idx = 0;
            }
            return true;
        }
        catch (LexerException lexerException) {
            throw new IOException(String.valueOf(lexerException), lexerException);
        }
    }

    @Override
    public int read() throws IOException {
        if (!this.refill()) {
            return -1;
        }
        return this.token.charAt(this.idx++);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.token == null) {
            return -1;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                return i;
            }
            cArray[n + i] = (char)n3;
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        this.cpp.close();
        this.token = null;
    }
}

