/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr;

import com.jogamp.oculusvr.OVR;
import com.jogamp.oculusvr.OVRVersion;
import com.jogamp.oculusvr.OvrHmdContext;
import com.jogamp.oculusvr.ovrHmdDesc;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import jogamp.opengl.oculusvr.OVRStereoDevice;

public class OVRStereoDeviceFactory
extends StereoDeviceFactory {
    private boolean isValid = true;

    public static boolean isAvailable() {
        if (OVR.ovr_Initialize()) {
            boolean bl = false;
            int n = OVR.ovrHmd_Detect();
            System.err.println("Detect.0: ovrHmd_Detect() -> " + n);
            if (0 < n) {
                bl = true;
            } else {
                ovrHmdDesc ovrHmdDesc2 = OVR.ovrHmd_Create(0);
                if (null != ovrHmdDesc2) {
                    OvrHmdContext ovrHmdContext = ovrHmdDesc2.getHandle();
                    if (null != ovrHmdContext) {
                        bl = true;
                        System.err.println("Detect.1: hmdDesc: " + ovrHmdDesc2.getProductNameAsString());
                    }
                    OVR.ovrHmd_Destroy(ovrHmdDesc2);
                }
            }
            return bl;
        }
        System.err.println("ovr_Initialize() failed");
        return false;
    }

    private void dumpCaps(ovrHmdDesc ovrHmdDesc2, int n) {
        System.err.println(OVRVersion.getAvailableCapabilitiesInfo(ovrHmdDesc2, n, null).toString());
    }

    @Override
    protected final StereoDevice createDeviceImpl(int n, StereoDeviceConfig stereoDeviceConfig, boolean bl) {
        ovrHmdDesc ovrHmdDesc2 = OVR.ovrHmd_Create(n);
        if (null == ovrHmdDesc2) {
            if (bl) {
                System.err.println("Failed to create hmdCtx for device index " + n + " on thread " + Thread.currentThread().getName());
                Thread.dumpStack();
            }
            return null;
        }
        int n2 = ovrHmdDesc2.getHmdCaps();
        if (0 == (n2 & 8)) {
            System.err.println("Device " + n + " is not in ExtendDesktop mode as required.");
            this.dumpCaps(ovrHmdDesc2, n);
            return null;
        }
        if (bl) {
            this.dumpCaps(ovrHmdDesc2, n);
        }
        return new OVRStereoDevice(this, ovrHmdDesc2, n);
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public final void shutdown() {
        if (this.isValid) {
            OVR.ovr_Shutdown();
            this.isValid = false;
        }
    }
}

