/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.GenericUpstreamSurfacelessHook;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.nio.IntBuffer;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.WrappedSurface;
import jogamp.opengl.GLDrawableImpl;
import jogamp.opengl.egl.EGLDrawable;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLUpstreamSurfaceHook;

public class EGLSurface
extends WrappedSurface {
    static boolean DEBUG = EGLDrawable.DEBUG || ProxySurface.DEBUG;

    public static EGLSurface get(NativeSurface nativeSurface) {
        if (nativeSurface instanceof EGLSurface) {
            return (EGLSurface)nativeSurface;
        }
        return new EGLSurface(nativeSurface);
    }

    private EGLSurface(NativeSurface nativeSurface) {
        super(nativeSurface.getGraphicsConfiguration(), 0L, new EGLUpstreamSurfaceHook(nativeSurface), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().1: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public static EGLSurface createWrapped(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, l, upstreamSurfaceHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, long l, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(eGLGraphicsConfiguration, 0L, new EGLUpstreamSurfaceHook(eGLGraphicsConfiguration, l, upstreamSurfaceHook, bl), false);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().2: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public static EGLSurface createSurfaceless(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        return new EGLSurface(eGLGraphicsConfiguration, genericUpstreamSurfacelessHook, bl);
    }

    private EGLSurface(EGLGraphicsConfiguration eGLGraphicsConfiguration, GenericUpstreamSurfacelessHook genericUpstreamSurfacelessHook, boolean bl) {
        super(eGLGraphicsConfiguration, 0L, genericUpstreamSurfacelessHook, bl);
        if (EGLDrawableFactory.DEBUG) {
            System.err.println("EGLSurface.ctor().3: " + this);
            ProxySurfaceImpl.dumpHierarchy(System.err, this);
        }
    }

    public void setEGLSurfaceHandle() throws GLException {
        this.setSurfaceHandle(this.createEGLSurfaceHandle());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long createEGLSurfaceHandle() throws GLException {
        EGLGraphicsConfiguration eGLGraphicsConfiguration = (EGLGraphicsConfiguration)this.getGraphicsConfiguration();
        NativeSurface nativeSurface = this.getUpstreamSurface();
        boolean bl = ((GLCapabilitiesImmutable)eGLGraphicsConfiguration.getChosenCapabilities()).isPBuffer();
        long l = this.createEGLSurfaceHandle(bl, true, eGLGraphicsConfiguration, nativeSurface);
        if (0L == l) {
            int n = EGL.eglGetError();
            if (12299 != n || bl) throw new GLException("Creation of window surface w/ surface handle failed (1): " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(n));
            if (!EGLSurface.hasUniqueNativeWindowHandle(nativeSurface)) throw new GLException("Creation of window surface w/ surface handle failed (2): " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(n));
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": Info: Creation of window surface w/ surface handle failed: " + eGLGraphicsConfiguration + ", error " + GLDrawableImpl.toHexString(n) + ", retry w/ windowHandle");
            }
            if (0L == (l = this.createEGLSurfaceHandle(bl, false, eGLGraphicsConfiguration, nativeSurface))) {
                throw new GLException("Creation of window surface w/ window handle failed: " + eGLGraphicsConfiguration + ", " + this + ", error " + GLDrawableImpl.toHexString(EGL.eglGetError()));
            }
        }
        if (!DEBUG) return l;
        System.err.println(EGLSurface.getThreadName() + ": createEGLSurface handle " + GLDrawableImpl.toHexString(l));
        return l;
    }

    private long createEGLSurfaceHandle(boolean bl, boolean bl2, EGLGraphicsConfiguration eGLGraphicsConfiguration, NativeSurface nativeSurface) {
        if (bl) {
            return EGLDrawableFactory.createPBufferSurfaceImpl(eGLGraphicsConfiguration, this.getSurfaceWidth(), this.getSurfaceHeight(), false);
        }
        if (bl2) {
            return EGL.eglCreateWindowSurface(eGLGraphicsConfiguration.getScreen().getDevice().getHandle(), eGLGraphicsConfiguration.getNativeConfig(), nativeSurface.getSurfaceHandle(), null);
        }
        return EGL.eglCreateWindowSurface(eGLGraphicsConfiguration.getScreen().getDevice().getHandle(), eGLGraphicsConfiguration.getNativeConfig(), ((NativeWindow)nativeSurface).getWindowHandle(), null);
    }

    private static boolean hasUniqueNativeWindowHandle(NativeSurface nativeSurface) {
        return nativeSurface instanceof NativeWindow && ((NativeWindow)nativeSurface).getWindowHandle() != nativeSurface.getSurfaceHandle();
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static boolean isValidEGLSurfaceHandle(long l, long l2) {
        if (0L == l2) {
            return false;
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        boolean bl = EGL.eglQuerySurface(l, l2, 12328, intBuffer);
        if (!bl) {
            int n = EGL.eglGetError();
            if (DEBUG) {
                System.err.println(EGLSurface.getThreadName() + ": EGLSurface.isValidEGLSurfaceHandle eglQuerySuface failed: error " + GLDrawableImpl.toHexString(n) + ", " + GLDrawableImpl.toHexString(l2));
            }
        }
        return bl;
    }
}

