/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.opengl.test.junit.jogl.util.texture.PNGTstFiles;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPNGPixelRect00NEWT
extends UITestCase {
    @Test
    public void testPNGRead01_All() throws InterruptedException, IOException, MalformedURLException {
        for (int i = 0; i < PNGTstFiles.allBasenames.length; ++i) {
            String string = PNGTstFiles.allBasenames[i];
            this.testPNG01Impl("", string, null, 0, false);
        }
    }

    @Test
    public void testPNGRead02_RGB888_to_RGBA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 0, false);
    }

    @Test
    public void testPNGRead03_RGB888_to_RGBA8888_stride1000() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 1000, false);
    }

    @Test
    public void testPNGRead04_RGB888_to_RGBA8888_stride999() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_3-01-160x90", PixelFormat.RGBA8888, 999, false);
    }

    @Test
    public void testPNGRead11_RGBA8888_to_LUMINA() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.LUMINANCE, 0, false);
    }

    @Test
    public void testPNGRead12_RGBA8888_to_RGB888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.RGB888, 0, false);
    }

    @Test
    public void testPNGRead13_RGBA8888_to_BGR888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGR888, 0, false);
    }

    @Test
    public void testPNGRead14_RGBA8888_to_BGRA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGRA8888, 0, false);
    }

    @Test
    public void testPNGRead15_RGBA8888_to_ARGB8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.ARGB8888, 0, false);
    }

    @Test
    public void testPNGRead16_RGBA8888_to_ABGR8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG02Impl("", "test-ntscN_4-01-160x90", PixelFormat.ABGR8888, 0, false);
    }

    private void testPNG01Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test01: " + string + string2 + ".png, destFmt " + (Object)((Object)pixelFormat) + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        File file = new File(this.getSimpleTestName(".") + "-01-" + string2 + "-orig.png");
        File file2 = new File(this.getSimpleTestName(".") + "-02-" + string2 + "-flipped.png");
        File file3 = new File(this.getSimpleTestName(".") + "-03-" + string2 + "-reversed.png");
        File file4 = new File(this.getSimpleTestName(".") + "-04-" + string2 + "-reversed_flipped.png");
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string + string2 + ".png");
        if (null == uRLConnection) {
            throw new IOException("Cannot find " + string + string2 + ".png");
        }
        PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), pixelFormat, false, n, bl);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        Object object = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
        pNGPixelRect.write((OutputStream)object, true);
        Object object2 = PNGPixelRect.read(file.toURI().toURL().openStream(), pNGPixelRect.getPixelformat(), false, n, bl);
        System.err.println("PNGPixelRect - Orig (Read Back): " + object2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)((PixelRectangle.GenericPixelRect)object2).getPixels());
        object = new PNGPixelRect(pNGPixelRect.getPixelformat(), pNGPixelRect.getSize(), pNGPixelRect.getStride(), !pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Flip : " + object);
        object2 = new BufferedOutputStream(IOUtil.getFileOutputStream(file2, true));
        ((PNGPixelRect)object).write((OutputStream)object2, true);
        Object object3 = PNGPixelRect.read(file2.toURI().toURL().openStream(), pNGPixelRect.getPixelformat(), false, n, !bl);
        System.err.println("PNGPixelRect - Flip (Read Back): " + object3);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)((PixelRectangle.GenericPixelRect)object3).getPixels());
        object = PixelFormatUtil.getReversed(pNGPixelRect.getPixelformat());
        object2 = new PNGPixelRect((PixelFormat)((Object)object), pNGPixelRect.getSize(), pNGPixelRect.getStride(), pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Reversed : " + object2);
        object3 = new BufferedOutputStream(IOUtil.getFileOutputStream(file3, true));
        ((PNGPixelRect)object2).write((OutputStream)object3, true);
        PNGPixelRect pNGPixelRect2 = PNGPixelRect.read(file3.toURI().toURL().openStream(), (PixelFormat)((Object)object), false, n, bl);
        System.err.println("PNGPixelRect - Reversed (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
        object2 = new PNGPixelRect((PixelFormat)((Object)object), pNGPixelRect.getSize(), pNGPixelRect.getStride(), !pNGPixelRect.isGLOriented(), pNGPixelRect.getPixels(), pNGPixelRect.getDpi()[0], pNGPixelRect.getDpi()[1]);
        System.err.println("PNGPixelRect - Reversed+Flipped : " + object2);
        object3 = new BufferedOutputStream(IOUtil.getFileOutputStream(file4, true));
        ((PNGPixelRect)object2).write((OutputStream)object3, true);
        pNGPixelRect2 = PNGPixelRect.read(file4.toURI().toURL().openStream(), (PixelFormat)((Object)object), false, n, !bl);
        System.err.println("PNGPixelRect - Reversed+FLipped (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
    }

    private void testPNG02Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test02: " + string + string2 + ".png, destFmt " + (Object)((Object)pixelFormat) + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        File file = new File(this.getSimpleTestName(".") + "-" + string2 + "-orig.png");
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string + string2 + ".png");
        PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), pixelFormat, false, n, bl);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(IOUtil.getFileOutputStream(file, true));
        pNGPixelRect.write(bufferedOutputStream, true);
        PNGPixelRect pNGPixelRect2 = PNGPixelRect.read(file.toURI().toURL().openStream(), pNGPixelRect.getPixelformat(), false, n, bl);
        System.err.println("PNGPixelRect - Orig (Read Back): " + pNGPixelRect2);
        Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pNGPixelRect2.getPixels());
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPNGPixelRect00NEWT.class.getName()});
    }
}

