/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.math;

import com.jogamp.opengl.math.FloatUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestFloatUtil01NOUI {
    static final float MACH_EPSILON = FloatUtil.getMachineEpsilon();
    static boolean deltaMachEpsLEQEpsilon;
    static boolean deltaFixedEpsLEQEpsilon;

    @BeforeClass
    public static void test00Epsilon() {
        System.err.println();
        System.err.println("Machine Epsilon: " + MACH_EPSILON);
        System.err.println("Fixed   Epsilon: 1.1920929E-7, diff " + Math.abs(MACH_EPSILON - 1.1920929E-7f));
        System.err.println("Float MIN:       1.4E-45");
        float f = Math.abs(MACH_EPSILON - Float.MIN_VALUE);
        deltaMachEpsLEQEpsilon = FloatUtil.compare(f, MACH_EPSILON) <= 0;
        float f2 = Math.abs(MACH_EPSILON - Float.MIN_VALUE);
        deltaFixedEpsLEQEpsilon = FloatUtil.compare(f2, MACH_EPSILON) <= 0;
        System.err.println("deltaMachEpsMin " + f + ", deltaMachEpsLEQEpsilon " + deltaMachEpsLEQEpsilon);
        System.err.println("deltaFixedEpsMin " + f2 + ", deltaFixedEpsLEQEpsilon " + deltaFixedEpsLEQEpsilon);
    }

    private void dumpTestWE(int n, int n2, float f, float f2, float f3) {
        float f4 = f - f2;
        boolean bl = FloatUtil.isEqual(f, f2, f3);
        int n3 = FloatUtil.compare(f, f2, f3);
        String string = n2 != n3 ? "**** mismatch ****" : " OK";
        System.err.println("Print.WE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f4 + ", exp " + n2 + ", equal " + bl + ", comp " + n3 + " - " + string + ", epsilon " + f3);
    }

    private void dumpTestNE(int n, int n2, float f, float f2) {
        float f3 = f - f2;
        boolean bl = FloatUtil.isEqual(f, f2);
        int n3 = FloatUtil.compare(f, f2);
        String string = n2 != n3 ? "**** mismatch ****" : " OK";
        System.err.println("Print.NE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f3 + ", exp " + n2 + ", equal " + bl + ", comp " + n3 + " - " + string);
    }

    @Test
    public void test01aZeroWithFixedEpsilon() {
        this.testZeroWithEpsilon(10, 1.1920929E-7f);
    }

    @Test
    public void test01bZeroWithMachEpsilon() {
        this.testZeroWithEpsilon(100, MACH_EPSILON);
    }

    private void testZeroWithEpsilon(int n, float f) {
        System.err.println();
        this.testZeroWithEpsilon(n++, true, 0.0f, f);
        this.testZeroWithEpsilon(n++, true, 0.0f - f / 2.0f, f);
        this.testZeroWithEpsilon(n++, true, 0.0f + f / 2.0f, f);
        this.testZeroWithEpsilon(n++, true, -1.4E-45f, f);
        this.testZeroWithEpsilon(n++, true, Float.MIN_VALUE, f);
        this.testZeroWithEpsilon(n++, true, -0.0f, f);
        this.testZeroWithEpsilon(n++, true, 0.0f, f);
        this.testZeroWithEpsilon(n++, false, 0.0f + f + Float.MIN_VALUE, f);
        this.testZeroWithEpsilon(n++, false, 0.0f - f - Float.MIN_VALUE, f);
        this.dumpTestWE(n++, 1, 0.0f, 0.0f + f - Float.MIN_VALUE, f);
        this.dumpTestWE(n++, 1, 0.0f, 0.0f - f + Float.MIN_VALUE, f);
    }

    private void testZeroWithEpsilon(int n, boolean bl, float f, float f2) {
        boolean bl2 = FloatUtil.isZero(f, f2);
        float f3 = f - 0.0f;
        System.err.println("Zero." + n + ": a: " + f + ", -> d " + f3 + ", exp " + bl + ", zero " + bl2 + ", epsilon " + f2);
        Assert.assertEquals((String)("Zero failed a: " + f + " within " + f2), (Object)bl, (Object)bl2);
    }

    @Test
    public void test02EqualsNoEpsilon() {
        int n = 0;
        System.err.println();
        this.testEqualsNoEpsilon(n++, true, 0.0f, 0.0f);
        this.testEqualsNoEpsilon(n++, true, Float.MAX_VALUE, Float.MAX_VALUE);
        this.testEqualsNoEpsilon(n++, true, Float.MIN_VALUE, Float.MIN_VALUE);
        this.testEqualsNoEpsilon(n++, true, Float.MIN_NORMAL, Float.MIN_NORMAL);
        this.testEqualsNoEpsilon(n++, true, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.testEqualsNoEpsilon(n++, true, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.testEqualsNoEpsilon(n++, true, Float.NaN, Float.NaN);
        this.testEqualsNoEpsilon(n++, false, -0.0f, 0.0f);
        this.testEqualsNoEpsilon(n++, false, 0.0f, -0.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f - MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 0.0f, 0.0f - MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f + MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 0.0f, 0.0f + MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f);
        this.dumpTestNE(n++, 0, 0.0f, -1.4E-45f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f);
        this.dumpTestNE(n++, 0, 0.0f, Float.MIN_VALUE);
    }

    private void testEqualsNoEpsilon(int n, boolean bl, float f, float f2) {
        boolean bl2 = FloatUtil.isEqual(f, f2);
        int n2 = FloatUtil.compare(f, f2);
        float f3 = f - f2;
        System.err.println("Equal.NE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f3 + ", exp " + bl + ", equal " + bl2 + ", comp " + n2);
        Assert.assertEquals((String)("Compare failed a: " + f + ", b: " + f2), (Object)bl, (Object)(0 == n2 ? 1 : 0));
        Assert.assertEquals((String)("Equal failed a: " + f + ", b: " + f2), (Object)bl, (Object)bl2);
    }

    @Test
    public void test03aEqualsWithFixedEpsilon() {
        this.testEqualsWithEpsilon(10, 1.1920929E-7f);
    }

    @Test
    public void test03bEqualsWithMachEpsilon() {
        this.testEqualsWithEpsilon(50, MACH_EPSILON);
    }

    private void testEqualsWithEpsilon(int n, float f) {
        System.err.println();
        this.testEqualsWithEpsilon(n++, true, 0.0f, 0.0f, f);
        this.testEqualsWithEpsilon(n++, true, 1.0f, 1.0f - f / 2.0f, f);
        this.testEqualsWithEpsilon(n++, true, 1.0f, 1.0f + f / 2.0f, f);
        this.testEqualsWithEpsilon(n++, true, 1.0f, 1.0f, f);
        this.testEqualsWithEpsilon(n++, true, 1.0f, 1.0f, f);
        this.testEqualsWithEpsilon(n++, true, Float.MAX_VALUE, Float.MAX_VALUE, f);
        this.testEqualsWithEpsilon(n++, true, Float.MIN_VALUE, Float.MIN_VALUE, f);
        this.testEqualsWithEpsilon(n++, true, Float.MIN_NORMAL, Float.MIN_NORMAL, f);
        this.testEqualsWithEpsilon(n++, true, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, f);
        this.testEqualsWithEpsilon(n++, true, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, f);
        this.testEqualsWithEpsilon(n++, true, Float.NaN, Float.NaN, f);
        this.testEqualsWithEpsilon(n++, true, -0.0f, 0.0f, f);
        this.testEqualsWithEpsilon(n++, true, 0.0f, -0.0f, f);
        this.testEqualsWithEpsilon(n++, false, 1.0f, 1.0f + f + Float.MIN_VALUE, f);
        this.testEqualsWithEpsilon(n++, false, 1.0f, 1.0f - f - Float.MIN_VALUE, f);
        this.dumpTestWE(n++, 1, 1.0f, 1.0f + f - Float.MIN_VALUE, f);
        this.dumpTestWE(n++, 1, 1.0f, 1.0f - f + Float.MIN_VALUE, f);
    }

    private void testEqualsWithEpsilon(int n, boolean bl, float f, float f2, float f3) {
        boolean bl2 = FloatUtil.isEqual(f, f2, f3);
        int n2 = FloatUtil.compare(f, f2, f3);
        float f4 = f - f2;
        System.err.println("Equal.WE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f4 + ", exp " + bl + ", equal " + bl2 + ", comp " + n2);
        Assert.assertEquals((String)("Compare failed a: " + f + ", b: " + f2 + " within " + f3), (Object)bl, (Object)(0 == n2 ? 1 : 0));
        Assert.assertEquals((String)("Equal failed a: " + f + ", b: " + f2 + " within " + f3), (Object)bl, (Object)bl2);
    }

    @Test
    public void test04CompareNoEpsilon() {
        int n = 0;
        System.err.println();
        this.testCompareNoEpsilon(n++, 0, 0.0f, 0.0f);
        this.testCompareNoEpsilon(n++, 0, Float.MAX_VALUE, Float.MAX_VALUE);
        this.testCompareNoEpsilon(n++, 0, Float.MIN_VALUE, Float.MIN_VALUE);
        this.testCompareNoEpsilon(n++, 0, Float.MIN_NORMAL, Float.MIN_NORMAL);
        this.testCompareNoEpsilon(n++, 0, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.testCompareNoEpsilon(n++, 0, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.testCompareNoEpsilon(n++, 0, Float.NaN, Float.NaN);
        this.testCompareNoEpsilon(n++, 1, 1.0f, 0.0f);
        this.testCompareNoEpsilon(n++, -1, 0.0f, 1.0f);
        this.testCompareNoEpsilon(n++, 1, 0.0f, -1.0f);
        this.testCompareNoEpsilon(n++, -1, -1.0f, 0.0f);
        this.testCompareNoEpsilon(n++, 1, Float.MAX_VALUE, Float.MIN_VALUE);
        this.testCompareNoEpsilon(n++, -1, Float.MIN_VALUE, Float.MAX_VALUE);
        this.testCompareNoEpsilon(n++, 1, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY);
        this.testCompareNoEpsilon(n++, -1, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY);
        this.testCompareNoEpsilon(n++, -1, 0.0f, Float.NaN);
        this.testCompareNoEpsilon(n++, 1, Float.NaN, 0.0f);
        this.testCompareNoEpsilon(n++, -1, -0.0f, 0.0f);
        this.testCompareNoEpsilon(n++, 1, 0.0f, -0.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f - MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 0.0f, 0.0f - MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f + MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 0.0f, 0.0f + MACH_EPSILON / 2.0f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f);
        this.dumpTestNE(n++, 0, 0.0f, -1.4E-45f);
        this.dumpTestNE(n++, 0, 1.0f, 1.0f);
        this.dumpTestNE(n++, 0, 0.0f, Float.MIN_VALUE);
    }

    private void testCompareNoEpsilon(int n, int n2, float f, float f2) {
        boolean bl = FloatUtil.isEqual(f, f2);
        int n3 = FloatUtil.compare(f, f2);
        float f3 = f - f2;
        System.err.println("Comp.NE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f3 + ", equal " + bl + ", comp: exp " + n2 + " has " + n3);
        Assert.assertEquals((String)("Compare failed a: " + f + ", b: " + f2), (long)n2, (long)n3);
    }

    @Test
    public void test05aCompareWithFixedEpsilon() {
        this.test05CompareWithEpsilon(10, 1.1920929E-7f);
    }

    @Test
    public void test05bCompareWithMachEpsilon() {
        this.test05CompareWithEpsilon(50, MACH_EPSILON);
    }

    private void test05CompareWithEpsilon(int n, float f) {
        System.err.println();
        this.testCompareWithEpsilon(n++, 0, 0.0f, 0.0f, f);
        this.testCompareWithEpsilon(n++, 0, 1.0f, 1.0f - f / 2.0f, f);
        this.testCompareWithEpsilon(n++, 0, 1.0f, 1.0f + f / 2.0f, f);
        this.testCompareWithEpsilon(n++, 0, 1.0f, 1.0f, f);
        this.testCompareWithEpsilon(n++, 0, 1.0f, 1.0f, f);
        this.testCompareWithEpsilon(n++, 0, Float.MAX_VALUE, Float.MAX_VALUE, f);
        this.testCompareWithEpsilon(n++, 0, Float.MIN_VALUE, Float.MIN_VALUE, f);
        this.testCompareWithEpsilon(n++, 0, Float.MIN_NORMAL, Float.MIN_NORMAL, f);
        this.testCompareWithEpsilon(n++, 0, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, f);
        this.testCompareWithEpsilon(n++, 0, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, f);
        this.testCompareWithEpsilon(n++, 0, Float.NaN, Float.NaN, f);
        this.testCompareWithEpsilon(n++, 1, 1.0f, 0.0f, f);
        this.testCompareWithEpsilon(n++, -1, 0.0f, 1.0f, f);
        this.testCompareWithEpsilon(n++, 1, 0.0f, -1.0f, f);
        this.testCompareWithEpsilon(n++, -1, -1.0f, 0.0f, f);
        this.testCompareWithEpsilon(n++, 1, Float.MAX_VALUE, Float.MIN_VALUE, f);
        this.testCompareWithEpsilon(n++, -1, Float.MIN_VALUE, Float.MAX_VALUE, f);
        this.testCompareWithEpsilon(n++, 1, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, f);
        this.testCompareWithEpsilon(n++, -1, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, f);
        this.testCompareWithEpsilon(n++, -1, 0.0f, Float.NaN, f);
        this.testCompareWithEpsilon(n++, 1, Float.NaN, 0.0f, f);
        this.testCompareWithEpsilon(n++, 0, -0.0f, 0.0f, f);
        this.testCompareWithEpsilon(n++, 0, 0.0f, -0.0f, f);
    }

    private void testCompareWithEpsilon(int n, int n2, float f, float f2, float f3) {
        boolean bl = FloatUtil.isEqual(f, f2, f3);
        int n3 = FloatUtil.compare(f, f2, f3);
        float f4 = f - f2;
        System.err.println("Comp.WE." + n + ": a: " + f + ", b: " + f2 + " -> d " + f4 + ", equal " + bl + ", comp: exp " + n2 + " has " + n3);
        Assert.assertEquals((String)("Compare failed a: " + f + ", b: " + f2 + " within " + f3), (long)n2, (long)n3);
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestFloatUtil01NOUI.class.getName()});
    }
}

