/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.glsl;

import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.jogl.glsl.GLSLMiscHelper;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.NEWTGLContext;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import com.jogamp.opengl.util.glsl.ShaderState;
import java.io.IOException;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLSLShaderState01NEWT
extends UITestCase {
    static long durationPerTest = 10L;
    static boolean firstUIActionOnProcess = false;
    static final int vertices0_loc = 0;
    static final int colors0_loc = 1;

    @Test
    public void test00NoShaderState_Validation() throws InterruptedException {
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(new GLCapabilities(GLProfile.getGL2ES2()), 480, 480, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        System.err.println(windowContext.context);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        Assert.assertTrue((0 == shaderProgram.program() ? 1 : 0) != 0);
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        Assert.assertTrue((0 != shaderProgram.program() ? 1 : 0) != 0);
        Assert.assertTrue((!shaderProgram.inUse() ? 1 : 0) != 0);
        Assert.assertTrue((!shaderProgram.linked() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertTrue((boolean)shaderProgram.link(gL2ES2, System.err));
        shaderProgram.useProgram(gL2ES2, true);
        GLArrayDataServer gLArrayDataServer = GLSLMiscHelper.createVertices(gL2ES2, null, shaderProgram.program(), 0, GLSLMiscHelper.vertices0);
        System.err.println("vertices0: " + gLArrayDataServer);
        gLArrayDataServer.enableBuffer(gL2ES2, false);
        Assert.assertEquals((long)0L, (long)gLArrayDataServer.getLocation());
        GLArrayDataServer gLArrayDataServer2 = GLSLMiscHelper.createColors(gL2ES2, null, shaderProgram.program(), 1, GLSLMiscHelper.colors0);
        System.err.println("colors0: " + gLArrayDataServer2);
        gLArrayDataServer2.enableBuffer(gL2ES2, false);
        Assert.assertEquals((long)1L, (long)gLArrayDataServer2.getLocation());
        Assert.assertTrue((boolean)shaderProgram.link(gL2ES2, System.err));
        Assert.assertTrue((boolean)shaderProgram.linked());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertEquals((long)0L, (long)gLArrayDataServer.getLocation());
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, null, gLArrayDataServer);
        Assert.assertEquals((long)1L, (long)gLArrayDataServer2.getLocation());
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, null, gLArrayDataServer2);
        shaderProgram.useProgram(gL2ES2, true);
        Assert.assertTrue((boolean)shaderProgram.inUse());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        PMVMatrix pMVMatrix = new PMVMatrix();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        gLUniformData.setLocation(gL2ES2, shaderProgram.program());
        gL2ES2.glUniform(gLUniformData);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        GLArrayDataServer gLArrayDataServer3 = GLSLMiscHelper.createVertices(gL2ES2, null, shaderProgram.program(), -1, GLSLMiscHelper.vertices1);
        System.err.println("vertices1: " + gLArrayDataServer3);
        gLArrayDataServer3.enableBuffer(gL2ES2, false);
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, null, gLArrayDataServer3);
        GLArrayDataServer gLArrayDataServer4 = GLSLMiscHelper.createColors(gL2ES2, null, shaderProgram.program(), -1, GLSLMiscHelper.colors1);
        System.err.println("colors1: " + gLArrayDataServer4);
        gLArrayDataServer4.enableBuffer(gL2ES2, false);
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, null, gLArrayDataServer4);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(45.0f, (float)gLDrawable.getSurfaceWidth() / (float)gLDrawable.getSurfaceHeight(), 1.0f, 100.0f);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        gL2ES2.glUniform(gLUniformData);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, null, true, gLArrayDataServer, gLArrayDataServer2, true, 1, durationPerTest);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, null, true, gLArrayDataServer3, gLArrayDataServer4, true, 2, durationPerTest);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, null, true, gLArrayDataServer, gLArrayDataServer2, true, 3, durationPerTest);
        shaderProgram.useProgram(gL2ES2, false);
        shaderProgram.destroy(gL2ES2);
        gLArrayDataServer3.destroy(gL2ES2);
        gLArrayDataServer2.destroy(gL2ES2);
        gLArrayDataServer4.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test
    public void test01ShaderState_Validation() throws InterruptedException {
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(new GLCapabilities(GLProfile.getGL2ES2()), 480, 480, true);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        System.err.println(windowContext.context);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        ShaderState shaderState = new ShaderState();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        Assert.assertTrue((0 == shaderProgram.program() ? 1 : 0) != 0);
        shaderProgram.add(gL2ES2, shaderCode, System.err);
        shaderProgram.add(gL2ES2, shaderCode2, System.err);
        Assert.assertTrue((0 != shaderProgram.program() ? 1 : 0) != 0);
        Assert.assertTrue((!shaderProgram.inUse() ? 1 : 0) != 0);
        Assert.assertTrue((!shaderProgram.linked() ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        shaderState.attachShaderProgram(gL2ES2, shaderProgram, false);
        Assert.assertTrue((!shaderProgram.inUse() ? 1 : 0) != 0);
        Assert.assertTrue((!shaderProgram.linked() ? 1 : 0) != 0);
        GLArrayDataServer gLArrayDataServer = GLSLMiscHelper.createVertices(gL2ES2, shaderState, 0, 0, GLSLMiscHelper.vertices0);
        System.err.println("vertices0: " + gLArrayDataServer);
        gLArrayDataServer.enableBuffer(gL2ES2, false);
        Assert.assertEquals((long)0L, (long)gLArrayDataServer.getLocation());
        GLArrayDataServer gLArrayDataServer2 = GLSLMiscHelper.createColors(gL2ES2, shaderState, 0, 1, GLSLMiscHelper.colors0);
        System.err.println("colors0: " + gLArrayDataServer2);
        gLArrayDataServer2.enableBuffer(gL2ES2, false);
        Assert.assertEquals((long)1L, (long)gLArrayDataServer2.getLocation());
        Assert.assertTrue((boolean)shaderProgram.link(gL2ES2, System.err));
        Assert.assertTrue((boolean)shaderProgram.linked());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertEquals((long)0L, (long)gLArrayDataServer.getLocation());
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer);
        Assert.assertEquals((long)1L, (long)gLArrayDataServer2.getLocation());
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer2);
        shaderState.useProgram(gL2ES2, true);
        Assert.assertTrue((boolean)shaderProgram.inUse());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        PMVMatrix pMVMatrix = new PMVMatrix();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        shaderState.ownUniform(gLUniformData);
        shaderState.uniform(gL2ES2, gLUniformData);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        Assert.assertEquals((Object)gLUniformData, (Object)shaderState.getUniform("mgl_PMVMatrix"));
        GLArrayDataServer gLArrayDataServer3 = GLSLMiscHelper.createVertices(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.vertices1);
        System.err.println("vertices1: " + gLArrayDataServer3);
        gLArrayDataServer3.enableBuffer(gL2ES2, false);
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer3);
        GLArrayDataServer gLArrayDataServer4 = GLSLMiscHelper.createColors(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.colors1);
        System.err.println("colors1: " + gLArrayDataServer4);
        gLArrayDataServer4.enableBuffer(gL2ES2, false);
        GLSLMiscHelper.validateGLArrayDataServerState(gL2ES2, shaderState, gLArrayDataServer4);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(45.0f, (float)gLDrawable.getSurfaceWidth() / (float)gLDrawable.getSurfaceHeight(), 1.0f, 100.0f);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        shaderState.uniform(gL2ES2, gLUniformData);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, true, gLArrayDataServer, gLArrayDataServer2, true, 1, durationPerTest);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, true, gLArrayDataServer3, gLArrayDataServer4, true, 2, durationPerTest);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, true, gLArrayDataServer, gLArrayDataServer2, true, 3, durationPerTest);
        shaderState.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test(timeout=240000L)
    public void test02ShaderState_PerformanceSingleKeepEnabled() throws InterruptedException {
        this.testShaderState_PerformanceSingleImpl(false);
    }

    @Test(timeout=240000L)
    public void test03ShaderState_PerformanceSingleToggleEnable() throws InterruptedException {
        this.testShaderState_PerformanceSingleImpl(true);
    }

    private void testShaderState_PerformanceSingleImpl(boolean bl) throws InterruptedException {
        int n;
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(new GLCapabilities(GLProfile.getGL2ES2()), 480, 480, false);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        System.err.println(windowContext.context);
        gL2ES2.setSwapInterval(0);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        ShaderState shaderState = new ShaderState();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        shaderProgram.init(gL2ES2);
        Assert.assertTrue((boolean)shaderProgram.link(gL2ES2, System.err));
        shaderState.attachShaderProgram(gL2ES2, shaderProgram, true);
        PMVMatrix pMVMatrix = new PMVMatrix();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        shaderState.ownUniform(gLUniformData);
        shaderState.uniform(gL2ES2, gLUniformData);
        GLArrayDataServer gLArrayDataServer = GLSLMiscHelper.createVertices(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.vertices0);
        gLArrayDataServer.enableBuffer(gL2ES2, !bl);
        GLArrayDataServer gLArrayDataServer2 = GLSLMiscHelper.createColors(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.colors0);
        gLArrayDataServer2.enableBuffer(gL2ES2, !bl);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(45.0f, (float)gLDrawable.getSurfaceWidth() / (float)gLDrawable.getSurfaceHeight(), 1.0f, 100.0f);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        shaderState.uniform(gL2ES2, gLUniformData);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        gL2ES2.setSwapInterval(0);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, bl, gLArrayDataServer, gLArrayDataServer2, bl, 1, 0L);
        for (int i = 0; i < 100; ++i) {
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, bl, gLArrayDataServer, gLArrayDataServer2, bl);
        }
        long l = System.currentTimeMillis();
        for (n = 0; n < 600; ++n) {
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, bl, gLArrayDataServer, gLArrayDataServer2, bl);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)n * 1000.0 / (double)l3;
        String string = String.valueOf(d);
        int n2 = string.indexOf(46);
        System.err.println("testShaderState00PerformanceSingle toggleEnable " + bl + ": " + (double)l3 / 1000.0 + "s: " + n + "f, " + string.substring(0, n2 + 2) + " fps, " + l3 / (long)n + " ms/f");
        shaderState.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    @Test(timeout=240000L)
    public void test04ShaderState_PerformanceDouble() throws InterruptedException {
        int n;
        NEWTGLContext.WindowContext windowContext = NEWTGLContext.createWindow(new GLCapabilities(GLProfile.getGL2ES2()), 480, 480, false);
        GLDrawable gLDrawable = windowContext.context.getGLDrawable();
        GL2ES2 gL2ES2 = windowContext.context.getGL().getGL2ES2();
        System.err.println(windowContext.context);
        gL2ES2.setSwapInterval(0);
        Assert.assertEquals((long)0L, (long)gL2ES2.glGetError());
        ShaderState shaderState = new ShaderState();
        ShaderCode shaderCode = ShaderCode.create(gL2ES2, 35633, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        ShaderCode shaderCode2 = ShaderCode.create(gL2ES2, 35632, RedSquareES2.class, "shader", "shader/bin", "RedSquareShader", true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        ShaderProgram shaderProgram = new ShaderProgram();
        shaderProgram.add(shaderCode);
        shaderProgram.add(shaderCode2);
        shaderProgram.init(gL2ES2);
        Assert.assertTrue((boolean)shaderProgram.link(gL2ES2, System.err));
        shaderState.attachShaderProgram(gL2ES2, shaderProgram, true);
        PMVMatrix pMVMatrix = new PMVMatrix();
        GLUniformData gLUniformData = new GLUniformData("mgl_PMVMatrix", 4, 4, pMVMatrix.glGetPMvMatrixf());
        shaderState.ownUniform(gLUniformData);
        shaderState.uniform(gL2ES2, gLUniformData);
        GLArrayDataServer gLArrayDataServer = GLSLMiscHelper.createVertices(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.vertices0);
        gLArrayDataServer.enableBuffer(gL2ES2, false);
        GLArrayDataServer gLArrayDataServer2 = GLSLMiscHelper.createVertices(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.vertices1);
        gLArrayDataServer2.enableBuffer(gL2ES2, false);
        GLArrayDataServer gLArrayDataServer3 = GLSLMiscHelper.createColors(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.colors0);
        gLArrayDataServer3.enableBuffer(gL2ES2, false);
        GLArrayDataServer gLArrayDataServer4 = GLSLMiscHelper.createColors(gL2ES2, shaderState, 0, -1, GLSLMiscHelper.colors1);
        gLArrayDataServer4.enableBuffer(gL2ES2, false);
        gL2ES2.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        gL2ES2.glEnable(2929);
        pMVMatrix.glMatrixMode(5889);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.gluPerspective(45.0f, (float)gLDrawable.getSurfaceWidth() / (float)gLDrawable.getSurfaceHeight(), 1.0f, 100.0f);
        pMVMatrix.glMatrixMode(5888);
        pMVMatrix.glLoadIdentity();
        pMVMatrix.glTranslatef(0.0f, 0.0f, -10.0f);
        shaderState.uniform(gL2ES2, gLUniformData);
        gL2ES2.glViewport(0, 0, gLDrawable.getSurfaceWidth(), gLDrawable.getSurfaceHeight());
        gL2ES2.setSwapInterval(0);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, true, gLArrayDataServer, gLArrayDataServer3, true, 1, 0L);
        GLSLMiscHelper.displayVCArrays(gLDrawable, gL2ES2, shaderState, true, gLArrayDataServer2, gLArrayDataServer4, true, 2, 0L);
        for (int i = 0; i < 100; i += 2) {
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, true, gLArrayDataServer, gLArrayDataServer3, true);
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, true, gLArrayDataServer2, gLArrayDataServer4, true);
        }
        long l = System.currentTimeMillis();
        for (n = 0; n < 600; n += 2) {
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, true, gLArrayDataServer, gLArrayDataServer3, true);
            GLSLMiscHelper.displayVCArraysNoChecks(gLDrawable, gL2ES2, true, gLArrayDataServer2, gLArrayDataServer4, true);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        double d = (double)n * 1000.0 / (double)l3;
        String string = String.valueOf(d);
        int n2 = string.indexOf(46);
        System.err.println("testShaderState01PerformanceDouble: " + (double)l3 / 1000.0 + "s: " + n + "f, " + string.substring(0, n2 + 2) + " fps, " + l3 / (long)n + " ms/f");
        shaderState.destroy(gL2ES2);
        NEWTGLContext.destroyWindow(windowContext);
    }

    public static void main(String[] stringArray) throws IOException {
        System.err.println("main - start");
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-time")) {
                durationPerTest = MiscUtils.atoi(stringArray[++i], (int)durationPerTest);
                continue;
            }
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (!stringArray[i].equals("-firstUIAction")) continue;
            firstUIActionOnProcess = true;
        }
        if (bl) {
            while (-1 == System.in.read()) {
            }
            TestGLSLShaderState01NEWT testGLSLShaderState01NEWT = new TestGLSLShaderState01NEWT();
            try {
                testGLSLShaderState01NEWT.test04ShaderState_PerformanceDouble();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            String string = TestGLSLShaderState01NEWT.class.getName();
            JUnitCore.main((String[])new String[]{string});
        }
        System.err.println("main - end");
    }
}

