/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLCanvas;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestSwingAWT01GLn
extends UITestCase {
    private Window[] windows;

    @BeforeClass
    public static void startup() {
        System.out.println("GLProfile " + GLProfile.glAvailabilityToString());
    }

    @Before
    public void init() {
        this.windows = new Window[]{new Window(null), new Frame("Frame GL test"), new JFrame("JFrame GL test")};
    }

    protected void runTestGL(final GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        for (final Window window : this.windows) {
            System.out.println("testing with " + window.getClass().getName());
            final GLCanvas[] gLCanvasArray = new GLCanvas[1];
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    gLCanvasArray[0] = new GLCanvas(gLCapabilities);
                    gLCanvasArray[0].addGLEventListener(new GearsES2());
                    window.add(gLCanvasArray[0]);
                    window.setSize(512, 512);
                    window.validate();
                    window.setVisible(true);
                    gLCanvasArray[0].display();
                }
            };
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    System.out.println("cleaning up...");
                    window.setVisible(false);
                    try {
                        window.removeAll();
                    }
                    catch (Throwable throwable) {
                        Assume.assumeNoException((Throwable)throwable);
                        throwable.printStackTrace();
                    }
                    window.dispose();
                }
            };
            SwingUtilities.invokeAndWait(runnable);
            Animator animator = new Animator(gLCanvasArray[0]);
            animator.start();
            Thread.sleep(1000L);
            animator.stop();
            SwingUtilities.invokeAndWait(runnable2);
        }
    }

    @Test
    public void test01GLDefault() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = GLProfile.getDefault();
        System.out.println("GLProfile Default: " + gLProfile);
        if (gLProfile.isGL2ES2()) {
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
        } else {
            System.out.println("not a GL2ES2 profile");
        }
    }

    @Test
    public void test02GL2() throws InterruptedException, InvocationTargetException {
        if (GLProfile.isAvailable("GL2")) {
            GLProfile gLProfile = GLProfile.get("GL2");
            System.out.println("GLProfile GL2: " + gLProfile);
            GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
            this.runTestGL(gLCapabilities);
        } else {
            System.out.println("GL2 n/a");
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestSwingAWT01GLn.class.getName()});
    }
}

