/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore;

import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.test.junit.util.ValidateLockListener;
import com.jogamp.opengl.util.Animator;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class InitConcurrentBaseNEWT
extends UITestCase {
    static final int demoWinSize = 128;
    static long duration = 300L;
    static InsetsImmutable insets = null;
    static int num_x;
    static int num_y;

    @BeforeClass
    public static void initClass() {
        Window window = NewtFactory.createWindow(new Capabilities());
        window.setSize(128, 128);
        window.setVisible(true);
        Assert.assertEquals((Object)true, (Object)window.isVisible());
        Assert.assertEquals((Object)true, (Object)window.isNativeValid());
        insets = window.getInsets();
        int n = window.getScreen().getHeight();
        int n2 = window.getScreen().getWidth();
        int[] nArray = window.convertToPixelUnits(new int[]{128, 128});
        int[] nArray2 = window.convertToPixelUnits(new int[]{insets.getTotalWidth(), insets.getTotalHeight()});
        num_x = n2 / (nArray[0] + nArray2[0]) - 2;
        num_y = n / (nArray[1] + nArray2[1]) - 2;
        window.destroy();
    }

    protected static boolean done(JOGLTask[] jOGLTaskArray) {
        for (int i = jOGLTaskArray.length - 1; i >= 0; --i) {
            if (jOGLTaskArray[i].done()) continue;
            return false;
        }
        return true;
    }

    protected static String doneDump(JOGLTask[] jOGLTaskArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < jOGLTaskArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(i).append(": ").append(jOGLTaskArray[i].done());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    protected static boolean isDead(Thread[] threadArray) {
        for (int i = threadArray.length - 1; i >= 0; --i) {
            if (!threadArray[i].isAlive()) continue;
            return false;
        }
        return true;
    }

    protected static String isAliveDump(Thread[] threadArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < threadArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(i).append(": ").append(threadArray[i].isAlive());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runJOGLTasks(int n, boolean bl) throws InterruptedException {
        int n2;
        GLProfile.shutdown();
        System.err.println("InitConcurrentBaseNEWT " + n + " threads, reuse display: " + bl);
        String string = Thread.currentThread().getName();
        Object object = new Object();
        JOGLTask[] jOGLTaskArray = new JOGLTask[n];
        Thread[] threadArray = new Thread[n];
        for (n2 = 0; n2 < n; ++n2) {
            jOGLTaskArray[n2] = new JOGLTask(object, n2, bl);
            threadArray[n2] = new Thread((Runnable)jOGLTaskArray[n2], string + "-jt" + n2);
        }
        long l = System.currentTimeMillis();
        for (n2 = 0; n2 < n; ++n2) {
            threadArray[n2].start();
        }
        n2 = 0;
        Object object2 = object;
        synchronized (object2) {
            while (!InitConcurrentBaseNEWT.done(jOGLTaskArray)) {
                try {
                    object.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                System.err.println(n2 + ": " + InitConcurrentBaseNEWT.doneDump(jOGLTaskArray));
                ++n2;
            }
        }
        long l2 = System.currentTimeMillis();
        System.err.println("total: " + (double)(l2 - l) / 1000.0 + "s");
        Assert.assertTrue((String)("Tasks are incomplete. Complete: " + InitConcurrentBaseNEWT.doneDump(jOGLTaskArray)), (boolean)InitConcurrentBaseNEWT.done(jOGLTaskArray));
        for (n2 = 0; n2 < 30 && !InitConcurrentBaseNEWT.isDead(threadArray); ++n2) {
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)("Threads are still alive after 3s. Alive: " + InitConcurrentBaseNEWT.isAliveDump(threadArray)), (boolean)InitConcurrentBaseNEWT.isDead(threadArray));
        GLProfile.shutdown();
    }

    public static class JOGLTask
    implements Runnable {
        private final int id;
        private final Object postSync;
        private final boolean reuse;
        private boolean done = false;

        public JOGLTask(Object object, int n, boolean bl) {
            this.postSync = object;
            this.id = n;
            this.reuse = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = this.id % num_x * (128 + insets.getTotalHeight());
            int n2 = this.id / num_x % num_y * (128 + insets.getTotalHeight());
            System.err.println("JOGLTask " + this.id + ": START: " + n + "/" + n2 + ", reuse " + this.reuse + " - " + Thread.currentThread().getName());
            Display display = NewtFactory.createDisplay(null, this.reuse);
            Screen screen = NewtFactory.createScreen(display, 0);
            GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getDefault()));
            Assert.assertNotNull((Object)gLWindow);
            gLWindow.setTitle("Task " + this.id);
            gLWindow.setPosition(n + insets.getLeftWidth(), n2 + insets.getTopHeight());
            gLWindow.addGLEventListener(new ValidateLockListener());
            gLWindow.addGLEventListener(new GearsES2(0));
            Animator animator = new Animator(gLWindow);
            gLWindow.setSize(128, 128);
            gLWindow.setVisible(true);
            animator.setUpdateFPSFrames(60, null);
            System.err.println("JOGLTask " + this.id + ": INITIALIZED: " + ", " + display + " - " + Thread.currentThread().getName());
            animator.start();
            Assert.assertEquals((Object)true, (Object)animator.isAnimating());
            Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
            Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
            Assert.assertEquals((Object)true, (Object)gLWindow.isRealized());
            System.err.println("JOGLTask " + this.id + ": RUNNING: " + Thread.currentThread().getName());
            while (animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            animator.stop();
            gLWindow.destroy();
            System.err.println("JOGLTask " + this.id + ": DONE/SYNC: " + Thread.currentThread().getName());
            Object object = this.postSync;
            synchronized (object) {
                this.done = true;
                System.err.println("JOGLTask " + this.id + ": END: " + Thread.currentThread().getName());
                this.postSync.notifyAll();
            }
        }

        public boolean done() {
            return this.done;
        }
    }
}

