/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.GlueGenVersion;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.JogampVersion;
import com.jogamp.common.util.VersionUtil;
import com.jogamp.oculusvr.OVR;
import com.jogamp.oculusvr.OvrHmdContext;
import com.jogamp.oculusvr.ovrHmdDesc;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.oculusvr.ovrVector2i;
import java.util.jar.Manifest;

public class OVRVersion
extends JogampVersion {
    protected static volatile OVRVersion jogampCommonVersionInfo;

    protected OVRVersion(String string, Manifest manifest) {
        super(string, manifest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OVRVersion getInstance() {
        if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
        Class<OVRVersion> clazz = OVRVersion.class;
        synchronized (OVRVersion.class) {
            if (null != jogampCommonVersionInfo) return jogampCommonVersionInfo;
            Manifest manifest = VersionUtil.getManifest(OVRVersion.class.getClassLoader(), "com.jogamp.oculusvr");
            jogampCommonVersionInfo = new OVRVersion("com.jogamp.oculusvr", manifest);
            // ** MonitorExit[var0] (shouldn't be in output)
            return jogampCommonVersionInfo;
        }
    }

    public static StringBuilder getAvailableCapabilitiesInfo(int n, StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        if (!OVR.ovr_Initialize()) {
            stringBuilder.append("\tOVR not available").append(Platform.getNewline());
        } else {
            ovrHmdDesc ovrHmdDesc2 = OVR.ovrHmd_Create(n);
            if (null != ovrHmdDesc2) {
                OVRVersion.getAvailableCapabilitiesInfo(ovrHmdDesc2, n, stringBuilder);
                OVR.ovrHmd_Destroy(ovrHmdDesc2);
            } else {
                stringBuilder.append("\thmd." + n + " not available").append(Platform.getNewline());
            }
        }
        stringBuilder.append(Platform.getNewline());
        return stringBuilder;
    }

    public static StringBuilder getAvailableCapabilitiesInfo(ovrHmdDesc ovrHmdDesc2, int n, StringBuilder stringBuilder) {
        if (null == ovrHmdDesc2) {
            throw new IllegalArgumentException("null hmdDesc");
        }
        OvrHmdContext ovrHmdContext = ovrHmdDesc2.getHandle();
        if (null == ovrHmdContext) {
            throw new IllegalArgumentException("null hmdCtx");
        }
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append("\thmd." + n + ".productName:\t" + ovrHmdDesc2.getProductNameAsString()).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".vendorName:\t" + ovrHmdDesc2.getManufacturerAsString()).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".deviceName:\t" + ovrHmdDesc2.getDisplayDeviceNameAsString()).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".productId:\t0x" + Integer.toHexString(ovrHmdDesc2.getProductId())).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".vendorId:\t0x" + Integer.toHexString(ovrHmdDesc2.getVendorId())).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".serial:\t" + ovrHmdDesc2.getSerialNumberAsString()).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".type:\t" + ovrHmdDesc2.getType()).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".hmdCaps:\t" + OVRVersion.toHexString(ovrHmdDesc2.getHmdCaps())).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".distorCaps:\t" + OVRVersion.toHexString(ovrHmdDesc2.getDistortionCaps())).append(Platform.getNewline());
        stringBuilder.append("\thmd." + n + ".sensorCaps:\t" + OVRVersion.toHexString(ovrHmdDesc2.getTrackingCaps())).append(Platform.getNewline());
        ovrSizei ovrSizei2 = ovrHmdDesc2.getResolution();
        stringBuilder.append("\thmd." + n + ".resolution:\t" + ovrSizei2.getW() + "x" + ovrSizei2.getH()).append(Platform.getNewline());
        ovrVector2i ovrVector2i2 = ovrHmdDesc2.getWindowsPos();
        stringBuilder.append("\thmd." + n + ".winPos:\t" + ovrVector2i2.getX() + " / " + ovrVector2i2.getY()).append(Platform.getNewline());
        return stringBuilder;
    }

    private static String toHexString(int n) {
        return "0x" + Integer.toHexString(n);
    }

    public static StringBuilder getAllAvailableCapabilitiesInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(Platform.getNewline()).append(Platform.getNewline());
        stringBuilder.append("HMD.0 Capabilities: ").append(Platform.getNewline());
        OVRVersion.getAvailableCapabilitiesInfo(0, stringBuilder);
        return stringBuilder;
    }

    public static void main(String[] stringArray) {
        System.err.println(VersionUtil.getPlatformInfo());
        System.err.println(GlueGenVersion.getInstance());
        System.err.println(OVRVersion.getInstance());
        System.err.println(OVRVersion.getAllAvailableCapabilitiesInfo(null).toString());
    }
}

