/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.Source;
import com.jogamp.gluegen.jcpp.Token;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class FixedTokenSource
extends Source {
    private static final Token EOF = new Token(265, "<ts-eof>");
    private final List<Token> tokens;
    private int idx;

    FixedTokenSource(Token ... tokenArray) {
        this.tokens = Arrays.asList(tokenArray);
        this.idx = 0;
    }

    FixedTokenSource(List<Token> list) {
        this.tokens = list;
        this.idx = 0;
    }

    @Override
    public Token token() throws IOException, LexerException {
        if (this.idx >= this.tokens.size()) {
            return EOF;
        }
        return this.tokens.get(this.idx++);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("constant token stream ").append(this.tokens);
        Source source = this.getParent();
        if (source != null) {
            stringBuilder.append(" in ").append(String.valueOf(source));
        }
        return stringBuilder.toString();
    }
}

