/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.oculusvr;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.oculusvr.OVR;
import com.jogamp.oculusvr.OvrHmdContext;
import com.jogamp.oculusvr.ovrEyeRenderDesc;
import com.jogamp.oculusvr.ovrFovPort;
import com.jogamp.oculusvr.ovrHmdDesc;
import com.jogamp.oculusvr.ovrSizei;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.StereoUtil;
import jogamp.opengl.oculusvr.OVRStereoDeviceRenderer;
import jogamp.opengl.oculusvr.OVRUtil;

public class OVRStereoDevice
implements StereoDevice {
    private static final float[] DEFAULT_EYE_POSITION_OFFSET = new float[]{0.0f, 1.6f, -5.0f};
    private final StereoDeviceFactory factory;
    public final int deviceIndex;
    private final FovHVHalves[] defaultEyeFov;
    public ovrHmdDesc hmdDesc;
    public OvrHmdContext handle;
    private boolean sensorsStarted = false;
    private final int[] eyeRenderOrder;
    private final int supportedDistortionBits;
    private final int recommendedDistortionBits;
    private final int minimumDistortionBits;
    private final String deviceName;
    private final DimensionImmutable resolution;
    private final int requiredRotation;
    private final PointImmutable position;
    private final int dkVersion;

    public OVRStereoDevice(StereoDeviceFactory stereoDeviceFactory, ovrHmdDesc ovrHmdDesc2, int n) {
        if (null == ovrHmdDesc2) {
            throw new IllegalArgumentException("Passed null hmdDesc");
        }
        OvrHmdContext ovrHmdContext = ovrHmdDesc2.getHandle();
        if (null == ovrHmdContext) {
            throw new IllegalArgumentException("hmdDesc has null OvrHmdContext");
        }
        this.factory = stereoDeviceFactory;
        this.handle = ovrHmdContext;
        this.deviceIndex = n;
        this.hmdDesc = ovrHmdDesc2;
        ovrFovPort[] ovrFovPortArray = ovrHmdDesc2.getDefaultEyeFov(0, new ovrFovPort[ovrHmdDesc.getEyeRenderOrderArrayLength()]);
        this.defaultEyeFov = new FovHVHalves[ovrFovPortArray.length];
        for (int i = 0; i < this.defaultEyeFov.length; ++i) {
            this.defaultEyeFov[i] = OVRUtil.getFovHV(ovrFovPortArray[i]);
        }
        this.eyeRenderOrder = new int[ovrHmdDesc.getEyeRenderOrderArrayLength()];
        ovrHmdDesc2.getEyeRenderOrder(0, this.eyeRenderOrder);
        this.supportedDistortionBits = OVRUtil.ovrDistCaps2DistBits(ovrHmdDesc2.getDistortionCaps());
        this.recommendedDistortionBits = this.supportedDistortionBits & 0xFFFFFFF7;
        this.minimumDistortionBits = 1;
        this.deviceName = ovrHmdDesc2.getDisplayDeviceNameAsString();
        ovrSizei ovrSizei2 = ovrHmdDesc2.getResolution();
        this.resolution = new Dimension(ovrSizei2.getW(), ovrSizei2.getH());
        int n2 = ovrHmdDesc2.getType();
        switch (n2) {
            case 4: 
            case 5: 
            case 6: {
                this.dkVersion = 2;
                this.requiredRotation = 90;
                break;
            }
            default: {
                this.dkVersion = 1;
                this.requiredRotation = 0;
            }
        }
        this.position = OVRUtil.getVec2iAsPoint(ovrHmdDesc2.getWindowsPos());
    }

    @Override
    public final StereoDeviceFactory getFactory() {
        return this.factory;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OVRStereoDevice[product " + this.hmdDesc.getProductNameAsString());
        stringBuilder.append(", vendor " + this.hmdDesc.getManufacturerAsString());
        stringBuilder.append(", device " + this.deviceName);
        stringBuilder.append(", DK " + this.dkVersion);
        stringBuilder.append(", surfaceSize " + this.getSurfaceSize() + ", reqRotation " + this.requiredRotation + " ccw-deg");
        stringBuilder.append(", surfacePos " + this.getPosition());
        stringBuilder.append(", distortionBits[supported [" + StereoUtil.distortionBitsToString(this.getSupportedDistortionBits()) + "], recommended [" + StereoUtil.distortionBitsToString(this.getRecommendedDistortionBits()) + "], minimum [" + StereoUtil.distortionBitsToString(this.getMinimumDistortionBits()) + "]]]");
        return stringBuilder.toString();
    }

    @Override
    public final void dispose() {
        if (this.isValid()) {
            OVR.ovrHmd_Destroy(this.hmdDesc);
            this.hmdDesc = null;
            this.handle = null;
        }
    }

    @Override
    public boolean isValid() {
        return null != this.hmdDesc && null != this.handle;
    }

    @Override
    public final PointImmutable getPosition() {
        return this.position;
    }

    @Override
    public final DimensionImmutable getSurfaceSize() {
        return this.resolution;
    }

    @Override
    public int getRequiredRotation() {
        return this.requiredRotation;
    }

    @Override
    public float[] getDefaultEyePositionOffset() {
        return DEFAULT_EYE_POSITION_OFFSET;
    }

    @Override
    public final FovHVHalves[] getDefaultFOV() {
        return this.defaultEyeFov;
    }

    @Override
    public final boolean startSensors(boolean bl) {
        if (bl && !this.sensorsStarted) {
            if (OVR.ovrHmd_ConfigureTracking(this.hmdDesc, 112, 0)) {
                this.sensorsStarted = true;
                return true;
            }
            this.sensorsStarted = false;
            return false;
        }
        if (this.sensorsStarted) {
            OVR.ovrHmd_ConfigureTracking(this.hmdDesc, 0, 0);
            this.sensorsStarted = false;
            return true;
        }
        return true;
    }

    @Override
    public final boolean getSensorsStarted() {
        return this.sensorsStarted;
    }

    @Override
    public final int[] getEyeRenderOrder() {
        return this.eyeRenderOrder;
    }

    @Override
    public final int getSupportedDistortionBits() {
        return this.supportedDistortionBits;
    }

    @Override
    public final int getRecommendedDistortionBits() {
        return this.recommendedDistortionBits;
    }

    @Override
    public final int getMinimumDistortionBits() {
        return this.minimumDistortionBits;
    }

    @Override
    public final StereoDeviceRenderer createRenderer(int n, int n2, float[] fArray, FovHVHalves[] fovHVHalvesArray, float f, int n3) {
        ovrFovPort ovrFovPort2 = OVRUtil.getOVRFovPort(fovHVHalvesArray[0]);
        ovrFovPort ovrFovPort3 = OVRUtil.getOVRFovPort(fovHVHalvesArray[1]);
        ovrEyeRenderDesc[] ovrEyeRenderDescArray = new ovrEyeRenderDesc[]{OVR.ovrHmd_GetRenderDesc(this.hmdDesc, 0, ovrFovPort2), OVR.ovrHmd_GetRenderDesc(this.hmdDesc, 1, ovrFovPort3)};
        if (StereoDevice.DEBUG) {
            System.err.println("XXX: eyeRenderDesc[0] " + OVRUtil.toString(ovrEyeRenderDescArray[0]));
            System.err.println("XXX: eyeRenderDesc[1] " + OVRUtil.toString(ovrEyeRenderDescArray[1]));
        }
        DimensionImmutable dimensionImmutable = OVRUtil.getOVRSizei(OVR.ovrHmd_GetFovTextureSize(this.hmdDesc, 0, ovrEyeRenderDescArray[0].getFov(), f));
        DimensionImmutable dimensionImmutable2 = OVRUtil.getOVRSizei(OVR.ovrHmd_GetFovTextureSize(this.hmdDesc, 1, ovrEyeRenderDescArray[1].getFov(), f));
        if (StereoDevice.DEBUG) {
            System.err.println("XXX: recommenedTex0Size " + dimensionImmutable);
            System.err.println("XXX: recommenedTex1Size " + dimensionImmutable2);
        }
        int n4 = Math.max(dimensionImmutable.getHeight(), dimensionImmutable2.getHeight());
        DimensionImmutable[] dimensionImmutableArray = new DimensionImmutable[]{dimensionImmutable, dimensionImmutable2};
        Dimension dimension = new Dimension(dimensionImmutable.getWidth() + dimensionImmutable2.getWidth(), n4);
        if (StereoDevice.DEBUG) {
            System.err.println("XXX: textureSize Single " + dimensionImmutableArray);
            System.err.println("XXX: textureSize Total  " + dimension);
        }
        RectangleImmutable[] rectangleImmutableArray = new RectangleImmutable[2];
        if (1 == n2) {
            rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable.getWidth(), n4);
            rectangleImmutableArray[1] = new Rectangle(dimensionImmutable.getWidth(), 0, dimensionImmutable2.getWidth(), n4);
        } else {
            rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable.getWidth(), dimensionImmutable.getHeight());
            rectangleImmutableArray[1] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
        }
        return new OVRStereoDeviceRenderer(this, n, n2, fArray, ovrEyeRenderDescArray, dimensionImmutableArray, dimension, rectangleImmutableArray, n3);
    }
}

