/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingLeafRetained;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.CachedTargets;
import javax.media.j3d.CompileState;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.HashKey;
import javax.media.j3d.J3dDebug;
import javax.media.j3d.J3dMessage;
import javax.media.j3d.LeafRetained;
import javax.media.j3d.LinkRetained;
import javax.media.j3d.MasterControl;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.SwitchState;
import javax.media.j3d.Targets;
import javax.media.j3d.TargetsInterface;
import javax.media.j3d.UnorderList;
import javax.media.j3d.UpdateTargets;
import javax.media.j3d.ViewPlatformRetained;
import javax.media.j3d.VirtualUniverse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SwitchRetained
extends GroupRetained
implements TargetsInterface {
    static final int GEO_NODES = 1;
    static final int ENV_NODES = 2;
    static final int BEHAVIOR_NODES = 4;
    static final int SOUND_NODES = 8;
    static final int BOUNDINGLEAF_NODES = 16;
    int whichChild = -1;
    BitSet childMask = new BitSet();
    BitSet renderChildMask = new BitSet();
    boolean isDirty = true;
    ArrayList<Integer> switchLevels = new ArrayList(1);
    HashKey switchKey = new HashKey();
    int switchIndexCount = 0;
    UpdateTargets updateTargets = null;
    ArrayList<ArrayList<SwitchState>> childrenSwitchStates = null;

    SwitchRetained() {
        this.nodeType = 18;
    }

    synchronized void setWhichChild(int n, boolean bl) {
        this.whichChild = n;
        this.isDirty = true;
        if (this.source != null && this.source.isLive()) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> arrayList = new ArrayList<SwitchState>(1);
            int n2 = this.children.size();
            switch (n) {
                case -2: {
                    for (int i = 0; i < n2; ++i) {
                        if (this.renderChildMask.get(i) && !bl) continue;
                        this.renderChildMask.set(i);
                        this.updateSwitchChild(i, true, arrayList);
                    }
                    break;
                }
                case -1: {
                    for (int i = 0; i < n2; ++i) {
                        if (!this.renderChildMask.get(i) && !bl) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, arrayList);
                    }
                    break;
                }
                case -3: {
                    for (int i = 0; i < n2; ++i) {
                        if (this.childMask.get(i)) {
                            if (this.renderChildMask.get(i) && !bl) continue;
                            this.renderChildMask.set(i);
                            this.updateSwitchChild(i, true, arrayList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i) && !bl) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, arrayList);
                    }
                    break;
                }
                default: {
                    for (int i = 0; i < n2; ++i) {
                        if (i == n) {
                            if (this.renderChildMask.get(i) && !bl) continue;
                            this.renderChildMask.set(i);
                            this.updateSwitchChild(i, true, arrayList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i) && !bl) continue;
                        this.renderChildMask.clear(i);
                        this.updateSwitchChild(i, false, arrayList);
                    }
                }
            }
            this.sendMessage(arrayList);
        }
        this.dirtyBoundsCache();
    }

    int getWhichChild() {
        return this.whichChild;
    }

    final synchronized void setChildMask(BitSet bitSet) {
        int n;
        int n2 = bitSet.size() > this.childMask.size() ? bitSet.size() : this.childMask.size();
        for (n = 0; n < n2; ++n) {
            if (bitSet.get(n)) {
                this.childMask.set(n);
                continue;
            }
            this.childMask.clear(n);
        }
        this.isDirty = true;
        if (this.source != null && this.source.isLive() && this.whichChild == -3) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> arrayList = new ArrayList<SwitchState>(1);
            int n3 = this.children.size();
            for (n = 0; n < n3; ++n) {
                if (bitSet.get(n)) {
                    if (this.renderChildMask.get(n)) continue;
                    this.renderChildMask.set(n);
                    this.updateSwitchChild(n, true, arrayList);
                    continue;
                }
                if (!this.renderChildMask.get(n)) continue;
                this.renderChildMask.clear(n);
                this.updateSwitchChild(n, false, arrayList);
            }
            this.sendMessage(arrayList);
        }
        this.dirtyBoundsCache();
    }

    void sendMessage(ArrayList<SwitchState> arrayList) {
        LeafRetained leafRetained;
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2;
        int n3;
        UnorderList unorderList;
        int n4 = this.updateTargets.computeSwitchThreads();
        if (n4 > 0) {
            J3dMessage j3dMessage = new J3dMessage();
            j3dMessage.type = 27;
            j3dMessage.universe = this.universe;
            j3dMessage.threads = n4;
            j3dMessage.args[0] = this.updateTargets;
            j3dMessage.args[2] = arrayList;
            unorderList = this.updateTargets.targetList[5];
            if (unorderList != null) {
                n3 = unorderList.size();
                Object[] objectArray3 = new Object[n3];
                objectArray2 = unorderList.toArray(false);
                for (n2 = 0; n2 < n3; ++n2) {
                    Object[] objectArray4;
                    objectArray = (Object[])objectArray2[n2];
                    objectArray3[n2] = objectArray4 = new Object[objectArray.length];
                    for (n = 0; n < objectArray.length; ++n) {
                        leafRetained = (BoundingLeafRetained)objectArray[n];
                        objectArray4[n] = ((BoundingLeafRetained)leafRetained).users.toArray();
                    }
                }
                j3dMessage.args[1] = objectArray3;
            }
            VirtualUniverse.mc.processMessage(j3dMessage);
        }
        if ((unorderList = this.updateTargets.targetList[4]) != null) {
            n3 = unorderList.size();
            objectArray2 = unorderList.toArray(false);
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray = (Object[])objectArray2[n2];
                for (n = 0; n < objectArray.length; ++n) {
                    leafRetained = (ViewPlatformRetained)objectArray[n];
                    leafRetained.processSwitchChanged();
                }
            }
        }
    }

    final BitSet getChildMask() {
        return (BitSet)this.childMask.clone();
    }

    Node currentChild() {
        if (this.whichChild < 0 || this.whichChild >= this.children.size()) {
            return null;
        }
        return this.getChild(this.whichChild);
    }

    void updateSwitchChild(int n, boolean bl, ArrayList<SwitchState> arrayList) {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                int n2 = this.switchLevels.get(i);
                this.traverseSwitchChild(n, this.localToVworldKeys[i], i, this, false, false, bl, n2, arrayList);
            }
        } else {
            int n3 = this.switchLevels.get(0);
            this.traverseSwitchChild(n, null, 0, this, false, false, bl, n3, arrayList);
        }
    }

    @Override
    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        super.setAuxData(setLiveState, n, n2);
        this.switchLevels.add(new Integer(setLiveState.switchLevels[n]));
        int n3 = this.children.size();
        for (int i = 0; i < n3; ++i) {
            ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(i);
            arrayList.add(n2, new SwitchState(true));
        }
    }

    @Override
    void setNodeData(SetLiveState setLiveState) {
        super.setNodeData(setLiveState);
        if (!(setLiveState.childSwitchLinks == null || this.inSharedGroup && setLiveState.childSwitchLinks.contains(this))) {
            setLiveState.childSwitchLinks.add(this);
        }
        setLiveState.parentSwitchLink = this;
        if (!this.inSharedGroup) {
            this.setAuxData(setLiveState, 0, 0);
        } else {
            setLiveState.hashkeyIndex = new int[setLiveState.keys.length];
            for (int i = 0; i < setLiveState.keys.length; ++i) {
                int n = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n >= 0) {
                    this.setAuxData(setLiveState, i, n);
                } else {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                }
                setLiveState.hashkeyIndex[i] = n;
            }
        }
    }

    @Override
    void setLive(SetLiveState setLiveState) {
        boolean bl;
        int n;
        SwitchRetained switchRetained;
        int n2;
        Targets[] targetsArray = setLiveState.switchTargets;
        ArrayList<SwitchState> arrayList = setLiveState.switchStates;
        SwitchRetained[] switchRetainedArray = setLiveState.closestSwitchParents;
        int[] nArray = setLiveState.closestSwitchIndices;
        ArrayList<NodeRetained> arrayList2 = setLiveState.childSwitchLinks;
        GroupRetained groupRetained = setLiveState.parentSwitchLink;
        int[] nArray2 = setLiveState.hashkeyIndex;
        setLiveState.closestSwitchParents = (SwitchRetained[])switchRetainedArray.clone();
        setLiveState.closestSwitchIndices = Arrays.copyOf(nArray, nArray.length);
        for (n2 = 0; n2 < setLiveState.switchLevels.length; ++n2) {
            int n3 = n2;
            setLiveState.switchLevels[n3] = setLiveState.switchLevels[n3] + 1;
            setLiveState.closestSwitchParents[n2] = this;
        }
        super.doSetLive(setLiveState);
        this.initRenderChildMask();
        if (this.inSharedGroup) {
            for (n2 = 0; n2 < setLiveState.keys.length; ++n2) {
                int n4 = setLiveState.hashkeyIndex[n2];
                if (n4 >= this.localToVworldKeys.length) continue;
                switchRetained = setLiveState.switchLevels[n2] == 0 ? this : null;
                n = this.children.size();
                for (int i = 0; i < n; ++i) {
                    bl = this.renderChildMask.get(i);
                    this.traverseSwitchChild(i, setLiveState.keys[n2], n4, switchRetained, true, false, bl, setLiveState.switchLevels[n2], null);
                }
            }
        } else {
            switchRetained = setLiveState.switchLevels[0] == 0 ? this : null;
            n = this.children.size();
            for (n2 = 0; n2 < n; ++n2) {
                bl = this.renderChildMask.get(n2);
                this.traverseSwitchChild(n2, null, 0, switchRetained, true, false, bl, setLiveState.switchLevels[0], null);
            }
        }
        setLiveState.switchTargets = targetsArray;
        setLiveState.switchStates = arrayList;
        setLiveState.closestSwitchParents = switchRetainedArray;
        setLiveState.closestSwitchIndices = nArray;
        n2 = 0;
        while (n2 < setLiveState.switchLevels.length) {
            int n5 = n2++;
            setLiveState.switchLevels[n5] = setLiveState.switchLevels[n5] - 1;
        }
        setLiveState.childSwitchLinks = arrayList2;
        setLiveState.parentSwitchLink = groupRetained;
        setLiveState.hashkeyIndex = nArray2;
        super.markAsLive();
    }

    @Override
    void removeNodeData(SetLiveState setLiveState) {
        int n = this.children.size();
        if (this.refCount <= 0) {
            if (this.parentSwitchLink != null) {
                for (int i = 0; i < this.parentSwitchLink.childrenSwitchLinks.size(); ++i) {
                    ArrayList<NodeRetained> arrayList = this.parentSwitchLink.childrenSwitchLinks.get(i);
                    if (!arrayList.contains(this)) continue;
                    arrayList.remove(this);
                    break;
                }
            }
            for (int i = 0; i < n; ++i) {
                ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(i);
                arrayList.clear();
            }
            this.switchLevels.remove(0);
        } else {
            for (int i = setLiveState.keys.length - 1; i >= 0; --i) {
                int n2 = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n2 < 0) continue;
                for (int j = 0; j < n; ++j) {
                    ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(j);
                    arrayList.remove(n2);
                }
                this.switchLevels.remove(n2);
            }
        }
        super.removeNodeData(setLiveState);
    }

    @Override
    synchronized void clearLive(SetLiveState setLiveState) {
        Targets[] targetsArray = setLiveState.switchTargets;
        setLiveState.switchTargets = null;
        super.clearLive(setLiveState);
        setLiveState.switchTargets = targetsArray;
    }

    void initRenderChildMask() {
        int n = this.children.size();
        switch (this.whichChild) {
            case -2: {
                for (int i = 0; i < n; ++i) {
                    this.renderChildMask.set(i);
                }
                break;
            }
            case -1: {
                for (int i = 0; i < n; ++i) {
                    this.renderChildMask.clear(i);
                }
                break;
            }
            case -3: {
                for (int i = 0; i < n; ++i) {
                    if (this.childMask.get(i)) {
                        this.renderChildMask.set(i);
                        continue;
                    }
                    this.renderChildMask.clear(i);
                }
                break;
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    if (i == this.whichChild) {
                        this.renderChildMask.set(i);
                        continue;
                    }
                    this.renderChildMask.clear(i);
                }
            }
        }
    }

    void traverseSwitchChild(int n, HashKey hashKey, int n2, SwitchRetained switchRetained, boolean bl, boolean bl2, boolean bl3, int n3, ArrayList<SwitchState> arrayList) {
        boolean bl4 = false;
        ArrayList<SwitchState> arrayList2 = this.childrenSwitchStates.get(n);
        SwitchState switchState = arrayList2.get(n2);
        switchState.updateCompositeSwitchMask(n3, bl3);
        if (switchRetained != null) {
            if (bl) {
                if (!switchState.initialized) {
                    switchState.initSwitchOn();
                }
            } else {
                boolean bl5 = switchState.evalCompositeSwitchOn();
                if (switchState.cachedSwitchOn != bl5) {
                    switchState.updateCachedSwitchOn();
                    switchRetained.updateTargets.addCachedTargets(switchState.cachedTargets);
                    bl4 = true;
                    arrayList.add(switchState);
                }
            }
        }
        ArrayList arrayList3 = (ArrayList)this.childrenSwitchLinks.get(n);
        int n4 = arrayList3.size();
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            Object e = arrayList3.get(i);
            if (e instanceof SwitchRetained) {
                SwitchRetained switchRetained2 = (SwitchRetained)e;
                n6 = switchRetained2.children.size();
                for (n5 = 0; n5 < n6; ++n5) {
                    switchRetained2.traverseSwitchChild(n5, hashKey, n2, switchRetained, bl, bl4, bl3, n3, arrayList);
                }
                continue;
            }
            LinkRetained linkRetained = (LinkRetained)e;
            if (hashKey == null) {
                this.switchKey.reset();
                this.switchKey.append(this.locale.nodeId);
            } else {
                this.switchKey.set(hashKey);
            }
            this.switchKey.append(LinkRetained.plus).append(linkRetained.nodeId);
            if (linkRetained.sharedGroup == null || linkRetained.sharedGroup.localToVworldKeys == null) continue;
            n5 = this.switchKey.equals(linkRetained.sharedGroup.localToVworldKeys, 0, linkRetained.sharedGroup.localToVworldKeys.length);
            if (n5 < 0) {
                System.err.println("SwitchRetained : Can't find hashKey");
            }
            if (n5 >= linkRetained.sharedGroup.localToVworldKeys.length) continue;
            n6 = linkRetained.sharedGroup.children.size();
            for (int j = 0; j < n6; ++j) {
                linkRetained.sharedGroup.traverseSwitchChild(j, linkRetained.sharedGroup.localToVworldKeys[n5], n5, switchRetained, bl, bl4, bl3, n3, arrayList);
            }
        }
    }

    void traverseSwitchParent() {
        if (this.inSharedGroup) {
            for (int i = 0; i < this.localToVworldKeys.length; ++i) {
                int n = this.switchLevels.get(i);
                SwitchRetained switchRetained = n == 0 ? this : null;
                int n2 = this.children.size();
                for (int j = 0; j < n2; ++j) {
                    boolean bl = this.renderChildMask.get(j);
                    this.traverseSwitchChild(j, this.localToVworldKeys[i], i, switchRetained, true, false, bl, n, null);
                }
            }
        } else {
            int n = this.switchLevels.get(0);
            SwitchRetained switchRetained = n == 0 ? this : null;
            int n3 = this.children.size();
            for (int i = 0; i < n3; ++i) {
                boolean bl = this.renderChildMask.get(i);
                this.traverseSwitchChild(i, null, 0, switchRetained, true, false, bl, n, null);
            }
        }
        if (this.parentSwitchLink != null) {
            if (this.parentSwitchLink instanceof SwitchRetained) {
                ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
            } else if (this.parentSwitchLink instanceof SharedGroupRetained) {
                ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        block16: {
            block13: {
                block14: {
                    NodeRetained nodeRetained;
                    block17: {
                        block15: {
                            if (!this.boundsAutoCompute) break block13;
                            if (VirtualUniverse.mc.cacheAutoComputedBounds) break block14;
                            if (this.whichChild != -2) break block15;
                            for (int i = 0; i < this.children.size(); ++i) {
                                NodeRetained nodeRetained2 = (NodeRetained)this.children.get(i);
                                if (nodeRetained2 == null) continue;
                                nodeRetained2.computeCombineBounds(bounds);
                            }
                            break block16;
                        }
                        if (this.whichChild != -3) break block17;
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained nodeRetained3;
                            if (!this.childMask.get(i) || (nodeRetained3 = (NodeRetained)this.children.get(i)) == null) continue;
                            nodeRetained3.computeCombineBounds(bounds);
                        }
                        break block16;
                    }
                    if (this.whichChild == -1 || this.whichChild >= this.children.size() || (nodeRetained = (NodeRetained)this.children.get(this.whichChild)) == null) break block16;
                    nodeRetained.computeCombineBounds(bounds);
                    break block16;
                }
                if (!this.validCachedBounds) {
                    NodeRetained nodeRetained;
                    this.validCachedBounds = true;
                    this.cachedBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
                    if (this.whichChild == -2) {
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained nodeRetained4 = (NodeRetained)this.children.get(i);
                            if (nodeRetained4 == null) continue;
                            nodeRetained4.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild == -3) {
                        for (int i = 0; i < this.children.size(); ++i) {
                            NodeRetained nodeRetained5;
                            if (!this.childMask.get(i) || (nodeRetained5 = (NodeRetained)this.children.get(i)) == null) continue;
                            nodeRetained5.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild != -1 && this.whichChild < this.children.size() && (nodeRetained = (NodeRetained)this.children.get(this.whichChild)) != null) {
                        nodeRetained.computeCombineBounds(this.cachedBounds);
                    }
                }
                bounds.combine(this.cachedBounds);
                break block16;
            }
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            NodeRetained nodeRetained;
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            Bounds bounds = null;
            bounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
            if (this.whichChild == -2) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeRetained nodeRetained2 = (NodeRetained)this.children.get(i);
                    if (nodeRetained2 == null) continue;
                    nodeRetained2.computeCombineBounds(bounds);
                }
            } else if (this.whichChild == -3) {
                for (int i = 0; i < this.children.size(); ++i) {
                    NodeRetained nodeRetained3;
                    if (!this.childMask.get(i) || (nodeRetained3 = (NodeRetained)this.children.get(i)) == null) continue;
                    nodeRetained3.computeCombineBounds(bounds);
                }
            } else if (this.whichChild != -1 && this.whichChild >= 0 && this.whichChild < this.children.size() && (nodeRetained = (NodeRetained)this.children.get(this.whichChild)) != null) {
                nodeRetained.computeCombineBounds(bounds);
            }
            return bounds;
        }
        return super.getBounds();
    }

    @Override
    void compile(CompileState compileState) {
        super.compile(compileState);
        this.mergeFlag = 0;
        if (J3dDebug.debug) {
            ++compileState.numSwitches;
        }
    }

    @Override
    void insertChildrenData(int n) {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(n, new ArrayList(1));
        ArrayList<SwitchState> arrayList = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(n, arrayList);
        if (this.source != null && this.source.isLive()) {
            for (int i = 0; i < this.localToVworld.length; ++i) {
                arrayList.add(new SwitchState(true));
            }
        }
    }

    @Override
    void appendChildrenData() {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(new ArrayList(1));
        ArrayList<SwitchState> arrayList = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(arrayList);
        if (this.source != null && this.source.isLive()) {
            for (int i = 0; i < this.localToVworld.length; ++i) {
                arrayList.add(new SwitchState(true));
            }
        }
    }

    @Override
    void removeChildrenData(int n) {
        ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(n);
        arrayList.clear();
        this.childrenSwitchStates.remove(n);
        ArrayList arrayList2 = (ArrayList)this.childrenSwitchLinks.get(n);
        arrayList2.clear();
        this.childrenSwitchLinks.remove(n);
    }

    @Override
    void childDoSetLive(NodeRetained nodeRetained, int n, SetLiveState setLiveState) {
        int n2 = this.inSharedGroup ? setLiveState.keys.length : 1;
        setLiveState.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(n);
        for (int i = 0; i < n2; ++i) {
            setLiveState.closestSwitchIndices[i] = this.switchIndexCount;
            setLiveState.closestSwitchParents[i] = this;
        }
        ++this.switchIndexCount;
        Targets[] targetsArray = new Targets[n2];
        for (int i = 0; i < n2; ++i) {
            targetsArray[i] = new Targets();
        }
        setLiveState.switchTargets = targetsArray;
        setLiveState.switchStates = this.childrenSwitchStates.get(n);
        if (nodeRetained != null) {
            nodeRetained.setLive(setLiveState);
        }
        if (!this.inSharedGroup) {
            CachedTargets cachedTargets = setLiveState.switchTargets[0].snapShotInit();
            SwitchState switchState = setLiveState.switchStates.get(0);
            switchState.cachedTargets = cachedTargets;
        } else {
            for (int i = 0; i < n2; ++i) {
                CachedTargets cachedTargets = setLiveState.switchTargets[i].snapShotInit();
                SwitchState switchState = setLiveState.switchStates.get(setLiveState.hashkeyIndex[i]);
                switchState.cachedTargets = cachedTargets;
            }
        }
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int n) {
        return n == 1 ? this : (TargetsInterface)((Object)this.parentTransformLink);
    }

    @Override
    public CachedTargets getCachedTargets(int n, int n2, int n3) {
        if (n == 1) {
            ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(n3);
            if (n2 < arrayList.size()) {
                SwitchState switchState = arrayList.get(n2);
                return switchState.cachedTargets;
            }
            return null;
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    @Override
    public void resetCachedTargets(int n, CachedTargets[] cachedTargetsArray, int n2) {
        if (n == 1) {
            ArrayList<SwitchState> arrayList = this.childrenSwitchStates.get(n2);
            if (cachedTargetsArray.length != arrayList.size()) {
                System.err.println("resetCachedTargets: unmatched length!" + cachedTargetsArray.length + " " + arrayList.size());
                System.err.println("  resetCachedTargets: " + this);
            }
            for (int i = 0; i < cachedTargetsArray.length; ++i) {
                SwitchState switchState = arrayList.get(i);
                switchState.cachedTargets = cachedTargetsArray[i];
            }
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int n, int n2) {
        if (n == 1) {
            return this.childrenSwitchStates.get(n2);
        }
        System.err.println("getTargetsData: wrong arguments");
        return null;
    }

    @Override
    public int getTargetThreads(int n) {
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    @Override
    public void updateCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        System.err.println("updateCachedTarget: wrong arguments");
    }

    @Override
    public void computeTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        System.err.println("computeTargetThreads: wrong arguments");
    }

    @Override
    public void updateTargetThreads(int n, CachedTargets[] cachedTargetsArray) {
        System.err.println("updateTargetThreads: wrong arguments");
    }

    @Override
    public void propagateTargetThreads(int n, int n2) {
        System.err.println("propagateTargetThreads: wrong arguments");
    }

    @Override
    public void copyCachedTargets(int n, CachedTargets[] cachedTargetsArray) {
        System.err.println("copyCachedTarget: wrong arguments");
    }
}

