/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.SceneGraphObject;

public class Font3DState
extends NodeComponentState {
    private Font font = null;
    private double tesselationTolerance = 0.0;
    private FontExtrusion extrudePath = null;

    public Font3DState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeConstructorParams(DataOutput dataOutput) throws IOException {
        super.writeConstructorParams(dataOutput);
        Font3D font3D = (Font3D)this.node;
        this.font = font3D.getFont();
        dataOutput.writeUTF(this.font.getFontName());
        dataOutput.writeInt(this.font.getStyle());
        dataOutput.writeInt(this.font.getSize());
        dataOutput.writeDouble(font3D.getTessellationTolerance());
        this.extrudePath = new FontExtrusion();
        font3D.getFontExtrusion(this.extrudePath);
        if (this.extrudePath.getExtrusionShape() == null) {
            this.extrudePath = null;
        }
        if (this.extrudePath != null) {
            Shape shape = this.extrudePath.getExtrusionShape();
            if (shape != null) {
                PathIterator pathIterator = shape.getPathIterator(null);
                float[] fArray = new float[6];
                while (!pathIterator.isDone()) {
                    int n = pathIterator.currentSegment(fArray);
                    dataOutput.writeInt(n);
                    int n2 = 0;
                    if (n == 0) {
                        n2 = 1;
                    } else if (n == 1) {
                        n2 = 1;
                    } else if (n == 2) {
                        n2 = 2;
                    } else if (n == 3) {
                        n2 = 3;
                    }
                    for (int i = 0; i < n2; ++i) {
                        dataOutput.writeFloat(fArray[i * 2 + 0]);
                        dataOutput.writeFloat(fArray[i * 2 + 1]);
                    }
                    if (pathIterator.isDone()) continue;
                    pathIterator.next();
                }
            }
            dataOutput.writeInt(Integer.MIN_VALUE);
            dataOutput.writeDouble(this.extrudePath.getTessellationTolerance());
        } else {
            dataOutput.writeInt(Integer.MIN_VALUE);
        }
    }

    public void readConstructorParams(DataInput dataInput) throws IOException {
        super.readConstructorParams(dataInput);
        String string = dataInput.readUTF();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        this.font = new Font(string, n, n2);
        this.tesselationTolerance = dataInput.readDouble();
        GeneralPath generalPath = null;
        int n3 = dataInput.readInt();
        while (n3 != Integer.MIN_VALUE) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            if (n3 == 0) {
                generalPath.moveTo(dataInput.readFloat(), dataInput.readFloat());
            } else if (n3 == 1) {
                generalPath.lineTo(dataInput.readFloat(), dataInput.readFloat());
            } else if (n3 == 2) {
                generalPath.quadTo(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
            } else if (n3 == 3) {
                generalPath.curveTo(dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat(), dataInput.readFloat());
            } else if (n3 == 4) {
                generalPath.closePath();
            }
            n3 = dataInput.readInt();
        }
        this.extrudePath = generalPath != null ? new FontExtrusion(generalPath, dataInput.readDouble()) : null;
    }

    public SceneGraphObject createNode(Class clazz) {
        return this.createNode(clazz, new Class[]{Font.class, Double.TYPE, FontExtrusion.class}, new Object[]{this.font, new Double(this.tesselationTolerance), this.extrudePath});
    }

    protected SceneGraphObject createNode() {
        return new Font3D(this.font, this.tesselationTolerance, this.extrudePath);
    }
}

