/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.event;

import com.jogamp.newt.awt.NewtCanvasAWT;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.test.junit.jogl.demos.es2.RedSquareES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Robot;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import jogamp.nativewindow.jawt.JAWTUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestNewtKeyPressReleaseUnmaskRepeatAWT
extends UITestCase {
    static int width;
    static int height;
    static long durationPerTest;
    static long awtWaitTimeout;
    static GLCapabilities glCaps;

    @BeforeClass
    public static void initClass() {
        width = 640;
        height = 480;
        glCaps = new GLCapabilities(null);
    }

    @AfterClass
    public static void release() {
    }

    @Before
    public void initTest() {
    }

    @After
    public void releaseTest() {
    }

    @Test(timeout=180000L)
    public void test01NEWT() throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        gLWindow.setSize(width, height);
        gLWindow.setVisible(true);
        this.testImpl(gLWindow);
        gLWindow.destroy();
    }

    private void testNewtCanvasAWT_Impl(boolean bl) throws AWTException, InterruptedException, InvocationTargetException {
        GLWindow gLWindow = GLWindow.create(glCaps);
        NewtCanvasAWT newtCanvasAWT = new NewtCanvasAWT(gLWindow);
        if (!bl) {
            newtCanvasAWT.setShallUseOffscreenLayer(true);
        }
        final JFrame jFrame = new JFrame("Swing AWT Parent Frame: " + gLWindow.getTitle());
        jFrame.getContentPane().add((Component)newtCanvasAWT, "Center");
        jFrame.setSize(width, height);
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                jFrame.setVisible(true);
            }
        });
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForVisible(jFrame, true));
        this.testImpl(gLWindow);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    jFrame.setVisible(false);
                    jFrame.dispose();
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Assume.assumeNoException((Throwable)throwable);
        }
        gLWindow.destroy();
    }

    @Test(timeout=180000L)
    public void test02NewtCanvasAWT_Onscreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (JAWTUtil.isOffscreenLayerRequired()) {
            System.err.println("Platform doesn't support onscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(true);
    }

    @Test(timeout=180000L)
    public void test03NewtCanvasAWT_Offsccreen() throws AWTException, InterruptedException, InvocationTargetException {
        if (!JAWTUtil.isOffscreenLayerSupported()) {
            System.err.println("Platform doesn't support offscreen rendering.");
            return;
        }
        this.testNewtCanvasAWT_Impl(false);
    }

    void testImpl(GLWindow gLWindow) throws AWTException, InterruptedException, InvocationTargetException {
        Robot robot = new Robot();
        robot.setAutoWaitForIdle(true);
        RedSquareES2 redSquareES2 = new RedSquareES2();
        gLWindow.addGLEventListener(redSquareES2);
        SimpleKeyPressRelease simpleKeyPressRelease = new SimpleKeyPressRelease();
        gLWindow.addKeyListener(simpleKeyPressRelease);
        Assert.assertEquals((Object)true, (Object)AWTRobotUtil.waitForRealized(gLWindow, true));
        Animator animator = new Animator(gLWindow);
        animator.start();
        Thread.sleep(durationPerTest);
        AWTRobotUtil.assertRequestFocusAndWait(null, gLWindow, gLWindow, null, null);
        AWTRobotUtil.requestFocus(robot, gLWindow, false);
        gLWindow.removeKeyListener(simpleKeyPressRelease);
        animator.stop();
    }

    static int atoi(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            durationPerTest = TestNewtKeyPressReleaseUnmaskRepeatAWT.atoi(stringArray[++i]);
        }
        System.out.println("durationPerTest: " + durationPerTest);
        String string = TestNewtKeyPressReleaseUnmaskRepeatAWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        durationPerTest = 100L;
        awtWaitTimeout = 1000L;
    }

    static class SimpleKeyPressRelease
    implements KeyListener {
        int seq;

        SimpleKeyPressRelease() {
            this.reset();
        }

        public void reset() {
            this.seq = 0;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (0 == (0x20000000 & keyEvent.getModifiers())) {
                ++this.seq;
                System.err.println(this.seq + ": " + keyEvent);
            }
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            if (0 == (0x20000000 & keyEvent.getModifiers())) {
                ++this.seq;
                System.err.println(this.seq + ": " + keyEvent);
            }
        }
    }
}

