/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.IOUtil;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.TextureDraw01Accessor;
import com.jogamp.opengl.test.junit.jogl.demos.es2.TextureDraw01ES2Listener;
import com.jogamp.opengl.test.junit.jogl.demos.gl2.TextureDraw01GL2Listener;
import com.jogamp.opengl.test.junit.util.MiscUtils;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import com.jogamp.opengl.util.GLReadBufferUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestTGATextureFromFileNEWT
extends UITestCase {
    static boolean showFPS = false;
    static long duration = 100L;
    InputStream testTextureStream01U32;
    InputStream testTextureStream02RLE32;
    InputStream testTextureStream03RLE32;

    @Before
    public void initTest() throws IOException {
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), "test-u32.tga");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream01U32 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream01U32);
        uRLConnection = IOUtil.getResource(this.getClass(), "bug744-rle32.tga");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream02RLE32 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream02RLE32);
        uRLConnection = IOUtil.getResource(this.getClass(), "bug982.rle32.256x256.tga");
        Assert.assertNotNull((Object)uRLConnection);
        this.testTextureStream03RLE32 = uRLConnection.getInputStream();
        Assert.assertNotNull((Object)this.testTextureStream03RLE32);
    }

    public void testImpl(boolean bl, InputStream inputStream) throws InterruptedException, IOException {
        GLProfile gLProfile;
        final GLReadBufferUtil gLReadBufferUtil = new GLReadBufferUtil(true, false);
        if (bl && GLProfile.isAvailable("GL2")) {
            gLProfile = GLProfile.getMaxFixedFunc(true);
        } else if (!bl && GLProfile.isAvailable("GL2ES2")) {
            gLProfile = GLProfile.getGL2ES2();
        } else {
            System.err.println(this.getSimpleTestName(".") + ": GLProfile n/a, useFFP: " + bl);
            return;
        }
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setAlphaBits(1);
        TextureData textureData = TextureIO.newTextureData(gLProfile, inputStream, false, "tga");
        System.err.println("TextureData: " + textureData);
        GLWindow gLWindow = GLWindow.create(gLCapabilities);
        gLWindow.setTitle("TestTGATextureGL2FromFileNEWT");
        gLWindow.setSize(textureData.getWidth(), textureData.getHeight());
        final GLEventListener gLEventListener = bl ? new TextureDraw01GL2Listener(textureData) : new TextureDraw01ES2Listener(textureData, 0);
        gLWindow.addGLEventListener(gLEventListener);
        gLWindow.addGLEventListener(new GLEventListener(){
            boolean shot = false;

            @Override
            public void init(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void display(GLAutoDrawable gLAutoDrawable) {
                if (null != ((TextureDraw01Accessor)((Object)gLEventListener)).getTexture() && !this.shot) {
                    this.shot = true;
                    TestTGATextureFromFileNEWT.this.snapshot(0, null, gLAutoDrawable.getGL(), gLReadBufferUtil, "png", null);
                }
            }

            @Override
            public void dispose(GLAutoDrawable gLAutoDrawable) {
            }

            @Override
            public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
            }
        });
        Animator animator = new Animator(gLWindow);
        animator.setUpdateFPSFrames(60, showFPS ? System.err : null);
        QuitAdapter quitAdapter = new QuitAdapter();
        gLWindow.addKeyListener(quitAdapter);
        gLWindow.addWindowListener(quitAdapter);
        gLWindow.setVisible(true);
        animator.start();
        while (!quitAdapter.shouldQuit() && animator.isAnimating() && animator.getTotalFPSDuration() < duration) {
            Thread.sleep(100L);
        }
        animator.stop();
        gLWindow.destroy();
    }

    @Test
    public void test01U32__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream01U32);
    }

    @Test
    public void test02RLE32__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream02RLE32);
    }

    @Test
    public void test03RLE32__GL2() throws InterruptedException, IOException {
        this.testImpl(true, this.testTextureStream03RLE32);
    }

    @After
    public void cleanupTest() {
        this.testTextureStream01U32 = null;
        this.testTextureStream02RLE32 = null;
        this.testTextureStream03RLE32 = null;
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            duration = MiscUtils.atol(stringArray[++i], duration);
        }
        JUnitCore.main((String[])new String[]{TestTGATextureFromFileNEWT.class.getName()});
    }
}

