/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.util.texture;

import com.jogamp.common.util.Bitstream;
import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.opengl.test.junit.jogl.util.texture.TestPixelFormatUtil00NEWT;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.PNGPixelRect;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestPixelFormatUtil01NEWT
extends UITestCase {
    @Test
    public void testPNGRead11_fromRGBA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.RGBA8888, 0, false);
    }

    @Test
    public void testPNGRead12_fromABGR8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.ABGR8888, 0, false);
    }

    @Test
    public void testPNGRead13_fromBGRA8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.BGRA8888, 0, false);
    }

    @Test
    public void testPNGRead14_fromARGB8888() throws InterruptedException, IOException, MalformedURLException {
        this.testPNG01Impl("", "test-ntscN_4-01-160x90", PixelFormat.ARGB8888, 0, false);
    }

    private void testPNG01Impl(String string, String string2, PixelFormat pixelFormat, int n, boolean bl) throws InterruptedException, IOException, MalformedURLException {
        System.err.println("Test01: " + string + string2 + ".png, srcFmt " + (Object)((Object)pixelFormat) + ", destMinStrideInBytes " + n + ", destIsGLOriented " + bl);
        URLConnection uRLConnection = IOUtil.getResource(this.getClass(), string + string2 + ".png");
        PNGPixelRect pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), pixelFormat, false, n, false);
        System.err.println("PNGPixelRect - Orig: " + pNGPixelRect);
        System.err.printf("Image Data: %s%n", Bitstream.toHexBinString(true, pNGPixelRect.getPixels(), 0, pNGPixelRect.getPixelformat().comp.bytesPerPixel()));
        TestPixelFormatUtil00NEWT.dumpComponents(pNGPixelRect, 0, 0, 3, 3);
        PixelFormat[] pixelFormatArray = new PixelFormat[]{PixelFormat.RGBA8888, PixelFormat.ABGR8888, PixelFormat.BGRA8888, PixelFormat.ARGB8888};
        for (int i = 0; i < pixelFormatArray.length; ++i) {
            PixelFormat pixelFormat2 = pixelFormatArray[i];
            System.err.println("CONVERT[" + i + "]: " + (Object)((Object)pixelFormat) + " -> " + (Object)((Object)pixelFormat2));
            PixelRectangle pixelRectangle = PixelFormatUtil.convert((PixelRectangle)pNGPixelRect, pixelFormat2, n, bl, false);
            System.err.println("PNGPixelRect - Conv1: " + pixelRectangle);
            System.err.printf("Conv1 Data: %s%n", Bitstream.toHexBinString(true, pixelRectangle.getPixels(), 0, pixelRectangle.getPixelformat().comp.bytesPerPixel()));
            TestPixelFormatUtil00NEWT.dumpComponents(pixelRectangle, 0, 0, 3, 3);
            PixelRectangle pixelRectangle2 = PixelFormatUtil.convert(pixelRectangle, pNGPixelRect.getPixelformat(), pNGPixelRect.getStride(), pNGPixelRect.isGLOriented(), false);
            System.err.println("PNGPixelRect - Conv2: " + pixelRectangle2);
            System.err.printf("Conv2 Data: %s%n", Bitstream.toHexBinString(true, pixelRectangle2.getPixels(), 0, pixelRectangle2.getPixelformat().comp.bytesPerPixel()));
            TestPixelFormatUtil00NEWT.dumpComponents(pixelRectangle2, 0, 0, 3, 3);
            Assert.assertEquals((Object)pNGPixelRect.getPixels(), (Object)pixelRectangle2.getPixels());
        }
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestPixelFormatUtil01NEWT.class.getName()});
    }
}

