/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.acore.glels;

import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowAdapter;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.WindowUpdateEvent;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLAutoDrawableDelegate;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.GLEventListenerCounter;
import com.jogamp.opengl.test.junit.util.QuitAdapter;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestGLContextDrawableSwitch10NEWT
extends UITestCase {
    static long duration = 1000L;
    static int width;
    static int height;

    static GLCapabilities getCaps(String string) {
        if (!GLProfile.isAvailable(string)) {
            System.err.println("Profile " + string + " n/a");
            return null;
        }
        return new GLCapabilities(GLProfile.get(string));
    }

    @BeforeClass
    public static void initClass() {
        width = 256;
        height = 256;
    }

    private GLAutoDrawable createGLAutoDrawableWithoutContext(GLCapabilities gLCapabilities, int n, int n2, int n3, int n4, WindowListener windowListener) throws InterruptedException {
        final Window window = NewtFactory.createWindow(gLCapabilities);
        Assert.assertNotNull((Object)window);
        window.setPosition(n, n2);
        window.setSize(n3, n4);
        window.setVisible(true);
        Assert.assertTrue((boolean)AWTRobotUtil.waitForVisible(window, true));
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, true));
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        GLDrawable gLDrawable = gLDrawableFactory.createGLDrawable(window);
        Assert.assertNotNull((Object)gLDrawable);
        gLDrawable.setRealized(true);
        Assert.assertTrue((boolean)gLDrawable.isRealized());
        final GLAutoDrawableDelegate gLAutoDrawableDelegate = new GLAutoDrawableDelegate(gLDrawable, null, window, false, null){

            @Override
            protected void destroyImplInLock() {
                super.destroyImplInLock();
                window.destroy();
            }
        };
        window.setWindowDestroyNotifyAction(new Runnable(){

            @Override
            public void run() {
                gLAutoDrawableDelegate.windowDestroyNotifyOp();
            }
        });
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowRepaint(WindowUpdateEvent windowUpdateEvent) {
                gLAutoDrawableDelegate.windowRepaintOp();
            }

            @Override
            public void windowResized(WindowEvent windowEvent) {
                gLAutoDrawableDelegate.windowResizedOp(window.getSurfaceWidth(), window.getSurfaceHeight());
            }
        });
        window.addWindowListener(windowListener);
        return gLAutoDrawableDelegate;
    }

    @Test(timeout=30000L)
    public void test01GLADDelegateGL2ES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch10NEWT.getCaps("GL2ES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testGLADDelegateImpl(gLCapabilities);
    }

    @Test(timeout=30000L)
    public void test02GLADDelegateGLES2() throws InterruptedException {
        GLCapabilities gLCapabilities = TestGLContextDrawableSwitch10NEWT.getCaps("GLES2");
        if (null == gLCapabilities) {
            return;
        }
        this.testGLADDelegateImpl(gLCapabilities);
    }

    private void testGLADDelegateImpl(GLCapabilities gLCapabilities) throws InterruptedException {
        long l;
        long l2;
        GLEventListenerCounter gLEventListenerCounter = new GLEventListenerCounter();
        UITestCase.SnapshotGLEventListener snapshotGLEventListener = new UITestCase.SnapshotGLEventListener(this);
        Animator animator = new Animator();
        animator.start();
        QuitAdapter quitAdapter = new QuitAdapter();
        GLAutoDrawable gLAutoDrawable = this.createGLAutoDrawableWithoutContext(gLCapabilities, 64, 64, width, height, quitAdapter);
        GLContext gLContext = gLAutoDrawable.createContext(null);
        gLAutoDrawable.setContext(gLContext, true);
        animator.add(gLAutoDrawable);
        gLAutoDrawable.addGLEventListener(gLEventListenerCounter);
        gLAutoDrawable.addGLEventListener(new GearsES2(1));
        gLAutoDrawable.addGLEventListener(snapshotGLEventListener);
        snapshotGLEventListener.setMakeSnapshot();
        long l3 = l2 = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l3 - l2 < duration) {
            Thread.sleep(100L);
            l3 = System.currentTimeMillis();
        }
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        Assert.assertEquals((Object)gLContext, (Object)gLAutoDrawable.getContext());
        Assert.assertEquals((long)3L, (long)gLAutoDrawable.getGLEventListenerCount());
        Assert.assertEquals((Object)gLContext.getGLReadDrawable(), (Object)gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals((Object)gLContext.getGLDrawable(), (Object)gLAutoDrawable.getDelegatedDrawable());
        GLEventListenerState gLEventListenerState = GLEventListenerState.moveFrom(gLAutoDrawable);
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        Assert.assertEquals((Object)gLContext, (Object)gLEventListenerState.context);
        Assert.assertNull((Object)gLContext.getGLReadDrawable());
        Assert.assertNull((Object)gLContext.getGLDrawable());
        Assert.assertEquals((long)3L, (long)gLEventListenerState.listenerCount());
        Assert.assertEquals((Object)true, (Object)gLEventListenerState.isOwner());
        Assert.assertEquals(null, (Object)gLAutoDrawable.getContext());
        Assert.assertEquals((long)0L, (long)gLAutoDrawable.getGLEventListenerCount());
        gLAutoDrawable.destroy();
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        quitAdapter = new QuitAdapter();
        gLAutoDrawable = this.createGLAutoDrawableWithoutContext(gLCapabilities, 128 + width, 64, width + 100, height + 100, quitAdapter);
        snapshotGLEventListener.setMakeSnapshot();
        Assert.assertEquals(null, (Object)gLAutoDrawable.getContext());
        Assert.assertEquals((long)0L, (long)gLAutoDrawable.getGLEventListenerCount());
        gLEventListenerState.moveTo(gLAutoDrawable);
        Assert.assertTrue((boolean)gLAutoDrawable.isRealized());
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)gLEventListenerCounter.disposeCount);
        Assert.assertEquals((Object)gLEventListenerState.context, (Object)gLAutoDrawable.getContext());
        Assert.assertEquals((long)3L, (long)gLAutoDrawable.getGLEventListenerCount());
        Assert.assertEquals((Object)gLEventListenerState.context.getGLReadDrawable(), (Object)gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals((Object)gLEventListenerState.context.getGLDrawable(), (Object)gLAutoDrawable.getDelegatedDrawable());
        Assert.assertEquals((Object)false, (Object)gLEventListenerState.isOwner());
        long l4 = l = System.currentTimeMillis();
        while (!quitAdapter.shouldQuit() && l4 - l < duration) {
            Thread.sleep(100L);
            l4 = System.currentTimeMillis();
        }
        gLAutoDrawable.destroy();
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.initCount);
        Assert.assertTrue((1 <= gLEventListenerCounter.reshapeCount ? 1 : 0) != 0);
        Assert.assertTrue((1 <= gLEventListenerCounter.displayCount ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)gLEventListenerCounter.disposeCount);
        animator.stop();
    }

    public static void main(String[] stringArray) throws IOException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-time")) continue;
            ++i;
            try {
                duration = Integer.parseInt(stringArray[i]);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        JUnitCore.main((String[])new String[]{TestGLContextDrawableSwitch10NEWT.class.getName()});
    }
}

