/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.oculusvr;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.oculusvr.ovrPoseStatef;
import com.jogamp.oculusvr.ovrPosef;
import com.jogamp.oculusvr.ovrSensorData;
import java.nio.ByteBuffer;
import jogamp.common.os.MachineDataInfoRuntime;

public class ovrTrackingState {
    StructAccessor accessor;
    private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();
    private final MachineDataInfo md;
    private static final int[] ovrTrackingState_size = new int[]{216, 208, 208, 216, 216, 216, 216, 216};
    private static final int[] HeadPose_offset = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] HeadPose_size = new int[]{88, 84, 84, 88, 88, 88, 88, 88};
    private static final int[] CameraPose_offset = new int[]{88, 84, 84, 88, 88, 88, 88, 88};
    private static final int[] CameraPose_size = new int[]{28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] LeveledCameraPose_offset = new int[]{116, 112, 112, 116, 116, 116, 116, 116};
    private static final int[] LeveledCameraPose_size = new int[]{28, 28, 28, 28, 28, 28, 28, 28};
    private static final int[] RawSensorData_offset = new int[]{144, 140, 140, 144, 144, 144, 144, 144};
    private static final int[] RawSensorData_size = new int[]{44, 44, 44, 44, 44, 44, 44, 44};
    private static final int[] StatusFlags_offset = new int[]{188, 184, 184, 188, 188, 188, 188, 188};
    private static final int[] LastVisionProcessingTime_offset = new int[]{192, 188, 188, 192, 192, 192, 192, 192};
    private static final int[] LastVisionFrameLatency_offset = new int[]{200, 196, 196, 200, 200, 200, 200, 200};
    private static final int[] LastCameraFrameCounter_offset = new int[]{208, 204, 204, 208, 208, 208, 208, 208};

    public static int size() {
        return ovrTrackingState_size[mdIdx];
    }

    public static ovrTrackingState create() {
        return ovrTrackingState.create(Buffers.newDirectByteBuffer(ovrTrackingState.size()));
    }

    public static ovrTrackingState create(ByteBuffer byteBuffer) {
        return new ovrTrackingState(byteBuffer);
    }

    ovrTrackingState(ByteBuffer byteBuffer) {
        this.md = MachineDataInfo.StaticConfig.values()[ovrTrackingState.mdIdx].md;
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public ovrPoseStatef getHeadPose() {
        return ovrPoseStatef.create(this.accessor.slice(HeadPose_offset[mdIdx], HeadPose_size[mdIdx]));
    }

    public ovrPosef getCameraPose() {
        return ovrPosef.create(this.accessor.slice(CameraPose_offset[mdIdx], CameraPose_size[mdIdx]));
    }

    public ovrPosef getLeveledCameraPose() {
        return ovrPosef.create(this.accessor.slice(LeveledCameraPose_offset[mdIdx], LeveledCameraPose_size[mdIdx]));
    }

    public ovrSensorData getRawSensorData() {
        return ovrSensorData.create(this.accessor.slice(RawSensorData_offset[mdIdx], RawSensorData_size[mdIdx]));
    }

    public ovrTrackingState setStatusFlags(int n) {
        this.accessor.setIntAt(StatusFlags_offset[mdIdx], n, this.md.intSizeInBytes());
        return this;
    }

    public int getStatusFlags() {
        return this.accessor.getIntAt(StatusFlags_offset[mdIdx], this.md.intSizeInBytes());
    }

    public ovrTrackingState setLastVisionProcessingTime(double d) {
        this.accessor.setDoubleAt(LastVisionProcessingTime_offset[mdIdx], d);
        return this;
    }

    public double getLastVisionProcessingTime() {
        return this.accessor.getDoubleAt(LastVisionProcessingTime_offset[mdIdx]);
    }

    public ovrTrackingState setLastVisionFrameLatency(double d) {
        this.accessor.setDoubleAt(LastVisionFrameLatency_offset[mdIdx], d);
        return this;
    }

    public double getLastVisionFrameLatency() {
        return this.accessor.getDoubleAt(LastVisionFrameLatency_offset[mdIdx]);
    }

    public ovrTrackingState setLastCameraFrameCounter(int n) {
        this.accessor.setIntAt(LastCameraFrameCounter_offset[mdIdx], n);
        return this;
    }

    public int getLastCameraFrameCounter() {
        return this.accessor.getIntAt(LastCameraFrameCounter_offset[mdIdx]);
    }
}

