/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.newt.mm;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.opengl.GLWindow;
import com.jogamp.newt.util.MonitorModeUtil;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.jogl.demos.es2.GearsES2;
import com.jogamp.opengl.test.junit.util.AWTRobotUtil;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.Animator;
import java.io.IOException;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestScreenMode01dNEWT
extends UITestCase {
    static GLProfile glp;
    static int width;
    static int height;
    static int waitTimeShort;
    static int waitTimeLong;

    @BeforeClass
    public static void initClass() {
        TestScreenMode01dNEWT.setResetXRandRIfX11AfterClass();
        width = 640;
        height = 480;
        glp = GLProfile.getDefault();
    }

    @AfterClass
    public static void releaseClass() throws InterruptedException {
        Thread.sleep(waitTimeShort);
    }

    private void cleanupGL() throws InterruptedException {
        System.err.println("*** cleanupGL.shutdown");
        GLProfile.shutdown();
        System.err.println("*** cleanupGL.initSingleton");
        GLProfile.initSingleton();
        System.err.println("*** cleanupGL.DONE");
    }

    static GLWindow createWindow(Screen screen, GLCapabilities gLCapabilities, int n, int n2, boolean bl, boolean bl2) {
        Assert.assertNotNull((Object)gLCapabilities);
        gLCapabilities.setOnscreen(bl);
        GLWindow gLWindow = GLWindow.create(screen, (GLCapabilitiesImmutable)gLCapabilities);
        gLWindow.setSize(n, n2);
        gLWindow.addGLEventListener(new GearsES2());
        Assert.assertNotNull((Object)gLWindow);
        gLWindow.setVisible(true);
        return gLWindow;
    }

    static void destroyWindow(Window window) throws InterruptedException {
        if (null != window) {
            window.destroy();
            Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(window, false));
        }
    }

    @Test
    public void test01FullscreenChange01() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestScreenMode01dNEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Animator animator = new Animator(gLWindow);
        animator.start();
        MonitorDevice monitorDevice = gLWindow.getMainMonitor();
        Assert.assertEquals((Object)false, (Object)gLWindow.isFullscreen());
        Assert.assertEquals((long)width, (long)gLWindow.getWidth());
        Assert.assertEquals((long)height, (long)gLWindow.getHeight());
        gLWindow.setFullscreen(true);
        Assert.assertEquals((Object)true, (Object)gLWindow.isFullscreen());
        Assert.assertEquals((long)monitorDevice.getViewport().getWidth(), (long)gLWindow.getSurfaceWidth());
        Assert.assertEquals((long)monitorDevice.getViewport().getHeight(), (long)gLWindow.getSurfaceHeight());
        Thread.sleep(waitTimeShort);
        gLWindow.setFullscreen(false);
        Assert.assertEquals((Object)false, (Object)gLWindow.isFullscreen());
        Assert.assertEquals((long)width, (long)gLWindow.getWidth());
        Assert.assertEquals((long)height, (long)gLWindow.getHeight());
        Thread.sleep(waitTimeShort);
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        TestScreenMode01dNEWT.destroyWindow(gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isRealized());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        this.cleanupGL();
    }

    @Test
    public void test02ScreenModeChange01() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Assert.assertNotNull((Object)gLCapabilities);
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull((Object)screen);
        GLWindow gLWindow = TestScreenMode01dNEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Assert.assertNotNull((Object)gLWindow);
        Rectangle rectangle = gLWindow.getBounds();
        MonitorDevice monitorDevice = screen.getMainMonitor(rectangle);
        List<MonitorMode> list = monitorDevice.getSupportedModes();
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        if (list.size() == 1) {
            System.err.println("Your platform has no MonitorMode change support, sorry");
            TestScreenMode01dNEWT.destroyWindow(gLWindow);
            return;
        }
        Animator animator = new Animator(gLWindow);
        animator.start();
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        list = MonitorModeUtil.filterByFlags(list, 0);
        Assert.assertNotNull(list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        list = MonitorModeUtil.filterByRotation(list, 0);
        Assert.assertNotNull(list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        list = MonitorModeUtil.filterByResolution(list, new Dimension(801, 601));
        Assert.assertNotNull(list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        list = MonitorModeUtil.filterByRate(list, monitorMode2.getRefreshRate());
        Assert.assertNotNull(list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        list = MonitorModeUtil.getHighestAvailableBpp(list);
        Assert.assertNotNull(list);
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        MonitorMode monitorMode3 = list.get(0);
        System.err.println("[0] set current: " + monitorMode3);
        boolean bl = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[0] has current: " + monitorMode + ", changeOK " + bl);
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl);
        Thread.sleep(waitTimeLong);
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        TestScreenMode01dNEWT.destroyWindow(gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isRealized());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        this.validateScreenModeReset(monitorMode2, rectangle);
        this.cleanupGL();
    }

    @Test
    public void test03ScreenModeChangeWithFS01Post() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        this.testScreenModeChangeWithFS01Impl(false);
    }

    @Test
    public void test04ScreenModeChangeWithFS01Pre() throws InterruptedException {
        Thread.sleep(waitTimeShort);
        this.testScreenModeChangeWithFS01Impl(true);
    }

    protected void testScreenModeChangeWithFS01Impl(boolean bl) throws InterruptedException {
        GLCapabilities gLCapabilities = new GLCapabilities(glp);
        Display display = NewtFactory.createDisplay(null);
        Screen screen = NewtFactory.createScreen(display, 0);
        GLWindow gLWindow = TestScreenMode01dNEWT.createWindow(screen, gLCapabilities, width, height, true, false);
        Animator animator = new Animator(gLWindow);
        animator.start();
        Rectangle rectangle = gLWindow.getBounds();
        MonitorDevice monitorDevice = screen.getMainMonitor(rectangle);
        MonitorMode monitorMode = monitorDevice.queryCurrentMode();
        Assert.assertNotNull((Object)monitorMode);
        MonitorMode monitorMode2 = monitorDevice.getOriginalMode();
        Assert.assertNotNull((Object)monitorMode2);
        System.err.println("[0] orig   : " + monitorMode2);
        System.err.println("[0] current: " + monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorMode2);
        List<MonitorMode> list = monitorDevice.getSupportedModes();
        if (list.size() == 1) {
            TestScreenMode01dNEWT.destroyWindow(gLWindow);
            return;
        }
        Assert.assertTrue((list.size() > 0 ? 1 : 0) != 0);
        list = MonitorModeUtil.filterByFlags(list, 0);
        list = MonitorModeUtil.filterByRotation(list, 0);
        list = MonitorModeUtil.filterByResolution(list, new Dimension(801, 601));
        list = MonitorModeUtil.filterByRate(list, monitorMode2.getRefreshRate());
        list = MonitorModeUtil.getHighestAvailableBpp(list);
        MonitorMode monitorMode3 = list.get(0);
        Assert.assertNotNull((Object)monitorMode3);
        if (bl) {
            System.err.println("[1] set FS pre 0: " + gLWindow.isFullscreen());
            gLWindow.setFullscreen(true);
            System.err.println("[1] set FS pre 1: " + gLWindow.isFullscreen());
            Assert.assertEquals((Object)true, (Object)gLWindow.isFullscreen());
            System.err.println("[1] set FS pre X: " + gLWindow.isFullscreen());
        }
        Thread.sleep(waitTimeShort);
        System.err.println("[2] set current: " + monitorMode3);
        boolean bl2 = monitorDevice.setCurrentMode(monitorMode3);
        monitorMode = monitorDevice.getCurrentMode();
        System.err.println("[2] has current: " + monitorMode + ", changeOK " + bl2);
        Assert.assertTrue((boolean)monitorDevice.isModeChangedByUs());
        Assert.assertEquals((Object)monitorMode3, (Object)monitorMode);
        Assert.assertNotSame((Object)monitorMode2, (Object)monitorMode);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.queryCurrentMode());
        Assert.assertTrue((boolean)bl2);
        if (!bl) {
            System.err.println("[3] set FS post 0: " + gLWindow.isFullscreen());
            gLWindow.setFullscreen(true);
            Assert.assertEquals((Object)true, (Object)gLWindow.isFullscreen());
            System.err.println("[3] set FS post X: " + gLWindow.isFullscreen());
        }
        Thread.sleep(waitTimeLong);
        if (!bl) {
            System.err.println("[4] set !FS post 0: " + gLWindow.isFullscreen());
            gLWindow.setFullscreen(false);
            Assert.assertEquals((Object)false, (Object)gLWindow.isFullscreen());
            System.err.println("[4] set !FS post X: " + gLWindow.isFullscreen());
            Thread.sleep(waitTimeShort);
        }
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isNativeValid());
        Assert.assertEquals((Object)true, (Object)gLWindow.isVisible());
        animator.stop();
        Assert.assertEquals((Object)false, (Object)animator.isAnimating());
        Assert.assertEquals((Object)false, (Object)animator.isStarted());
        TestScreenMode01dNEWT.destroyWindow(gLWindow);
        Assert.assertEquals((Object)false, (Object)gLWindow.isVisible());
        Assert.assertEquals((Object)false, (Object)gLWindow.isRealized());
        Assert.assertEquals((Object)false, (Object)gLWindow.isNativeValid());
        Assert.assertTrue((boolean)AWTRobotUtil.waitForRealized(screen, false));
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        this.validateScreenModeReset(monitorMode2, rectangle);
        this.cleanupGL();
    }

    void validateScreenModeReset(MonitorMode monitorMode, RectangleImmutable rectangleImmutable) {
        Display display = NewtFactory.createDisplay(null);
        Assert.assertNotNull((Object)display);
        Screen screen = NewtFactory.createScreen(display, 0);
        Assert.assertNotNull((Object)screen);
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
        screen.addReference();
        Assert.assertEquals((Object)true, (Object)display.isNativeValid());
        Assert.assertEquals((Object)true, (Object)screen.isNativeValid());
        MonitorDevice monitorDevice = screen.getMainMonitor(rectangleImmutable);
        Assert.assertEquals((Object)monitorMode, (Object)monitorDevice.getCurrentMode());
        screen.removeReference();
        Assert.assertEquals((Object)false, (Object)display.isNativeValid());
        Assert.assertEquals((Object)false, (Object)screen.isNativeValid());
    }

    public static void main(String[] stringArray) throws IOException {
        String string = TestScreenMode01dNEWT.class.getName();
        JUnitCore.main((String[])new String[]{string});
    }

    static {
        waitTimeShort = 2000;
        waitTimeLong = 8000;
    }
}

