/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.jogl.awt;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.test.junit.util.UITestCase;
import com.jogamp.opengl.util.awt.AWTGLReadBufferUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TestBug461PBufferSupersamplingSwingAWT
extends UITestCase
implements GLEventListener {
    JFrame jframe;
    GLOffscreenAutoDrawable offScreenBuffer;
    AWTGLReadBufferUtil screenshot;

    private void render(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        Assert.assertNotNull((Object)gL2);
        gL2.glClear(16384);
        gL2.glBegin(4);
        gL2.glColor3f(1.0f, 0.0f, 0.0f);
        gL2.glVertex2d(-1.0, -1.0);
        gL2.glColor3f(0.0f, 1.0f, 0.0f);
        gL2.glVertex2d(0.0, 1.0);
        gL2.glColor3f(0.0f, 0.0f, 1.0f);
        gL2.glVertex2d(1.0, -1.0);
        gL2.glEnd();
    }

    @Override
    public void init(GLAutoDrawable gLAutoDrawable) {
        this.screenshot = new AWTGLReadBufferUtil(gLAutoDrawable.getGLProfile(), false);
    }

    @Override
    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    @Override
    public void display(GLAutoDrawable gLAutoDrawable) {
        this.render(this.offScreenBuffer);
        BufferedImage bufferedImage = this.screenshot.readPixelsToBufferedImage(gLAutoDrawable.getGL(), 0, 0, 200, 200, true);
        Assert.assertNotNull((Object)bufferedImage);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        JLabel jLabel = new JLabel(imageIcon);
        this.jframe.getContentPane().add(jLabel);
    }

    @Override
    public void dispose(GLAutoDrawable gLAutoDrawable) {
        this.screenshot.dispose(gLAutoDrawable.getGL());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    TestBug461PBufferSupersamplingSwingAWT.this.jframe.setVisible(false);
                    TestBug461PBufferSupersamplingSwingAWT.this.jframe.dispose();
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Test
    public void test01DefaultOffscreenSupersampling() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = GLProfile.get("GL2");
        Assert.assertNotNull((Object)gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        this.test(gLCapabilities);
    }

    @Test
    public void test02PBufferOffscreenSupersampling() throws InterruptedException, InvocationTargetException {
        GLProfile gLProfile = GLProfile.get("GL2");
        Assert.assertNotNull((Object)gLProfile);
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        gLCapabilities.setPBuffer(true);
        this.test(gLCapabilities);
    }

    void test(GLCapabilities gLCapabilities) throws InterruptedException, InvocationTargetException {
        this.jframe = new JFrame("Offscreen Supersampling");
        Assert.assertNotNull((Object)this.jframe);
        this.jframe.setSize(300, 300);
        this.jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
        Assert.assertNotNull((Object)gLDrawableFactory);
        gLCapabilities.setSampleBuffers(true);
        gLCapabilities.setNumSamples(4);
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setStencilBits(1);
        this.offScreenBuffer = gLDrawableFactory.createOffscreenAutoDrawable(null, gLCapabilities, null, 200, 200);
        Assert.assertNotNull((Object)this.offScreenBuffer);
        this.offScreenBuffer.addGLEventListener(this);
        this.offScreenBuffer.display();
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                TestBug461PBufferSupersamplingSwingAWT.this.jframe.setVisible(true);
            }
        });
        this.offScreenBuffer.destroy();
    }

    public static void main(String[] stringArray) {
        JUnitCore.main((String[])new String[]{TestBug461PBufferSupersamplingSwingAWT.class.getName()});
    }
}

