/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.test.junit.graph.demos.ui;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.Vertex;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.test.junit.graph.demos.ui.UIShape;
import jogamp.graph.geom.plane.AffineTransform;

public class Label
extends UIShape {
    protected Font font;
    protected float pixelSize;
    protected String text;
    private final float[] tmpV3 = new float[3];
    private final AffineTransform tempT1 = new AffineTransform();
    private final AffineTransform tempT2 = new AffineTransform();
    private final TextRegionUtil.ShapeVisitor shapeVisitor = new TextRegionUtil.ShapeVisitor(){

        @Override
        public void visit(OutlineShape outlineShape, AffineTransform affineTransform) {
            outlineShape.setSharpness(Label.this.shapesSharpness);
            Label.this.region.addOutlineShape(outlineShape, affineTransform, Label.this.rgbaColor);
            Label.this.box.resize(outlineShape.getBounds(), affineTransform, Label.this.tmpV3);
        }
    };

    public Label(Vertex.Factory<? extends Vertex> factory, int n, Font font, float f, String string) {
        super(factory, n);
        this.font = font;
        this.pixelSize = f;
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.markShapeDirty();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.markShapeDirty();
    }

    public float getPixelSize() {
        return this.pixelSize;
    }

    public float getLineHeight() {
        return this.font.getLineHeight(this.pixelSize);
    }

    public void setPixelSize(float f) {
        this.pixelSize = f;
        this.markShapeDirty();
    }

    @Override
    protected void clearImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
    }

    @Override
    protected void addShapeToRegion(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        TextRegionUtil.processString(this.shapeVisitor, null, this.font, this.pixelSize, this.text, this.tempT1, this.tempT2);
        float[] fArray = this.box.getCenter();
        this.setRotationOrigin(fArray[0], fArray[1], fArray[2]);
    }

    @Override
    public String getSubString() {
        int n = Math.min(this.text.length(), 8);
        return super.getSubString() + ", psize " + this.pixelSize + ", '" + this.text.substring(0, n) + "'";
    }
}

