/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow.util;

import com.jogamp.common.util.IntBitfield;
import com.jogamp.nativewindow.util.PixelFormatUtil;
import java.util.Arrays;

public enum PixelFormat {
    LUMINANCE(new CType[]{CType.Y}, 1, 8, 8),
    RGB565(new CType[]{CType.R, CType.G, CType.B}, new int[]{31, 63, 31}, new int[]{0, 5, 11}, 16),
    BGR565(new CType[]{CType.B, CType.G, CType.R}, new int[]{31, 63, 31}, new int[]{0, 5, 11}, 16),
    RGBA5551(new CType[]{CType.R, CType.G, CType.B, CType.A}, new int[]{31, 31, 31, 1}, new int[]{0, 5, 10, 15}, 16),
    ABGR1555(new CType[]{CType.A, CType.B, CType.G, CType.R}, new int[]{1, 31, 31, 31}, new int[]{0, 1, 6, 11}, 16),
    RGB888(new CType[]{CType.R, CType.G, CType.B}, 3, 8, 24),
    BGR888(new CType[]{CType.B, CType.G, CType.R}, 3, 8, 24),
    RGBx8888(new CType[]{CType.R, CType.G, CType.B}, 3, 8, 32),
    BGRx8888(new CType[]{CType.B, CType.G, CType.R}, 3, 8, 32),
    RGBA8888(new CType[]{CType.R, CType.G, CType.B, CType.A}, 4, 8, 32),
    ABGR8888(new CType[]{CType.A, CType.B, CType.G, CType.R}, 4, 8, 32),
    ARGB8888(new CType[]{CType.A, CType.R, CType.G, CType.B}, 4, 8, 32),
    BGRA8888(new CType[]{CType.B, CType.G, CType.R, CType.A}, 4, 8, 32);

    public final Composition comp;

    private PixelFormat(CType[] cTypeArray, int n2, int n3, int n4) {
        this.comp = new PackedComposition(cTypeArray, n2, n3, n4);
    }

    private PixelFormat(CType[] cTypeArray, int[] nArray, int[] nArray2, int n2) {
        this.comp = new PackedComposition(cTypeArray, nArray, nArray2, n2);
    }

    public static PixelFormat valueOf(Composition composition) {
        PixelFormat[] pixelFormatArray = PixelFormat.values();
        for (int i = pixelFormatArray.length - 1; i >= 0; --i) {
            PixelFormat pixelFormat = pixelFormatArray[i];
            if (composition.hashCode() != pixelFormat.comp.hashCode() || !composition.equals(pixelFormat.comp)) continue;
            return pixelFormat;
        }
        return null;
    }

    private static String toHexString(int[] nArray, int[] nArray2, int[] nArray3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = nArray2.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(nArray[i]).append(": ").append("0x").append(Integer.toHexString(nArray2[i])).append(" << ").append(nArray3[i]);
        }
        return stringBuilder.append("]").toString();
    }

    public static class PackedComposition
    implements Composition {
        private final CType[] compOrder;
        private final int[] compMask;
        private final int[] compBitCount;
        private final int[] compBitShift;
        private final int bitsPerPixel;
        private final int bitStride;
        private final boolean uniform;
        private final int hashCode;

        @Override
        public final String toString() {
            return String.format("PackedComp[order %s, stride %d, bpp %d, uni %b, comp %d: %s]", Arrays.toString((Object[])this.compOrder), this.bitStride, this.bitsPerPixel, this.uniform, this.compMask.length, PixelFormat.toHexString(this.compBitCount, this.compMask, this.compBitShift));
        }

        public PackedComposition(CType[] cTypeArray, int n, int n2, int n3) {
            this.compOrder = cTypeArray;
            this.compMask = new int[n];
            this.compBitShift = new int[n];
            this.compBitCount = new int[n];
            int n4 = (1 << n2) - 1;
            for (int i = 0; i < n; ++i) {
                this.compMask[i] = n4;
                this.compBitShift[i] = n2 * i;
                this.compBitCount[i] = n2;
            }
            this.uniform = true;
            this.bitsPerPixel = n2 * n;
            this.bitStride = n3;
            if (this.bitStride < this.bitsPerPixel) {
                throw new IllegalArgumentException(String.format("bit-stride %d < bitsPerPixel %d", this.bitStride, this.bitsPerPixel));
            }
            this.hashCode = this.hashCodeImpl();
        }

        public PackedComposition(CType[] cTypeArray, int[] nArray, int[] nArray2, int n) {
            this.compOrder = cTypeArray;
            this.compMask = nArray;
            this.compBitShift = nArray2;
            this.compBitCount = new int[nArray.length];
            int n2 = 0;
            boolean bl = true;
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n3 = nArray[i];
                int n4 = IntBitfield.getBitCount(n3);
                n2 += n4;
                this.compBitCount[i] = n4;
                if (i <= 0 || !bl) continue;
                bl = nArray[i - 1] == n3;
            }
            this.uniform = bl;
            this.bitsPerPixel = n2;
            this.bitStride = n;
            if (this.bitStride < this.bitsPerPixel) {
                throw new IllegalArgumentException(String.format("bit-stride %d < bitsPerPixel %d", this.bitStride, this.bitsPerPixel));
            }
            this.hashCode = this.hashCodeImpl();
        }

        @Override
        public final boolean isUniform() {
            return this.uniform;
        }

        @Override
        public final boolean isInterleaved() {
            return true;
        }

        @Override
        public final int componentCount() {
            return this.compMask.length;
        }

        @Override
        public final int bitsPerPixel() {
            return this.bitsPerPixel;
        }

        @Override
        public final int bitStride() {
            return this.bitStride;
        }

        @Override
        public final int bytesPerPixel() {
            return (7 + this.bitStride) / 8;
        }

        @Override
        public final CType[] componentOrder() {
            return this.compOrder;
        }

        @Override
        public final int find(CType cType) {
            return PixelFormatUtil.find(cType, this.compOrder, false);
        }

        @Override
        public final int[] componentBitMask() {
            return this.compMask;
        }

        @Override
        public final int[] componentBitCount() {
            return this.compBitCount;
        }

        @Override
        public final int[] componentBitShift() {
            return this.compBitShift;
        }

        @Override
        public final int decodeSingleI32(int n, int n2) {
            return n >>> this.compBitShift[n2] & this.compMask[n2];
        }

        @Override
        public final int decodeSingleI64(long l, int n) {
            return (int)(0xFFFFFFFFL & l >>> this.compBitShift[n]) & this.compMask[n];
        }

        @Override
        public final int encodeSingleI32(int n, int n2) {
            return (n & this.compMask[n2]) << this.compBitShift[n2];
        }

        @Override
        public final long encodeSingleI64(int n, int n2) {
            return (0xFFFFFFFFL & (long)(n & this.compMask[n2])) << this.compBitShift[n2];
        }

        @Override
        public final int encode3CompI32(int n, int n2, int n3) {
            return (n & this.compMask[0]) << this.compBitShift[0] | (n2 & this.compMask[1]) << this.compBitShift[1] | (n3 & this.compMask[2]) << this.compBitShift[2];
        }

        @Override
        public final int encode4CompI32(int n, int n2, int n3, int n4) {
            return (n & this.compMask[0]) << this.compBitShift[0] | (n2 & this.compMask[1]) << this.compBitShift[1] | (n3 & this.compMask[2]) << this.compBitShift[2] | (n4 & this.compMask[3]) << this.compBitShift[3];
        }

        @Override
        public final int encodeSingleI8(byte by, int n) {
            return (by & this.compMask[n]) << this.compBitShift[n];
        }

        @Override
        public final int encode3CompI8(byte by, byte by2, byte by3) {
            return (by & this.compMask[0]) << this.compBitShift[0] | (by2 & this.compMask[1]) << this.compBitShift[1] | (by3 & this.compMask[2]) << this.compBitShift[2];
        }

        @Override
        public final int encode4CompI8(byte by, byte by2, byte by3, byte by4) {
            return (by & this.compMask[0]) << this.compBitShift[0] | (by2 & this.compMask[1]) << this.compBitShift[1] | (by3 & this.compMask[2]) << this.compBitShift[2] | (by4 & this.compMask[3]) << this.compBitShift[3];
        }

        @Override
        public final float toFloat(int n, int n2, boolean bl) {
            if (bl) {
                return (float)(n >>> this.compBitShift[n2] & this.compMask[n2]) / (float)this.compMask[n2];
            }
            return (float)(n & this.compMask[n2]) / (float)this.compMask[n2];
        }

        @Override
        public final int fromFloat(float f, int n, boolean bl) {
            int n2 = (int)(f * (float)this.compMask[n] + 0.5f);
            return bl ? n2 << this.compBitShift[n] : n2;
        }

        @Override
        public final int defaultValue(int n, boolean bl) {
            int n2 = CType.A == this.compOrder[n] || CType.Y == this.compOrder[n] ? this.compMask[n] : 0;
            return bl ? n2 << this.compBitShift[n] : n2;
        }

        @Override
        public final int hashCode() {
            return this.hashCode;
        }

        private final int hashCodeImpl() {
            int n;
            int n2 = 31 + this.bitStride;
            n2 = (n2 << 5) - n2 + this.bitsPerPixel;
            n2 = (n2 << 5) - n2 + this.compMask.length;
            for (n = this.compOrder.length - 1; n >= 0; --n) {
                n2 = (n2 << 5) - n2 + this.compOrder[n].ordinal();
            }
            for (n = this.compMask.length - 1; n >= 0; --n) {
                n2 = (n2 << 5) - n2 + this.compMask[n];
            }
            for (n = this.compBitShift.length - 1; n >= 0; --n) {
                n2 = (n2 << 5) - n2 + this.compBitShift[n];
            }
            return n2;
        }

        @Override
        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof PackedComposition) {
                PackedComposition packedComposition = (PackedComposition)object;
                return this.bitStride == packedComposition.bitStride && this.bitsPerPixel == packedComposition.bitsPerPixel && Arrays.equals((Object[])this.compOrder, (Object[])packedComposition.compOrder) && Arrays.equals(this.compMask, packedComposition.compMask) && Arrays.equals(this.compBitShift, packedComposition.compBitShift);
            }
            return false;
        }
    }

    public static interface Composition {
        public static final int UNDEF = -1;

        public boolean isUniform();

        public boolean isInterleaved();

        public int componentCount();

        public int bitsPerPixel();

        public int bitStride();

        public int bytesPerPixel();

        public CType[] componentOrder();

        public int find(CType var1);

        public int[] componentBitMask();

        public int[] componentBitCount();

        public int[] componentBitShift();

        public int decodeSingleI32(int var1, int var2);

        public int decodeSingleI64(long var1, int var3);

        public int encodeSingleI32(int var1, int var2);

        public long encodeSingleI64(int var1, int var2);

        public int encode3CompI32(int var1, int var2, int var3);

        public int encode4CompI32(int var1, int var2, int var3, int var4);

        public int encodeSingleI8(byte var1, int var2);

        public int encode3CompI8(byte var1, byte var2, byte var3);

        public int encode4CompI8(byte var1, byte var2, byte var3, byte var4);

        public float toFloat(int var1, int var2, boolean var3);

        public int fromFloat(float var1, int var2, boolean var3);

        public int defaultValue(int var1, boolean var2);

        public int hashCode();

        public boolean equals(Object var1);

        public String toString();
    }

    public static enum CType {
        R,
        G,
        B,
        A,
        Y,
        U,
        V;

    }
}

