/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.jcpp;

import com.jogamp.gluegen.jcpp.LexerException;
import com.jogamp.gluegen.jcpp.Macro;
import com.jogamp.gluegen.jcpp.Preprocessor;
import com.jogamp.gluegen.jcpp.PreprocessorListener;
import com.jogamp.gluegen.jcpp.SourceIterator;
import com.jogamp.gluegen.jcpp.Token;
import com.jogamp.gluegen.jcpp.Warning;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class Source
implements Iterable<Token>,
Closeable {
    private Source parent = null;
    private boolean autopop = false;
    private PreprocessorListener listener = null;
    private boolean active = true;
    private boolean werror = false;

    void setParent(Source source, boolean bl) {
        this.parent = source;
        this.autopop = bl;
    }

    public final Source getParent() {
        return this.parent;
    }

    void init(Preprocessor preprocessor) {
        this.setListener(preprocessor.getListener());
        this.werror = preprocessor.getWarnings().contains((Object)Warning.ERROR);
    }

    public void setListener(PreprocessorListener preprocessorListener) {
        this.listener = preprocessorListener;
    }

    @CheckForNull
    public String getPath() {
        Source source = this.getParent();
        if (source != null) {
            return source.getPath();
        }
        return null;
    }

    @CheckForNull
    public String getName() {
        Source source = this.getParent();
        if (source != null) {
            return source.getName();
        }
        return null;
    }

    @Nonnegative
    public int getLine() {
        Source source = this.getParent();
        if (source == null) {
            return 0;
        }
        return source.getLine();
    }

    public int getColumn() {
        Source source = this.getParent();
        if (source == null) {
            return 0;
        }
        return source.getColumn();
    }

    boolean isExpanding(@Nonnull Macro macro) {
        Source source = this.getParent();
        if (source != null) {
            return source.isExpanding(macro);
        }
        return false;
    }

    boolean isAutopop() {
        return this.autopop;
    }

    boolean isNumbered() {
        return false;
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    boolean isActive() {
        return this.active;
    }

    @Nonnull
    public abstract Token token() throws IOException, LexerException;

    @Override
    public Iterator<Token> iterator() {
        return new SourceIterator(this);
    }

    @Nonnull
    public Token skipline(boolean bl) throws IOException, LexerException {
        block5: while (true) {
            Token token = this.token();
            switch (token.getType()) {
                case 265: {
                    this.warning(token.getLine(), token.getColumn(), "No newline before end of file");
                    return new Token(284, token.getLine(), token.getColumn(), "\n");
                }
                case 284: {
                    return token;
                }
                case 260: 
                case 261: 
                case 294: {
                    continue block5;
                }
            }
            if (!bl) continue;
            this.warning(token.getLine(), token.getColumn(), "Unexpected nonwhite token");
        }
    }

    protected void error(int n, int n2, String string) throws LexerException {
        if (this.listener == null) {
            throw new LexerException("Error at " + n + ":" + n2 + ": " + string);
        }
        this.listener.handleError(this, n, n2, string);
    }

    protected void warning(int n, int n2, String string) throws LexerException {
        if (this.werror) {
            this.error(n, n2, string);
        } else if (this.listener != null) {
            this.listener.handleWarning(this, n, n2, string);
        } else {
            throw new LexerException("Warning at " + n + ":" + n2 + ": " + string);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

