/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.junit.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public abstract class JunitTracer {
    @Rule
    public final TestName _unitTestName = new TestName();
    static volatile boolean testSupported = true;
    static final String unsupportedTestMsg = "Test not supported on this platform.";

    public static final boolean isTestSupported() {
        return testSupported;
    }

    public static final void setTestSupported(boolean bl) {
        System.err.println("setTestSupported: " + bl);
        testSupported = bl;
    }

    public final String getTestMethodName() {
        return this._unitTestName.getMethodName();
    }

    public final String getSimpleTestName(String string) {
        return this.getClass().getSimpleName() + string + this.getTestMethodName();
    }

    public final String getFullTestName(String string) {
        return this.getClass().getName() + string + this.getTestMethodName();
    }

    @BeforeClass
    public static final void oneTimeSetUpBase() {
    }

    @AfterClass
    public static final void oneTimeTearDownBase() {
        System.gc();
    }

    @Before
    public final void setUpBase() {
        System.err.print("++++ TestCase.setUp: " + this.getFullTestName(" - "));
        if (!testSupported) {
            System.err.println(" - Test not supported on this platform.");
            Assume.assumeTrue((boolean)testSupported);
        }
        System.err.println();
    }

    @After
    public final void tearDownBase() {
        System.err.println("++++ TestCase.tearDown: " + this.getFullTestName(" - "));
    }

    public static final void waitForKey(String string) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        System.err.println(string + "> Press enter to continue");
        try {
            System.err.println(bufferedReader.readLine());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

