/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.macosx;

import com.jogamp.common.util.Function;
import com.jogamp.common.util.FunctionTask;
import com.jogamp.common.util.RunnableTask;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.ToolkitProperties;

public class OSXUtil
implements ToolkitProperties {
    private static boolean isInit = false;
    private static final boolean DEBUG = Debug.debug("OSXUtil");
    public static final int MAX_PIXELSCALE = 2;
    private static Runnable _nop = new Runnable(){

        @Override
        public void run() {
        }
    };

    public static synchronized void initSingleton() {
        if (!isInit) {
            if (DEBUG) {
                System.out.println("OSXUtil.initSingleton()");
            }
            if (!NWJNILibLoader.loadNativeWindow("macosx")) {
                throw new NativeWindowException("NativeWindow MacOSX native library load error.");
            }
            if (!OSXUtil.initIDs0()) {
                throw new NativeWindowException("MacOSX: Could not initialized native stub");
            }
            isInit = true;
        }
    }

    public static void shutdown() {
    }

    public static boolean requiresToolkitLock() {
        return false;
    }

    public static final boolean hasThreadingIssues() {
        return false;
    }

    public static boolean isNSView(long l) {
        return 0L != l ? OSXUtil.isNSView0(l) : false;
    }

    public static boolean isNSWindow(long l) {
        return 0L != l ? OSXUtil.isNSWindow0(l) : false;
    }

    public static Point GetLocationOnScreen(long l, int n, int n2) {
        return (Point)OSXUtil.GetLocationOnScreen0(l, n, n2);
    }

    public static Insets GetInsets(long l) {
        return (Insets)OSXUtil.GetInsets0(l);
    }

    public static double GetPixelScaleByDisplayID(int n) {
        if (0 != n) {
            return OSXUtil.GetPixelScale1(n);
        }
        return 1.0;
    }

    public static double GetPixelScale(long l) {
        if (0L != l) {
            return OSXUtil.GetPixelScale2(l);
        }
        return 1.0;
    }

    public static long CreateNSWindow(int n, int n2, int n3, int n4) {
        return OSXUtil.CreateNSWindow0(n, n2, n3, n4);
    }

    public static void DestroyNSWindow(long l) {
        OSXUtil.DestroyNSWindow0(l);
    }

    public static long GetNSView(long l) {
        return OSXUtil.GetNSView0(l);
    }

    public static long GetNSWindow(long l) {
        return OSXUtil.GetNSWindow0(l);
    }

    public static long CreateCALayer(int n, int n2, float f) {
        long l = OSXUtil.CreateCALayer0(n, n2, f);
        if (DEBUG) {
            System.err.println("OSXUtil.CreateCALayer: 0x" + Long.toHexString(l) + " - " + Thread.currentThread().getName());
        }
        return l;
    }

    public static void AddCASublayer(long l, long l2, int n, int n2, int n3, int n4, float f, int n5) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.AttachCALayer: caLayerQuirks " + n5 + ", 0x" + Long.toHexString(l2) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.AddCASublayer0(l, l2, n, n2, n3, n4, f, n5);
    }

    public static void FixCALayerLayout(long l, long l2, boolean bl, int n, int n2, int n3, int n4, int n5) {
        if (0L == l && 0L == l2) {
            return;
        }
        OSXUtil.FixCALayerLayout0(l, l2, bl, n, n2, n3, n4, n5);
    }

    public static void SetCALayerPixelScale(long l, long l2, float f) {
        if (0L == l && 0L == l2) {
            return;
        }
        OSXUtil.SetCALayerPixelScale0(l, l2, f);
    }

    public static void RemoveCASublayer(long l, long l2) {
        if (0L == l || 0L == l2) {
            throw new IllegalArgumentException("rootCALayer 0x" + Long.toHexString(l) + ", subCALayer 0x" + Long.toHexString(l2));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.DetachCALayer: 0x" + Long.toHexString(l2) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.RemoveCASublayer0(l, l2);
    }

    public static void DestroyCALayer(long l) {
        if (0L == l) {
            throw new IllegalArgumentException("caLayer 0x" + Long.toHexString(l));
        }
        if (DEBUG) {
            System.err.println("OSXUtil.DestroyCALayer: 0x" + Long.toHexString(l) + " - " + Thread.currentThread().getName());
        }
        OSXUtil.DestroyCALayer0(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void RunOnMainThread(boolean bl, boolean bl2, Runnable runnable) {
        if (OSXUtil.IsMainThread0()) {
            runnable.run();
        } else {
            Throwable throwable = null;
            Object object = new Object();
            RunnableTask runnableTask = new RunnableTask(runnable, bl ? object : null, true, bl ? null : System.err);
            Object object2 = object;
            synchronized (object2) {
                OSXUtil.RunOnMainThread0(bl2, runnableTask);
                if (bl) {
                    try {
                        object.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throwable = interruptedException;
                    }
                    if (null == throwable) {
                        throwable = runnableTask.getThrowable();
                    }
                    if (null != throwable) {
                        throw new RuntimeException(throwable);
                    }
                }
            }
        }
    }

    public static void RunLater(boolean bl, Runnable runnable, int n) {
        OSXUtil.RunLater0(bl, false, new RunnableTask(runnable, null, true, System.err), n);
    }

    public static void KickNSApp() {
        OSXUtil.KickNSApp0();
    }

    public static void WaitUntilFinish() {
        OSXUtil.RunOnMainThread(true, true, _nop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, A> R RunOnMainThread(boolean bl, boolean bl2, Function<R, A> function, A ... AArray) {
        if (OSXUtil.IsMainThread0()) {
            return function.eval(AArray);
        }
        Throwable throwable = null;
        Object object = new Object();
        FunctionTask<R, A> functionTask = new FunctionTask<R, A>(function, bl ? object : null, true, bl ? null : System.err);
        Object object2 = object;
        synchronized (object2) {
            functionTask.setArgs(AArray);
            OSXUtil.RunOnMainThread0(bl2, functionTask);
            if (bl) {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (null == throwable) {
                    throwable = functionTask.getThrowable();
                }
                if (null != throwable) {
                    throw new RuntimeException(throwable);
                }
            }
        }
        return functionTask.getResult();
    }

    public static boolean IsMainThread() {
        return OSXUtil.IsMainThread0();
    }

    public static int GetScreenRefreshRate(int n) {
        return OSXUtil.GetScreenRefreshRate0(n);
    }

    private static native boolean initIDs0();

    private static native boolean isNSView0(long var0);

    private static native boolean isNSWindow0(long var0);

    private static native Object GetLocationOnScreen0(long var0, int var2, int var3);

    private static native Object GetInsets0(long var0);

    private static native double GetPixelScale1(int var0);

    private static native double GetPixelScale2(long var0);

    private static native long CreateNSWindow0(int var0, int var1, int var2, int var3);

    private static native void DestroyNSWindow0(long var0);

    private static native long GetNSView0(long var0);

    private static native long GetNSWindow0(long var0);

    private static native long CreateCALayer0(int var0, int var1, float var2);

    private static native void AddCASublayer0(long var0, long var2, int var4, int var5, int var6, int var7, float var8, int var9);

    private static native void FixCALayerLayout0(long var0, long var2, boolean var4, int var5, int var6, int var7, int var8, int var9);

    private static native void SetCALayerPixelScale0(long var0, long var2, float var4);

    private static native void RemoveCASublayer0(long var0, long var2);

    private static native void DestroyCALayer0(long var0);

    private static native void RunOnMainThread0(boolean var0, Runnable var1);

    private static native void RunLater0(boolean var0, boolean var1, Runnable var2, int var3);

    private static native void KickNSApp0();

    private static native boolean IsMainThread0();

    private static native int GetScreenRefreshRate0(int var0);
}

