/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opencl.os.android;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.Window;
import jogamp.common.os.android.StaticContext;

public class JoclBaseActivity
extends Activity {
    boolean isDelegatedActivity = false;
    Activity rootActivity = this;
    boolean setThemeCalled = false;

    public void setRootActivity(Activity activity) {
        this.rootActivity = activity;
        this.isDelegatedActivity = this != activity;
    }

    public final boolean isDelegatedActivity() {
        return this.isDelegatedActivity;
    }

    public final Activity getActivity() {
        return this.rootActivity;
    }

    public void setFullscreenFeature(Window window, boolean bl) {
        if (null == window) {
            throw new IllegalArgumentException("Android or Window null");
        }
        if (bl) {
            window.requestFeature(1);
            window.addFlags(1024);
            window.clearFlags(2048);
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }

    public void setTransparencyTheme() {
        if (!this.setThemeCalled) {
            this.setThemeCalled = true;
            Context context = this.getActivity().getApplicationContext();
            String string = context.getPackageName() + ":style/Theme.Transparent";
            int n = context.getResources().getIdentifier("Theme.Transparent", "style", context.getPackageName());
            if (0 == n) {
                Log.d((String)"JogAmp.JOCL", (String)("SetTransparencyTheme: Resource n/a: " + string));
            } else {
                Log.d((String)"JogAmp.JOCL", (String)("SetTransparencyTheme: Setting style: " + string + ": 0x" + Integer.toHexString(n)));
                context.setTheme(n);
            }
        }
    }

    public Window getWindow() {
        if (this.isDelegatedActivity()) {
            return this.getActivity().getWindow();
        }
        return super.getWindow();
    }

    public void onCreate(Bundle bundle) {
        Log.d((String)"JogAmp.JOCL", (String)"onCreate.0");
        if (!this.isDelegatedActivity()) {
            super.onCreate(bundle);
        }
        StaticContext.init(this.rootActivity.getApplicationContext());
        Log.d((String)"JogAmp.JOCL", (String)"onCreate.X");
    }

    public void onStart() {
        Log.d((String)"JogAmp.JOCL", (String)"onStart.0");
        if (!this.isDelegatedActivity()) {
            super.onStart();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onStart.X");
    }

    public void onRestart() {
        Log.d((String)"JogAmp.JOCL", (String)"onRestart.0");
        if (!this.isDelegatedActivity()) {
            super.onRestart();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onRestart.X");
    }

    public void onResume() {
        Log.d((String)"JogAmp.JOCL", (String)"onResume.0");
        if (!this.isDelegatedActivity()) {
            super.onResume();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onResume.X");
    }

    public void onPause() {
        Log.d((String)"JogAmp.JOCL", (String)"onPause.0");
        if (!this.isDelegatedActivity()) {
            super.onPause();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onPause.X");
    }

    public void onStop() {
        Log.d((String)"JogAmp.JOCL", (String)"onStop.0");
        if (!this.isDelegatedActivity()) {
            super.onStop();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onStop.X");
    }

    public void onDestroy() {
        Log.d((String)"JogAmp.JOCL", (String)"onDestroy.0");
        if (!this.isDelegatedActivity()) {
            super.onDestroy();
        }
        Log.d((String)"JogAmp.JOCL", (String)"onDestroy.X");
    }
}

