/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen.cgram.types;

import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeVisitor;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class EnumType
extends IntType
implements Cloneable {
    private final IntType underlyingType;
    private ArrayList<Enum> enums;

    public EnumType(String string) {
        super(string, SizeThunk.LONG, false, 1);
        this.underlyingType = new IntType(string, SizeThunk.LONG, false, 1);
    }

    public EnumType(String string, SizeThunk sizeThunk, ASTLocusTag aSTLocusTag) {
        super(string, sizeThunk, false, 1, aSTLocusTag);
        this.underlyingType = new IntType(string, sizeThunk, false, 1, aSTLocusTag);
    }

    private EnumType(EnumType enumType, int n, ASTLocusTag aSTLocusTag) {
        super(enumType, n, aSTLocusTag);
        this.underlyingType = enumType.underlyingType;
        if (null != enumType.enums) {
            this.enums = new ArrayList<Enum>(enumType.enums);
        }
    }

    @Override
    Type newVariantImpl(boolean bl, int n, ASTLocusTag aSTLocusTag) {
        return new EnumType(this, n, aSTLocusTag);
    }

    @Override
    protected int hashCodeImpl() {
        int n = super.hashCodeImpl();
        n = (n << 5) - n + this.underlyingType.hashCode();
        return (n << 5) - n + TypeComparator.listsHashCode(this.enums);
    }

    @Override
    protected boolean equalsImpl(Type type) {
        EnumType enumType = (EnumType)type;
        return super.equalsImpl(type) && this.underlyingType.equals(enumType.underlyingType) && TypeComparator.listsEqual(this.enums, enumType.enums);
    }

    @Override
    protected int hashCodeSemanticsImpl() {
        int n = super.hashCodeSemanticsImpl();
        n = (n << 5) - n + this.underlyingType.hashCodeSemantics();
        return (n << 5) - n + TypeComparator.listsHashCodeSemantics(this.enums);
    }

    @Override
    protected boolean equalSemanticsImpl(Type type) {
        EnumType enumType = (EnumType)type;
        return super.equalSemanticsImpl(type) && this.underlyingType.equalSemantics(enumType.underlyingType) && TypeComparator.listsEqualSemantics(this.enums, enumType.enums);
    }

    @Override
    public EnumType asEnum() {
        return this;
    }

    public Type getUnderlyingType() {
        return this.underlyingType;
    }

    public void addEnum(String string, long l) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(new Enum(string, l));
        this.clearCache();
    }

    public int getNumEnumerates() {
        return this.enums.size();
    }

    public String getEnumName(int n) {
        return this.enums.get(n).getName();
    }

    public long getEnumValue(int n) {
        return this.enums.get(n).getValue();
    }

    public long getEnumValue(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum enum_ = this.enums.get(i);
            if (!enum_.getName().equals(string)) continue;
            return enum_.getValue();
        }
        throw new NoSuchElementException("No enumerate named \"" + string + "\" in EnumType \"" + this.getName() + "\"");
    }

    public boolean containsEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            if (!this.enums.get(i).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean removeEnumerate(String string) {
        for (int i = 0; i < this.enums.size(); ++i) {
            Enum enum_ = this.enums.get(i);
            if (!enum_.getName().equals(string)) continue;
            this.enums.remove(enum_);
            this.clearCache();
            return true;
        }
        return false;
    }

    public StringBuilder appendEnums(StringBuilder stringBuilder, boolean bl) {
        for (int i = 0; i < this.enums.size(); ++i) {
            stringBuilder.append(this.enums.get(i)).append(", ");
            if (!bl) continue;
            stringBuilder.append(String.format("%n", new Object[0]));
        }
        stringBuilder.append("}");
        return stringBuilder;
    }

    @Override
    public void visit(TypeVisitor typeVisitor) {
        super.visit(typeVisitor);
        this.underlyingType.visit(typeVisitor);
    }

    private static class Enum
    implements TypeComparator.SemanticEqualityOp {
        final String name;
        final long value;

        Enum(String string, long l) {
            this.name = string;
            this.value = l;
        }

        String getName() {
            return this.name;
        }

        long getValue() {
            return this.value;
        }

        public int hashCode() {
            int n = this.name.hashCode();
            return (n << 5) - n + (int)(this.value ^ this.value >>> 32);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Enum)) {
                return false;
            }
            Enum enum_ = (Enum)object;
            return this.name.equals(enum_.name) && this.value == enum_.value;
        }

        @Override
        public int hashCodeSemantics() {
            return this.hashCode();
        }

        @Override
        public boolean equalSemantics(TypeComparator.SemanticEqualityOp semanticEqualityOp) {
            return this.equals(semanticEqualityOp);
        }

        public String toString() {
            return this.name + " = " + this.value;
        }
    }
}

