/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.MachineDataInfo;
import com.jogamp.gluegen.ASTLocusTag;
import com.jogamp.gluegen.ArrayTypes;
import com.jogamp.gluegen.CMethodBindingEmitter;
import com.jogamp.gluegen.CodeGenUtils;
import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.FunctionEmitter;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.GlueGen;
import com.jogamp.gluegen.GlueGenException;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.JavaMethodBindingEmitter;
import com.jogamp.gluegen.JavaType;
import com.jogamp.gluegen.Logging;
import com.jogamp.gluegen.MethodBinding;
import com.jogamp.gluegen.SymbolFilter;
import com.jogamp.gluegen.TypeInfo;
import com.jogamp.gluegen.cgram.types.AliasedSymbol;
import com.jogamp.gluegen.cgram.types.ArrayType;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.Field;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.FunctionType;
import com.jogamp.gluegen.cgram.types.IntType;
import com.jogamp.gluegen.cgram.types.PointerType;
import com.jogamp.gluegen.cgram.types.SizeThunk;
import com.jogamp.gluegen.cgram.types.StructLayout;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeComparator;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.Buffer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.logging.Level;
import jogamp.common.os.MachineDataInfoRuntime;

public class JavaEmitter
implements GlueEmitter {
    private StructLayout layout;
    private Map<Type, Type> canonMap;
    protected JavaConfiguration cfg;
    private boolean requiresStaticInitialization = false;
    private String javaFileName;
    private PrintWriter javaWriter;
    private PrintWriter javaImplWriter;
    private String cFileName;
    private PrintWriter cWriter;
    private final MachineDataInfo machDescJava;
    private final MachineDataInfo.StaticConfig[] machDescTargetConfigs;
    protected final Logging.LoggerIf LOG;
    private static final String dummyFuncTypeName = "null *";
    private static final Type int32Type = new IntType("int32_t", SizeThunk.INT32, false, 1);
    private static final String nativeArrayLengthArg = "arrayLength";
    private static final String nativeArrayLengthONE = "1";
    private static final String nativeArrayElemOffsetArg = "elem_offset";
    private static final String staticClassInitCodeCCode = "\nstatic const char * clazzNameBuffers = \"com/jogamp/common/nio/Buffers\";\nstatic const char * clazzNameBuffersStaticNewCstrName = \"newDirectByteBuffer\";\nstatic const char * clazzNameBuffersStaticNewCstrSignature = \"(I)Ljava/nio/ByteBuffer;\";\nstatic jclass clazzBuffers = NULL;\nstatic jmethodID cstrBuffersNew = NULL;\nstatic jboolean _initClazzAccessDone = JNI_FALSE;\n\nstatic jboolean _initClazzAccess(JNIEnv *env) {\n    jclass c;\n\n    if(NULL!=cstrBuffersNew) return JNI_TRUE;\n\n    c = (*env)->FindClass(env, clazzNameBuffers);\n    if(NULL==c) {\n        fprintf(stderr, \"FatalError: Can't find %s\\n\", clazzNameBuffers);\n        (*env)->FatalError(env, clazzNameBuffers);\n        return JNI_FALSE;\n    }\n    clazzBuffers = (jclass)(*env)->NewGlobalRef(env, c);\n    if(NULL==clazzBuffers) {\n        fprintf(stderr, \"FatalError: Can't use %s\\n\", clazzNameBuffers);\n        (*env)->FatalError(env, clazzNameBuffers);\n        return JNI_FALSE;\n    }\n\n    cstrBuffersNew = (*env)->GetStaticMethodID(env, clazzBuffers,\n                            clazzNameBuffersStaticNewCstrName, clazzNameBuffersStaticNewCstrSignature);\n    if(NULL==cstrBuffersNew) {\n        fprintf(stderr, \"FatalError: can't create %s.%s %s\\n\",\n            clazzNameBuffers,\n            clazzNameBuffersStaticNewCstrName, clazzNameBuffersStaticNewCstrSignature);\n        (*env)->FatalError(env, clazzNameBuffersStaticNewCstrName);\n        return JNI_FALSE;\n    }\n    _initClazzAccessDone = JNI_TRUE;\n    return JNI_TRUE;\n}\n\nstatic jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, void * source_address, jlong capacity) {\n    jobject jbyteBuffer;\n    void * byteBufferPtr;\n\n    if( JNI_FALSE == _initClazzAccessDone ) {\n        fprintf(stderr, \"FatalError: initializeImpl() not called\\n\");\n        (*env)->FatalError(env, \"initializeImpl() not called\");\n        return NULL;\n    }\n    jbyteBuffer  = (*env)->CallStaticObjectMethod(env, clazzBuffers, cstrBuffersNew, capacity);\n    byteBufferPtr = (*env)->GetDirectBufferAddress(env, jbyteBuffer);\n    memcpy(byteBufferPtr, source_address, capacity);\n    return jbyteBuffer;\n}\n\n";
    private static final String staticClassInitCallJavaCode = "\n  static {\n    if( !initializeImpl() ) {\n      throw new RuntimeException(\"Initialization failure\");\n    }\n  }\n\n";

    public JavaEmitter() {
        this.machDescJava = MachineDataInfo.StaticConfig.LP64_UNIX.md;
        this.machDescTargetConfigs = MachineDataInfo.StaticConfig.values();
        this.LOG = Logging.getLogger(JavaEmitter.class.getPackage().getName(), JavaEmitter.class.getSimpleName());
    }

    @Override
    public void readConfigurationFile(String string) throws Exception {
        this.cfg = this.createConfig();
        this.cfg.read(string);
    }

    @Override
    public JavaConfiguration getConfiguration() {
        return this.cfg;
    }

    @Override
    public void beginEmission(GlueEmitterControls glueEmitterControls) throws IOException {
        glueEmitterControls.runSymbolFilter(new ConstFuncRenamer());
        for (String string : this.cfg.forcedStructs()) {
            glueEmitterControls.forceStructEmission(string);
        }
        if (!this.cfg.structsOnly()) {
            try {
                this.openWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to open files for writing", exception);
            }
            this.emitAllFileHeaders();
        }
    }

    @Override
    public void endEmission() {
        if (!this.cfg.structsOnly()) {
            this.emitAllFileFooters();
            try {
                this.closeWriters();
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to close open files", exception);
            }
        }
    }

    @Override
    public void beginDefines() throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    protected static int getJavaRadix(String string, String string2) {
        try {
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            Long.parseLong(string3, n);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Double.parseDouble(string2);
                return 10;
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static Object getJavaValue(String string, String string2) {
        Scanner scanner = new Scanner(string2).useDelimiter(ConstantDefinition.patternCPPOperand);
        Object object = null;
        while (scanner.hasNext()) {
            String string3 = scanner.next().trim();
            if (0 >= string3.length()) continue;
            Object object2 = JavaEmitter.getJavaValue2(string, string3);
            if (object2 instanceof Double) {
                return object2;
            }
            if (object != null) {
                if (object instanceof Integer) {
                    if (object2 instanceof Long || object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Long) {
                    if (object2 instanceof Float || object2 instanceof Double) {
                        object = object2;
                    }
                } else if (object instanceof Float && object2 instanceof Float) {
                    object = object2;
                }
            } else {
                object = object2;
            }
            if (!(object instanceof Double)) continue;
            return object2;
        }
        return object;
    }

    private static Object getJavaValue2(String string, String string2) {
        char c = string2.charAt(string2.length() - 1);
        try {
            long l;
            String string3;
            int n;
            if (string2.startsWith("0x") || string2.startsWith("0X")) {
                n = 16;
                string3 = string2.substring(2);
            } else if (string2.startsWith("0") && string2.length() > 1) {
                n = 8;
                string3 = string2.substring(1);
            } else {
                n = 10;
                string3 = string2;
            }
            if (c == 'u' || c == 'U') {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if ((l = Long.parseLong(string3, n)) > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
                return (int)l;
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            try {
                double d = Double.parseDouble(string2);
                double d2 = Math.abs(d);
                if (d2 < (double)1.4E-45f || d2 > 3.4028234663852886E38 || c == 'd' || c == 'D') {
                    return new Double(d);
                }
                return new Float((float)d);
            }
            catch (NumberFormatException numberFormatException2) {
                throw new RuntimeException("Cannot emit define \"" + string + "\": value \"" + string2 + "\" cannot be assigned to a int, long, float, or double", numberFormatException2);
            }
        }
    }

    protected static String getJavaType(String string, String string2) {
        Object object = JavaEmitter.getJavaValue(string, string2);
        return JavaEmitter.getJavaType(string, object);
    }

    protected static String getJavaType(String string, Object object) {
        if (object instanceof Integer) {
            return "int";
        }
        if (object instanceof Long) {
            return "long";
        }
        if (object instanceof Float) {
            return "float";
        }
        if (object instanceof Double) {
            return "double";
        }
        throw new RuntimeException("Cannot emit define (2) \"" + string + "\": value \"" + object + "\" cannot be assigned to a int, long, float, or double");
    }

    protected static String jniMangle(String string) {
        return string.replaceAll("_", "_1").replace('.', '_');
    }

    protected static String getJNIMethodNamePrefix(String string, String string2) {
        return "Java_" + JavaEmitter.jniMangle(string) + "_" + JavaEmitter.jniMangle(string2);
    }

    @Override
    public void emitDefine(ConstantDefinition constantDefinition, String string) throws Exception {
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            String string2 = constantDefinition.getName();
            String string3 = constantDefinition.getValue();
            if (!this.cfg.shouldIgnoreInInterface(constantDefinition)) {
                String string4 = JavaEmitter.getJavaType(string2, string3);
                if (string != null && string.length() != 0) {
                    this.javaWriter().println("  /** " + string + " */");
                }
                String string5 = "";
                char c = string3.charAt(string3.length() - 1);
                if (c != ')') {
                    if (string4.equals("float") && c != 'f' && c != 'F') {
                        string5 = "f";
                    } else if (c == 'u' || c == 'U') {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                }
                this.javaWriter().println("  public static final " + string4 + " " + string2 + " = " + string3 + string5 + ";");
            }
        }
    }

    @Override
    public void endDefines() throws Exception {
    }

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.canonMap = map;
        this.requiresStaticInitialization = false;
        if ((this.cfg.allStatic() || this.cfg.emitInterface()) && !this.cfg.structsOnly()) {
            this.javaWriter().println();
        }
    }

    @Override
    public Iterator<FunctionSymbol> emitFunctions(List<FunctionSymbol> list) throws Exception {
        if (!this.cfg.structsOnly()) {
            ArrayList<? extends FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>(2 * list.size());
            int n = 0;
            for (FunctionSymbol object : list) {
                if (this.cfg.shouldIgnoreInImpl(object)) continue;
                arrayList.addAll(this.generateMethodBindingEmitters(object));
                this.LOG.log(Level.INFO, object.getASTLocusTag(), "Non-Ignored Impl[{0}]: {1}", n++, object);
            }
            n = 0;
            for (FunctionEmitter functionEmitter : arrayList) {
                try {
                    FunctionSymbol functionSymbol = functionEmitter.getCSymbol();
                    if (functionEmitter.isInterface() && this.cfg.shouldIgnoreInInterface(functionSymbol)) continue;
                    functionEmitter.emit();
                    functionEmitter.getDefaultOutput().println();
                    this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "Non-Ignored Intf[{0}]: {1}", n++, functionSymbol);
                }
                catch (Exception exception) {
                    throw new GlueGenException("Error while emitting binding for \"" + functionEmitter.getCSymbol().getAliasedString() + "\"", functionEmitter.getCSymbol().getASTLocusTag(), exception);
                }
            }
        }
        return list.iterator();
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }

    protected JavaConfiguration getConfig() {
        return this.cfg;
    }

    protected final boolean requiresStaticInitialization(String string) {
        return this.requiresStaticInitialization || this.cfg.forceStaticInitCode(string);
    }

    protected void generatePublicEmitters(MethodBinding methodBinding, List<FunctionEmitter> list, boolean bl) {
        boolean bl2;
        FunctionSymbol functionSymbol = methodBinding.getCSymbol();
        if (!bl && this.cfg.manuallyImplement(functionSymbol)) {
            return;
        }
        MethodAccess methodAccess = !bl && null != methodBinding.getDelegationImplName() ? MethodAccess.PRIVATE : this.cfg.accessControl(methodBinding.getName());
        if (bl && MethodAccess.PUBLIC != methodAccess) {
            return;
        }
        boolean bl3 = this.cfg.isUnimplemented(functionSymbol);
        List<String> list2 = this.cfg.javaPrologueForMethod(methodBinding, false, false);
        List<String> list3 = this.cfg.javaEpilogueForMethod(methodBinding, false, false);
        boolean bl4 = bl2 = bl3 || methodBinding.needsNIOWrappingOrUnwrapping() || methodBinding.signatureUsesJavaPrimitiveArrays() || null != list2 || null != list3;
        if (!this.requiresStaticInitialization) {
            this.requiresStaticInitialization = methodBinding.signatureRequiresStaticInitialization();
            if (this.requiresStaticInitialization) {
                this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "StaticInit Trigger.1 \"{0}\"", (Object)methodBinding);
            }
        }
        boolean bl5 = !bl && bl2;
        boolean bl6 = !bl3 && !bl2 && !bl;
        PrintWriter printWriter = bl || this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
        JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), bl5, this.cfg.tagNativeBinding(), false, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), false, false, bl3, bl, bl6, false, this.cfg);
        switch (methodAccess) {
            case PUBLIC: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
                break;
            }
            case PROTECTED: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PROTECTED);
                break;
            }
            case PRIVATE: {
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                break;
            }
        }
        if (this.cfg.allStatic()) {
            javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
        }
        if (bl6) {
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
        }
        javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
        javaMethodBindingEmitter.setPrologue(list2);
        javaMethodBindingEmitter.setEpilogue(list3);
        list.add(javaMethodBindingEmitter);
    }

    protected void generatePrivateEmitters(MethodBinding methodBinding, List<FunctionEmitter> list) {
        boolean bl;
        FunctionSymbol functionSymbol = methodBinding.getCSymbol();
        if (this.cfg.manuallyImplement(functionSymbol)) {
            return;
        }
        boolean bl2 = bl = this.cfg.javaPrologueForMethod(methodBinding, false, false) != null || this.cfg.javaEpilogueForMethod(methodBinding, false, false) != null;
        if (!this.cfg.isUnimplemented(functionSymbol)) {
            Object object;
            if (!this.requiresStaticInitialization) {
                this.requiresStaticInitialization = methodBinding.signatureRequiresStaticInitialization();
                if (this.requiresStaticInitialization) {
                    this.LOG.log(Level.INFO, functionSymbol.getASTLocusTag(), "StaticInit Trigger.2 \"{0}\"", (Object)methodBinding);
                }
            }
            if (!methodBinding.signatureUsesJavaPrimitiveArrays() && (methodBinding.needsNIOWrappingOrUnwrapping() || bl)) {
                object = this.cfg.allStatic() ? this.javaWriter() : this.javaImplWriter();
                JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding, (PrintWriter)object, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, this.cfg.useNIOOnly(methodBinding.getName()), this.cfg.useNIODirectOnly(methodBinding.getName()), true, false, false, false, true, true, this.cfg);
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
                if (this.cfg.allStatic()) {
                    javaMethodBindingEmitter.addModifier(FunctionEmitter.STATIC);
                }
                javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(this.cfg.returnedArrayLength(methodBinding.getName()));
                list.add(javaMethodBindingEmitter);
            }
            if (!methodBinding.signatureUsesJavaPrimitiveArrays()) {
                object = new CMethodBindingEmitter(methodBinding, this.cWriter(), this.cfg.implPackageName(), this.cfg.implClassName(), true, this.cfg.allStatic(), methodBinding.needsNIOWrappingOrUnwrapping() || bl, !this.cfg.useNIODirectOnly(methodBinding.getName()), this.machDescJava, this.getConfiguration());
                this.prepCEmitter(methodBinding.getName(), methodBinding.getJavaReturnType(), (CMethodBindingEmitter)object);
                list.add((FunctionEmitter)object);
            }
        }
    }

    protected void prepCEmitter(String string, JavaType javaType, CMethodBindingEmitter cMethodBindingEmitter) {
        if (javaType.isNIOBuffer() || javaType.isCompoundTypeWrapper()) {
            String string2 = this.cfg.returnValueCapacity(string);
            if (string2 != null) {
                cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string2));
            }
        } else if (javaType.isArray() || javaType.isArrayOfCompoundTypeWrappers()) {
            if (javaType.isPrimitiveArray()) {
                throw new RuntimeException("Primitive array return types not yet supported");
            }
            String string3 = this.cfg.returnValueLength(string);
            if (string3 != null) {
                cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string3));
            }
        }
        cMethodBindingEmitter.setTemporaryCVariableDeclarations(this.cfg.temporaryCVariableDeclarations(string));
        cMethodBindingEmitter.setTemporaryCVariableAssignments(this.cfg.temporaryCVariableAssignments(string));
    }

    protected List<? extends FunctionEmitter> generateMethodBindingEmitters(FunctionSymbol functionSymbol) throws Exception {
        ArrayList<FunctionEmitter> arrayList = new ArrayList<FunctionEmitter>();
        try {
            if (this.cfg.emitInterface()) {
                this.generateMethodBindingEmittersImpl(arrayList, functionSymbol, true);
            }
            if (this.cfg.emitImpl()) {
                this.generateMethodBindingEmittersImpl(arrayList, functionSymbol, false);
            }
        }
        catch (Exception exception) {
            throw new GlueGenException("Error while generating bindings for \"" + functionSymbol + "\"", functionSymbol.getASTLocusTag(), exception);
        }
        return arrayList;
    }

    private void generateMethodBindingEmittersImpl(ArrayList<FunctionEmitter> arrayList, FunctionSymbol functionSymbol, boolean bl) throws Exception {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, bl, this.machDescJava, null, null);
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        HashSet<MethodBinding> hashSet = new HashSet<MethodBinding>();
        for (MethodBinding methodBinding2 : list) {
            if (!hashSet.add(methodBinding2)) continue;
            if (this.cfg.allStatic() && methodBinding2.hasContainingType()) {
                throw new IllegalArgumentException("Cannot create binding in AllStatic mode because method has containing type: \"" + methodBinding2 + "\"");
            }
            if (bl) {
                this.generatePublicEmitters(methodBinding2, arrayList, true);
                continue;
            }
            this.generatePublicEmitters(methodBinding2, arrayList, false);
            this.generatePrivateEmitters(methodBinding2, arrayList);
        }
    }

    @Override
    public void endFunctions() throws Exception {
        if (!this.cfg.structsOnly()) {
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                this.emitCustomJavaCode(this.javaWriter(), this.cfg.className());
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                this.emitCustomJavaCode(this.javaImplWriter(), this.cfg.implClassName());
            }
            if (this.cfg.allStatic()) {
                this.emitJavaInitCode(this.javaWriter(), this.cfg.className());
            } else if (this.cfg.emitImpl()) {
                this.emitJavaInitCode(this.javaImplWriter(), this.cfg.implClassName());
            }
            if (this.cfg.emitImpl()) {
                this.emitCInitCode(this.cWriter(), this.getImplPackageName(), this.cfg.implClassName());
            }
        }
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType compoundType) throws Exception {
        this.getLayout().layout(compoundType);
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) throws Exception {
        this.canonMap = map;
    }

    @Override
    public void emitStruct(CompoundType compoundType, Type type) throws Exception {
        Object object;
        String string;
        String string2;
        String string3;
        Object object2;
        TypeComparator.SemanticEqualityOp semanticEqualityOp;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        int n;
        String string4;
        String string5;
        Object object10 = compoundType.getName();
        if (null != type && null != type.getName()) {
            string4 = string5 = type.getName();
        } else {
            string5 = null;
            string4 = object10;
        }
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "Struct emission of structCType {0}", (Object)compoundType);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "              structCTypedefPtr {0}", (Object)type);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "   : structCTypeName \"{0}\" -> typedefedName \"{1}\" -> \"{2}\"", object10, string5, string4);
        if (null == string4) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of unnamed struct {0} w/o typedef", (Object)compoundType);
            return;
        }
        Object object11 = new AliasedSymbol.AliasedSymbolImpl(string4);
        ((AliasedSymbol.AliasedSymbolImpl)object11).addAliasedName((String)object10);
        ((AliasedSymbol.AliasedSymbolImpl)object11).addAliasedName(string5);
        if (this.cfg.shouldIgnoreInInterface((AliasedSymbol)object11)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of ignored \"{0}\": {1}", object11, compoundType);
            return;
        }
        if (null != type && this.isOpaque(type)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque typedef {0}", (Object)type);
            return;
        }
        if (this.isOpaque(compoundType)) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque c-struct {0}", (Object)compoundType);
            return;
        }
        if (null != string5) {
            object11 = type;
            n = 1;
        } else {
            object11 = new PointerType(SizeThunk.POINTER, compoundType, 0);
            ((Type)object11).setTypedefName(string5);
            n = 2;
        }
        object10 = this.canonicalize((Type)object11);
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "containingCType[{0}]: {1} -canon-> {2}", n, object11, object10);
        object11 = this.typeToJavaType((Type)object10, null);
        if (((JavaType)object11).isOpaqued()) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "skipping emission of opaque {0}, {1}", object11, compoundType);
            return;
        }
        if (!((JavaType)object11).isCompoundTypeWrapper()) {
            this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), "skipping emission of non-compound {0}, {1}", object11, compoundType);
            return;
        }
        String string6 = ((JavaType)object11).getName();
        this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "perform emission of \"{0}\" -> \"{1}\": {2}", string4, string6, compoundType);
        if (0 == compoundType.getNumFields()) {
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "emission of \"{0}\" with zero fields {1}", string6, compoundType);
        }
        this.requiresStaticInitialization = false;
        boolean bl = false;
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            object9 = compoundType.getField(i);
            object8 = ((Field)object9).getType();
            object7 = JavaConfiguration.canonicalStructFieldSymbol(string6, ((Field)object9).getName());
            if (this.cfg.shouldIgnoreInInterface((String)object7)) continue;
            object6 = this.cfg.getJavaSymbolRename((String)object7);
            object5 = object6 == null ? ((Field)object9).getName() : object6;
            object4 = JavaConfiguration.canonicalStructFieldSymbol(string6, (String)object5);
            if (!((Type)object8).isFunctionPointer() && !((Type)object8).isPointer() && !this.requiresGetCStringLength((Type)object8, (String)object4)) continue;
            bl = true;
            break;
        }
        String string7 = this.cfg.packageForStruct(string4);
        try {
            object9 = this.openFile(this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(string7) + File.separator + string6 + ".java", string6);
            if (null == object9) {
                return;
            }
            CodeGenUtils.emitAutogeneratedWarning((PrintWriter)object9, this);
            if (bl) {
                object7 = this.cfg.nativeOutputDir();
                if (this.cfg.nativeOutputUsesJavaHierarchy()) {
                    object7 = (String)object7 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
                }
                object8 = this.openFile((String)object7 + File.separator + string6 + "_JNI.c", string6);
                CodeGenUtils.emitAutogeneratedWarning((PrintWriter)object8, this);
                this.emitCHeader((PrintWriter)object8, string7, string6);
            } else {
                object8 = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to open files for emission of struct class", exception);
        }
        ((PrintWriter)object9).println();
        ((PrintWriter)object9).println("package " + string7 + ";");
        ((PrintWriter)object9).println();
        ((PrintWriter)object9).println("import java.nio.*;");
        ((PrintWriter)object9).println();
        ((PrintWriter)object9).println("import " + this.cfg.gluegenRuntimePackage() + ".*;");
        ((PrintWriter)object9).println("import " + DynamicLookupHelper.class.getPackage().getName() + ".*;");
        ((PrintWriter)object9).println("import " + Buffers.class.getPackage().getName() + ".*;");
        ((PrintWriter)object9).println("import " + MachineDataInfoRuntime.class.getName() + ";");
        ((PrintWriter)object9).println();
        object7 = this.cfg.imports();
        object6 = object7.iterator();
        while (object6.hasNext()) {
            object5 = (String)object6.next();
            ((PrintWriter)object9).print("import ");
            ((PrintWriter)object9).print((String)object5);
            ((PrintWriter)object9).println(";");
        }
        ((PrintWriter)object9).println();
        object6 = this.cfg.javadocForClass(string6);
        object5 = object6.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            ((PrintWriter)object9).println((String)object4);
        }
        ((PrintWriter)object9).print("public class " + string6 + " ");
        boolean bl2 = true;
        object4 = this.cfg.implementedInterfaces(string6);
        Object object12 = object4.iterator();
        while (object12.hasNext()) {
            object3 = (String)object12.next();
            if (bl2) {
                ((PrintWriter)object9).print("implements ");
            }
            bl2 = false;
            ((PrintWriter)object9).print((String)object3);
            ((PrintWriter)object9).print(" ");
        }
        ((PrintWriter)object9).println("{");
        ((PrintWriter)object9).println();
        ((PrintWriter)object9).println("  StructAccessor accessor;");
        ((PrintWriter)object9).println();
        object12 = this.cfg.returnStructMachineDataInfoIndex(string6);
        object3 = null != object12 ? object12 : "private static final int mdIdx = MachineDataInfoRuntime.getStatic().ordinal();";
        ((PrintWriter)object9).println("  " + (String)object3);
        ((PrintWriter)object9).println("  private final MachineDataInfo md;");
        ((PrintWriter)object9).println();
        this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string6, compoundType, null, null);
        if (GlueGen.debug()) {
            System.err.printf("SE.__: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.__: contCTypeName %s%n", ((Type)object10).getDebugString());
            System.err.printf("SE.__: contJTypeName %s%n", ((JavaType)object11).getDebugString());
        }
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            Field field = compoundType.getField(i);
            semanticEqualityOp = field.getType();
            object2 = JavaConfiguration.canonicalStructFieldSymbol(string6, field.getName());
            if (!this.cfg.shouldIgnoreInInterface((String)object2)) {
                string3 = this.cfg.getJavaSymbolRename((String)object2);
                string2 = null == string3 ? field.getName() : string3;
                string = JavaConfiguration.canonicalStructFieldSymbol(string6, string2);
                if (((Type)semanticEqualityOp).isFunctionPointer()) {
                    if (!GlueGen.debug()) continue;
                    System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "SKIP FuncPtr");
                    continue;
                }
                if (((Type)semanticEqualityOp).isCompound()) {
                    if (((Type)semanticEqualityOp).getName() == null) {
                        throw new GlueGenException("Anonymous structs as fields not supported yet, field \"" + string + "\", " + ((Type)semanticEqualityOp).getDebugString(), ((Type)semanticEqualityOp).getASTLocusTag());
                    }
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "compound");
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string2, (Type)semanticEqualityOp, field, null);
                    continue;
                }
                if (((Type)semanticEqualityOp).isArray()) {
                    object = field.getType().asArray().getBaseElementType();
                    if (GlueGen.debug()) {
                        System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "array");
                        System.err.printf("SE.os.%02d: baseType %s%n", i + 1, ((Type)object).getDebugString());
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string2, (Type)semanticEqualityOp, field, null);
                    continue;
                }
                try {
                    object = this.typeToJavaType((Type)semanticEqualityOp, this.machDescJava);
                }
                catch (Exception exception) {
                    throw new GlueGenException("Error occurred while creating accessor for field \"" + string + "\", " + ((Type)semanticEqualityOp).getDebugString(), ((Type)semanticEqualityOp).getASTLocusTag(), exception);
                }
                if (GlueGen.debug()) {
                    System.err.printf("SE.os.%02d: %s / %s, %s (%s)%n", i + 1, field, string, ((Type)semanticEqualityOp).getDebugString(), "MISC");
                    System.err.printf("SE.os.%02d: javaType %s%n", i + 1, ((JavaType)object).getDebugString());
                }
                if (((JavaType)object).isPrimitive()) {
                    this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string2, null, field, null);
                    this.generateOffsetAndSizeArrays((PrintWriter)object9, "//", string2, (Type)semanticEqualityOp, null, null);
                    continue;
                }
                if (((JavaType)object).isCPrimitivePointerType()) {
                    if (this.requiresGetCStringLength((Type)semanticEqualityOp, string)) {
                        this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string2, null, field, null);
                        this.generateOffsetAndSizeArrays((PrintWriter)object9, "//", string2, (Type)semanticEqualityOp, null, "// " + ((JavaType)object).getDebugString());
                        continue;
                    }
                    this.generateOffsetAndSizeArrays((PrintWriter)object9, "//", string2, (Type)semanticEqualityOp, field, "// " + ((JavaType)object).getDebugString());
                    continue;
                }
                this.generateOffsetAndSizeArrays((PrintWriter)object9, "  ", string2, null, field, null);
                this.generateOffsetAndSizeArrays((PrintWriter)object9, "//", string2, (Type)semanticEqualityOp, null, "// " + ((JavaType)object).getDebugString());
                continue;
            }
            if (!GlueGen.debug()) continue;
            System.err.printf("SE.os.%02d: %s, %s (IGNORED)%n", i + 1, field, ((Type)semanticEqualityOp).getDebugString());
        }
        ((PrintWriter)object9).println();
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, "size"))) {
            ((PrintWriter)object9).println("  public static int size() {");
            ((PrintWriter)object9).println("    return " + string6 + "_size[mdIdx];");
            ((PrintWriter)object9).println("  }");
            ((PrintWriter)object9).println();
        }
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, "create"))) {
            ((PrintWriter)object9).println("  public static " + string6 + " create() {");
            ((PrintWriter)object9).println("    return create(Buffers.newDirectByteBuffer(size()));");
            ((PrintWriter)object9).println("  }");
            ((PrintWriter)object9).println();
            ((PrintWriter)object9).println("  public static " + string6 + " create(java.nio.ByteBuffer buf) {");
            ((PrintWriter)object9).println("      return new " + string6 + "(buf);");
            ((PrintWriter)object9).println("  }");
            ((PrintWriter)object9).println();
        }
        if (!this.cfg.manuallyImplement(JavaConfiguration.canonicalStructFieldSymbol(string6, string6))) {
            ((PrintWriter)object9).println("  " + string6 + "(java.nio.ByteBuffer buf) {");
            ((PrintWriter)object9).println("    md = MachineDataInfo.StaticConfig.values()[mdIdx].md;");
            ((PrintWriter)object9).println("    accessor = new StructAccessor(buf);");
            ((PrintWriter)object9).println("  }");
            ((PrintWriter)object9).println();
        }
        ((PrintWriter)object9).println("  public java.nio.ByteBuffer getBuffer() {");
        ((PrintWriter)object9).println("    return accessor.getBuffer();");
        ((PrintWriter)object9).println("  }");
        HashSet<MethodBinding> hashSet = new HashSet<MethodBinding>();
        for (int i = 0; i < compoundType.getNumFields(); ++i) {
            Object object13;
            boolean bl3;
            semanticEqualityOp = compoundType.getField(i);
            object2 = ((Field)semanticEqualityOp).getType();
            string3 = JavaConfiguration.canonicalStructFieldSymbol(string6, ((Field)semanticEqualityOp).getName());
            if (this.cfg.shouldIgnoreInInterface(string3)) continue;
            string2 = this.cfg.getJavaSymbolRename(string3);
            string = string2 == null ? ((Field)semanticEqualityOp).getName() : string2;
            object = JavaConfiguration.canonicalStructFieldSymbol(string6, string);
            TypeInfo typeInfo = this.cfg.typeInfo((Type)object2);
            boolean bl4 = null != typeInfo;
            TypeInfo typeInfo2 = this.cfg.canonicalNameOpaque((String)object);
            boolean bl5 = bl3 = null != typeInfo2;
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: %s / %s (opaque %b), %s (opaque %b)%n", i + 1, i + 1, semanticEqualityOp, object, bl3, ((Type)object2).getDebugString(), bl4);
            }
            if (((Type)object2).isFunctionPointer() && !bl3) {
                object13 = new FunctionSymbol(((Field)semanticEqualityOp).getName(), ((Type)object2).asPointer().getTargetType().asFunction());
                ((AliasedSymbol.AliasedSymbolImpl)object13).rename(string2);
                this.generateFunctionPointerCode(hashSet, (PrintWriter)object9, (PrintWriter)object8, string4, string7, (Type)object10, (JavaType)object11, i, (FunctionSymbol)object13, (String)object);
                continue;
            }
            if (((Type)object2).isCompound() && !bl3) {
                if (((Type)object2).getName() == null) {
                    throw new GlueGenException("Anonymous structs as fields not supported yet (field \"" + semanticEqualityOp + "\" in type \"" + string4 + "\")", ((Type)object2).getASTLocusTag());
                }
                ((PrintWriter)object9).println();
                this.generateGetterSignature((PrintWriter)object9, (Type)object2, false, false, ((Type)object2).getName(), string, this.capitalizeString(string), null, null);
                ((PrintWriter)object9).println(" {");
                ((PrintWriter)object9).println("    return " + ((Type)object2).getName() + ".create( accessor.slice( " + string + "_offset[mdIdx], " + string + "_size[mdIdx] ) );");
                ((PrintWriter)object9).println(" }");
                continue;
            }
            if ((((Type)object2).isArray() || ((Type)object2).isPointer()) && !bl3) {
                this.generateArrayGetterSetterCode(hashSet, (PrintWriter)object9, (PrintWriter)object8, compoundType, string4, string7, (Type)object10, (JavaType)object11, i, (Field)semanticEqualityOp, string, (String)object);
                continue;
            }
            try {
                object13 = this.typeToJavaType((Type)object2, this.machDescJava);
            }
            catch (Exception exception) {
                throw new GlueGenException("Error occurred while creating accessor for field \"" + ((Field)semanticEqualityOp).getName() + "\", " + ((Type)object2).getDebugString(), ((Type)object2).getASTLocusTag(), exception);
            }
            if (bl4 || bl3 || ((JavaType)object13).isPrimitive()) {
                boolean bl6 = ((Type)object2).getSize().hasFixedNativeSize();
                String string8 = bl4 ? typeInfo.javaType().getName() : (bl3 ? typeInfo2.javaType().getName() : ((JavaType)object13).getName());
                String string9 = this.capitalizeString(string8);
                String string10 = this.capitalizeString(string);
                String string11 = ((Type)object2).isPointer() ? "pointer" : string8;
                this.LOG.log(Level.FINE, compoundType.getASTLocusTag(), "Java.StructEmitter.Primitive: " + ((Field)semanticEqualityOp).getName() + ", " + object2 + ", " + string8 + ", " + ", fixedSize " + bl6 + ", opaque[t " + bl4 + ", f " + bl3 + "], sizeDenominator " + string11);
                if (!((Type)object2).isConst()) {
                    ((PrintWriter)object9).println();
                    this.generateSetterSignature((PrintWriter)object9, (Type)object2, false, string6, string, string10, null, string8, null, null);
                    ((PrintWriter)object9).println(" {");
                    if (bl6) {
                        ((PrintWriter)object9).println("    accessor.set" + string9 + "At(" + string + "_offset[mdIdx], val);");
                    } else {
                        ((PrintWriter)object9).println("    accessor.set" + string9 + "At(" + string + "_offset[mdIdx], val, md." + string11 + "SizeInBytes());");
                    }
                    ((PrintWriter)object9).println("    return this;");
                    ((PrintWriter)object9).println("  }");
                }
                ((PrintWriter)object9).println();
                this.generateGetterSignature((PrintWriter)object9, (Type)object2, false, false, string8, string, string10, null, null);
                ((PrintWriter)object9).println(" {");
                ((PrintWriter)object9).print("    return ");
                if (bl6) {
                    ((PrintWriter)object9).println("accessor.get" + string9 + "At(" + string + "_offset[mdIdx]);");
                } else {
                    ((PrintWriter)object9).println("accessor.get" + string9 + "At(" + string + "_offset[mdIdx], md." + string11 + "SizeInBytes());");
                }
                ((PrintWriter)object9).println("  }");
                continue;
            }
            ((PrintWriter)object9).println();
            ((PrintWriter)object9).println("  /** UNKNOWN: " + (String)object + ": " + ((Type)object2).getDebugString() + ", " + ((JavaType)object13).getDebugString() + " */");
        }
        this.emitCustomJavaCode((PrintWriter)object9, string6);
        if (bl) {
            ((PrintWriter)object9).println();
            this.emitJavaInitCode((PrintWriter)object9, string6);
            ((PrintWriter)object9).println();
        }
        ((PrintWriter)object9).println("}");
        ((PrintWriter)object9).flush();
        ((PrintWriter)object9).close();
        if (bl) {
            this.emitCInitCode((PrintWriter)object8, string7, string6);
            ((PrintWriter)object8).flush();
            ((PrintWriter)object8).close();
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.XX: structCType %s%n", compoundType.getDebugString());
            System.err.printf("SE.XX: contCTypeName %s%n", ((Type)object10).getDebugString());
            System.err.printf("SE.XX: contJTypeName %s%n", ((JavaType)object11).getDebugString());
        }
    }

    @Override
    public void endStructs() throws Exception {
    }

    public static int addStrings2Buffer(StringBuilder stringBuilder, String string, String string2, Collection<String> collection) {
        int n = 0;
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Iterator<String> iterator = collection.iterator();
        if (null != string2) {
            stringBuilder.append(string2);
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (iterator.hasNext()) {
                stringBuilder.append(string);
            }
            ++n;
        }
        return n;
    }

    private void generateGetterSignature(PrintWriter printWriter, Type type, boolean bl, boolean bl2, String string, String string2, String string3, String string4, String string5) {
        printWriter.print("  /** Getter for native field <code>" + string2 + "</code>: " + type.getDebugString());
        if (null != string5) {
            printWriter.print(", with array length of <code>" + string5 + "</code>");
        }
        printWriter.println(" */");
        printWriter.print("  public " + (bl ? "static " : "") + (bl2 ? "abstract " : "") + string + " get" + string3 + "(");
        if (null != string4) {
            printWriter.print(string4);
        }
        printWriter.print(")");
    }

    private void generateSetterSignature(PrintWriter printWriter, Type type, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        printWriter.print("  /** Setter for native field <code>" + string2 + "</code>: " + type.getDebugString());
        if (null != string7) {
            printWriter.print(", with array length of <code>" + string7 + "</code>");
        }
        printWriter.println(" */");
        printWriter.print("  public " + (bl ? "abstract " : "") + string + " set" + string3 + "(");
        if (null != string4) {
            printWriter.print(string4 + ", ");
        }
        printWriter.print(string5 + " val");
        if (null != string6) {
            printWriter.print(", " + string6);
        }
        printWriter.print(")");
    }

    private void generateOffsetAndSizeArrays(PrintWriter printWriter, String string, String string2, Type type, Field field, String string3) {
        int n;
        if (null != field) {
            printWriter.print(string + "private static final int[] " + string2 + "_offset = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(field.getOffset(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.println(" };");
        }
        if (null != type) {
            printWriter.print(string + "private static final int[] " + string2 + "_size = new int[] { ");
            for (n = 0; n < this.machDescTargetConfigs.length; ++n) {
                if (0 < n) {
                    printWriter.print(", ");
                }
                printWriter.print(type.getSize(this.machDescTargetConfigs[n].md) + " /* " + this.machDescTargetConfigs[n].name() + " */");
            }
            printWriter.print("  };");
            if (null != string3) {
                printWriter.println(string3);
            } else {
                printWriter.println();
            }
        }
    }

    private void generateFunctionPointerCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, String string, String string2, Type type, JavaType javaType, int n, FunctionSymbol functionSymbol, String string3) {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, true, this.machDescJava, javaType, type);
        methodBinding.findThisPointer();
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        for (MethodBinding methodBinding2 : list) {
            if (!set.add(methodBinding2)) continue;
            printWriter.println();
            JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), true, this.cfg.tagNativeBinding(), false, true, true, false, false, false, false, false, false, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PUBLIC);
            javaMethodBindingEmitter.emit();
            javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, true, false, false, false, false, true, this.cfg);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.emit();
            CMethodBindingEmitter cMethodBindingEmitter = new CMethodBindingEmitter(methodBinding2, printWriter2, string2, javaType.getName(), true, false, true, false, this.machDescJava, this.getConfiguration());
            cMethodBindingEmitter.setIsCStructFunctionPointer(true);
            this.prepCEmitter(string3, methodBinding2.getJavaReturnType(), cMethodBindingEmitter);
            cMethodBindingEmitter.emit();
        }
    }

    private void generateArrayPointerCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, String string, String string2, Type type, JavaType javaType, int n, FunctionSymbol functionSymbol, String string3, String string4, String string5) {
        MethodBinding methodBinding = this.bindFunction(functionSymbol, true, this.machDescJava, javaType, type);
        methodBinding.findThisPointer();
        List<MethodBinding> list = this.expandMethodBinding(methodBinding);
        for (MethodBinding methodBinding2 : list) {
            String string6;
            if (!set.add(methodBinding2)) continue;
            JavaMethodBindingEmitter javaMethodBindingEmitter = new JavaMethodBindingEmitter(methodBinding2, printWriter, this.cfg.runtimeExceptionType(), this.cfg.unsupportedExceptionType(), false, this.cfg.tagNativeBinding(), true, true, true, false, false, false, true, true, true, this.cfg);
            if (null != string4) {
                javaMethodBindingEmitter.setReturnedArrayLengthExpression(string4, true);
            }
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.PRIVATE);
            javaMethodBindingEmitter.addModifier(JavaMethodBindingEmitter.NATIVE);
            javaMethodBindingEmitter.emit();
            CMethodBindingEmitter cMethodBindingEmitter = new CMethodBindingEmitter(methodBinding2, printWriter2, string2, javaType.getName(), true, false, true, false, this.machDescJava, this.getConfiguration());
            cMethodBindingEmitter.setIsCStructFunctionPointer(false);
            if (null != string5) {
                JavaType javaType2 = methodBinding2.getJavaReturnType();
                if (javaType2.isNIOBuffer() || javaType2.isCompoundTypeWrapper()) {
                    Type type2 = functionSymbol.getReturnType();
                    Type type3 = type2.getBaseElementType();
                    string6 = string5 + " * sizeof(" + type3.getName() + ")";
                    cMethodBindingEmitter.setReturnValueCapacityExpression(new MessageFormat(string6));
                } else if (javaType2.isArray() || javaType2.isArrayOfCompoundTypeWrappers()) {
                    string6 = string5;
                    cMethodBindingEmitter.setReturnValueLengthExpression(new MessageFormat(string6));
                } else {
                    string6 = null;
                }
            } else {
                string6 = null;
            }
            this.prepCEmitter(string3, methodBinding2.getJavaReturnType(), cMethodBindingEmitter);
            cMethodBindingEmitter.emit();
        }
    }

    private String getArrayArrayLengthExpr(ArrayType arrayType, String string, boolean[] blArray, int[][] nArray) {
        int[] nArray2 = new int[arrayType.arrayDimension()];
        nArray[0] = nArray2;
        StringBuilder stringBuilder = new StringBuilder();
        blArray[0] = true;
        ArrayType arrayType2 = arrayType;
        for (int i = 0; i < nArray2.length; ++i) {
            if (null != arrayType2 && arrayType2.hasLength()) {
                nArray2[i] = arrayType2.getLength();
                if (0 < i) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(nArray2[i]);
            } else {
                nArray2[i] = -1;
                blArray[0] = false;
            }
            if (null == arrayType2) continue;
            arrayType2 = arrayType2.getElementType().asArray();
        }
        String string2 = this.cfg.returnedArrayLength(string);
        if (null != string2) {
            if (blArray[0]) {
                this.LOG.log(Level.WARNING, arrayType.getASTLocusTag(), "struct array field '" + string + "' of '" + arrayType + "' length '" + Arrays.toString(nArray2) + "' overwritten by cfg-expression: " + string2);
            }
            return string2;
        }
        if (blArray[0]) {
            return stringBuilder.toString();
        }
        this.LOG.log(Level.WARNING, arrayType.getASTLocusTag(), "struct array field '" + string + "' length '" + Arrays.toString(nArray2) + "' without fixed- nor configured-size: {0}", (Object)arrayType);
        return null;
    }

    private String getPointerArrayLengthExpr(PointerType pointerType, String string) {
        String string2 = this.cfg.returnedArrayLength(string);
        if (null != string2) {
            return string2;
        }
        return null;
    }

    private boolean requiresGetCStringLength(Type type, String string) {
        if (!this.cfg.returnsString(string)) {
            return false;
        }
        PointerType pointerType = type.asPointer();
        if (null != pointerType) {
            return null == this.getPointerArrayLengthExpr(pointerType, string);
        }
        return false;
    }

    private void generateArrayGetterSetterCode(Set<MethodBinding> set, PrintWriter printWriter, PrintWriter printWriter2, CompoundType compoundType, String string, String string2, Type type, JavaType javaType, int n, Field field, String string3, String string4) throws Exception {
        boolean bl;
        Object object;
        String string5;
        boolean bl2;
        String string6;
        JavaType javaType2;
        boolean bl3;
        boolean bl4;
        Object object2;
        Object object3;
        boolean bl5;
        JavaType javaType3;
        Type type2 = field.getType();
        try {
            javaType3 = this.typeToJavaType(type2, this.machDescJava);
        }
        catch (Exception exception) {
            throw new GlueGenException("Error occurred while creating array/pointer accessor for field \"" + string4 + "\", " + type2.getDebugString(), type2.getASTLocusTag(), exception);
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: javaType  %s%n", n + 1, javaType3.getDebugString());
        }
        String string7 = javaType.getName();
        boolean bl6 = this.isOpaque(type2);
        boolean bl7 = this.cfg.returnsString(string4);
        boolean[] blArray = new boolean[]{false};
        ASTLocusTag.ASTLocusTagProvider aSTLocusTagProvider = type2.asArray();
        String string8 = null;
        boolean bl8 = false;
        if (bl6 || javaType3.isPrimitive()) {
            bl5 = true;
            string8 = nativeArrayLengthONE;
            bl8 = true;
            object3 = new int[]{1};
            object2 = null;
            bl4 = false;
            bl3 = type2.isConst();
            javaType2 = null;
            string6 = this.compatiblePrimitiveJavaTypeName(type2, javaType3, this.machDescJava);
            bl2 = false;
            string5 = type2.isPointer() ? "pointer" : string6;
        } else {
            if (null != aSTLocusTagProvider) {
                object = new int[1][];
                string8 = this.getArrayArrayLengthExpr((ArrayType)aSTLocusTagProvider, string4, blArray, (int[][])object);
                bl8 = true;
                object3 = object[0];
                object2 = ((ArrayType)aSTLocusTagProvider).getBaseElementType();
                bl4 = false;
            } else {
                object = type2.asPointer();
                string8 = this.getPointerArrayLengthExpr((PointerType)object, string4);
                bl8 = false;
                object3 = null;
                object2 = ((PointerType)object).getBaseElementType();
                bl4 = true;
                if (1 != ((PointerType)object).pointerDepth()) {
                    printWriter.println();
                    String string9 = "SKIP ptr-ptr (depth " + ((PointerType)object).pointerDepth() + "): " + string4 + ": " + type2;
                    printWriter.println("  // " + string9);
                    this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), string9);
                    return;
                }
            }
            if (GlueGen.debug()) {
                System.err.printf("SE.ac.%02d: baseCType %s%n", n + 1, ((Type)object2).getDebugString());
            }
            bl5 = ((Type)object2).isPrimitive();
            bl3 = ((Type)object2).isConst();
            try {
                javaType2 = this.typeToJavaType((Type)object2, this.machDescJava);
            }
            catch (Exception exception) {
                throw new GlueGenException("Error occurred while creating array/pointer accessor for field \"" + string4 + "\", baseType " + ((Type)object2).getDebugString() + ", topType " + type2.getDebugString(), type2.getASTLocusTag(), exception);
            }
            string6 = javaType2.getName();
            bl2 = ((Type)object2).isPrimitive() ? ((Type)object2).getSize().hasFixedNativeSize() : true;
            String string10 = string5 = ((Type)object2).isPointer() ? "pointer" : string6;
            if (!bl2) {
                printWriter.println();
                object = "SKIP primitive w/ platform dependent sized type in struct: " + string4 + ": " + type2.getDebugString();
                printWriter.println("  // " + (String)object);
                this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), (String)object);
                return;
            }
        }
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemType %s%n", n + 1, null != javaType2 ? javaType2.getDebugString() : null);
        }
        String string11 = this.capitalizeString(string3);
        String string12 = this.capitalizeString(string6);
        String string13 = string6.toUpperCase();
        boolean bl9 = "Byte".equals(string12);
        if (null == string8 && bl7 && bl4) {
            bl = true;
            string8 = "getCStringLengthImpl(pString)+1";
            bl8 = false;
            this.requiresStaticInitialization = true;
            this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), "StaticInit Trigger.3 \"{0}\"", (Object)string4);
        } else {
            bl = false;
        }
        String string14 = string8;
        boolean bl10 = bl8;
        if (null == string14) {
            printWriter.println();
            object = "SKIP unsized array in struct: " + string4 + ": " + type2.getDebugString();
            printWriter.println("  // " + (String)object);
            this.LOG.log(Level.WARNING, compoundType.getASTLocusTag(), (String)object);
            return;
        }
        boolean bl11 = false;
        try {
            bl11 = 1 == Integer.parseInt(string8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl12 = bl11;
        if (GlueGen.debug()) {
            System.err.printf("SE.ac.%02d: baseJElemTypeName %s, array-lengths %s%n", n + 1, string6, Arrays.toString(object3));
            System.err.printf("SE.ac.%02d: arrayLengthExpr: %s (const %b), hasSingleElement %b, isByteBuffer %b, isString %b, isPointer %b, isPrimitive %b, isOpaque %b, baseCElemNativeSizeFixed %b, baseCElemSizeDenominator %s, isConst %b, useGetCStringLength %b%n", n + 1, string14, bl10, bl12, bl9, bl7, bl4, bl5, bl6, bl2, string5, bl3, bl);
        }
        if (!bl12 && blArray[0]) {
            printWriter.println();
            this.generateGetterSignature(printWriter, type2, bl10, false, "final int", string3, string11 + "ArrayLength", null, string14);
            printWriter.println(" {");
            printWriter.println("    return " + string14 + ";");
            printWriter.println("  }");
        }
        if (!bl3) {
            printWriter.println();
            if (bl5) {
                if (bl4) {
                    object2 = "SKIP setter for primitive-pointer type in struct: " + string4 + ": " + type2.getDebugString();
                    printWriter.println("  // " + (String)object2);
                    this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), (String)object2);
                } else if (bl12) {
                    this.generateSetterSignature(printWriter, type2, false, string7, string3, string11, null, string6, null, string14);
                    printWriter.println(" {");
                    if (bl2) {
                        printWriter.println("    accessor.set" + string12 + "At(" + string3 + "_offset[mdIdx], val);");
                    } else {
                        printWriter.println("    accessor.set" + string12 + "At(" + string3 + "_offset[mdIdx], val, md." + string5 + "SizeInBytes());");
                    }
                    printWriter.println("    return this;");
                    printWriter.println("  }");
                } else {
                    this.generateSetterSignature(printWriter, type2, false, string7, string3, string11, "final int offset", string6 + "[]", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    if( offset + val.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + val.length \"+val.length+\" > array-length \"+arrayLength); };");
                    printWriter.println("    final int elemSize = Buffers.SIZEOF_" + string13 + ";");
                    printWriter.println("    final ByteBuffer destB = getBuffer();");
                    printWriter.println("    final int bTotal = arrayLength * elemSize;");
                    printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                    printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                    printWriter.println("    final int bLimes = bOffset + bTotal;");
                    printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                    printWriter.println("    bOffset += elemSize * offset;");
                    printWriter.println("    accessor.set" + string12 + "sAt(bOffset, val);");
                    printWriter.println("    return this;");
                    printWriter.println("  }");
                }
            } else if (bl4) {
                object2 = "SKIP setter for complex-pointer type in struct: " + string4 + ": " + type2.getDebugString();
                printWriter.println("  // " + (String)object2);
                this.LOG.log(Level.INFO, compoundType.getASTLocusTag(), (String)object2);
            } else if (bl12) {
                this.generateSetterSignature(printWriter, type2, false, string7, string3, string11, null, string6, null, string14);
                printWriter.println(" {");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    if( elemSize > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"elemSize \"+elemSize+\" > size \"+" + string3 + "_size[mdIdx]); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + elemSize;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize); };");
                printWriter.println("    final ByteBuffer sourceB = val.getBuffer();");
                printWriter.println("    for(int f=0; f<elemSize; f++) {");
                printWriter.println("      if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[0][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize); };");
                printWriter.println("      destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
            } else {
                this.generateSetterSignature(printWriter, type2, false, string7, string3, string11, "final int offset", string6 + "[]", null, string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    if( offset + val.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + val.length \"+val.length+\" > array-length \"+arrayLength); };");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    final int bTotal = arrayLength * elemSize;");
                printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + bTotal;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    bOffset += elemSize * offset;");
                printWriter.println("    for(int index=0; index<val.length; index++) {");
                printWriter.println("      final ByteBuffer sourceB = val[index].getBuffer();");
                printWriter.println("      for(int f=0; f<elemSize; f++) {");
                printWriter.println("        if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[\"+(offset+index)+\"][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("        destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("      }");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
                printWriter.println();
                this.generateSetterSignature(printWriter, type2, false, string7, string3, string11, "final int index", string6, null, string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    final int elemSize = " + string6 + ".size();");
                printWriter.println("    final ByteBuffer destB = getBuffer();");
                printWriter.println("    final int bTotal = arrayLength * elemSize;");
                printWriter.println("    if( bTotal > " + string3 + "_size[mdIdx] ) { throw new IndexOutOfBoundsException(\"bTotal \"+bTotal+\" > size \"+" + string3 + "_size[mdIdx]+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx];");
                printWriter.println("    final int bLimes = bOffset + bTotal;");
                printWriter.println("    if( bLimes > destB.limit() ) { throw new IndexOutOfBoundsException(\"bLimes \"+bLimes+\" > buffer.limit \"+destB.limit()+\", elemOff \"+bOffset+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("    bOffset += elemSize * index;");
                printWriter.println("    final ByteBuffer sourceB = val.getBuffer();");
                printWriter.println("    for(int f=0; f<elemSize; f++) {");
                printWriter.println("      if( bOffset >= bLimes ) { throw new IndexOutOfBoundsException(\"elem-byte[\"+index+\"][\"+f+\"]: bOffset \"+bOffset+\" >= bLimes \"+bLimes+\", elemSize \"+elemSize+\" * \"+arrayLength); };");
                printWriter.println("      destB.put(bOffset++, sourceB.get(f));");
                printWriter.println("    }");
                printWriter.println("    return this;");
                printWriter.println("  }");
            }
        }
        printWriter.println();
        if (bl5) {
            if (bl4) {
                object2 = new FunctionType(dummyFuncTypeName, SizeThunk.POINTER, type2, 0);
                ((FunctionType)object2).addArgument(type.newCVVariant(type.getCVAttributes() | 1), CMethodBindingEmitter.cThisArgumentName());
                ((FunctionType)object2).addArgument(int32Type, nativeArrayLengthArg);
                aSTLocusTagProvider = new FunctionSymbol("get" + string11, (FunctionType)object2);
                printWriter2.println();
                printWriter2.print("static " + ((FunctionSymbol)aSTLocusTagProvider).toString(false));
                printWriter2.println("{");
                printWriter2.println("  return " + CMethodBindingEmitter.cThisArgumentName() + "->" + field.getName() + ";");
                printWriter2.println("}");
                printWriter2.println();
                this.generateArrayPointerCode(set, printWriter, printWriter2, string, string2, type, javaType, n, (FunctionSymbol)aSTLocusTagProvider, string4, string14, nativeArrayLengthArg);
                printWriter.println();
                this.generateGetterSignature(printWriter, type2, false, false, string12 + "Buffer", string3, string11, null, string14);
                printWriter.println(" {");
                if (bl) {
                    printWriter.println("    final int arrayLength = get" + string11 + "ArrayLength();");
                } else {
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                }
                printWriter.println("    final ByteBuffer _res = get" + string11 + "0(getBuffer(), arrayLength);");
                printWriter.println("    if (_res == null) return null;");
                printWriter.print("    return Buffers.nativeOrder(_res)");
                if (!bl9) {
                    printWriter.print(".as" + string12 + "Buffer()");
                }
                printWriter.println(";");
                printWriter.println("  }");
                if (bl7 && bl9) {
                    printWriter.println();
                    this.generateGetterSignature(printWriter, type2, false, false, "String", string3, string11 + "AsString", null, string14);
                    printWriter.println(" {");
                    if (bl) {
                        printWriter.println("    final int arrayLength = get" + string11 + "ArrayLength();");
                    } else {
                        printWriter.println("    final int arrayLength = " + string14 + ";");
                    }
                    printWriter.println("    final ByteBuffer bb = get" + string11 + "0(getBuffer(), arrayLength);");
                    printWriter.println("    if (bb == null) return null;");
                    printWriter.println("    final byte[] ba = new byte[arrayLength];");
                    printWriter.println("    int i = -1;");
                    printWriter.println("    while( ++i < arrayLength ) {");
                    printWriter.println("      ba[i] = bb.get(i);");
                    printWriter.println("      if( (byte)0 == ba[i] ) break;");
                    printWriter.println("    }");
                    printWriter.println("    return new String(ba, 0, i);");
                    printWriter.println("  }");
                }
                if (bl) {
                    printWriter.println();
                    this.generateGetterSignature(printWriter, type2, false, false, "final int", string3, string11 + "ArrayLength", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final long pString = PointerBuffer.wrap( accessor.slice(" + string3 + "_offset[mdIdx],  PointerBuffer.ELEMENT_SIZE) ).get(0);");
                    printWriter.println("    return " + string14 + ";");
                    printWriter.println("  }");
                }
            } else if (bl12) {
                this.generateGetterSignature(printWriter, type2, false, false, string6, string3, string11, null, string14);
                printWriter.println(" {");
                if (bl2) {
                    printWriter.println("    return accessor.get" + string12 + "At(" + string3 + "_offset[mdIdx]);");
                } else {
                    printWriter.println("    return accessor.get" + string12 + "At(" + string3 + "_offset[mdIdx], md." + string5 + "SizeInBytes());");
                }
                printWriter.println("  }");
                printWriter.println();
            } else {
                this.generateGetterSignature(printWriter, type2, false, false, string12 + "Buffer", string3, string11, null, string14);
                printWriter.println(" {");
                printWriter.print("    return accessor.slice(" + string3 + "_offset[mdIdx],  Buffers.SIZEOF_" + string13 + " * " + string14 + ")");
                if (!bl9) {
                    printWriter.print(".as" + string12 + "Buffer()");
                }
                printWriter.println(";");
                printWriter.println("  }");
                printWriter.println();
                if (bl7 && bl9) {
                    this.generateGetterSignature(printWriter, type2, false, false, "String", string3, string11 + "AsString", null, string14);
                    printWriter.println(" {");
                    printWriter.println("    final int offset = " + string3 + "_offset[mdIdx];");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    final ByteBuffer bb = getBuffer();");
                    printWriter.println("    final byte[] ba = new byte[arrayLength];");
                    printWriter.println("    int i = -1;");
                    printWriter.println("    while( ++i < arrayLength ) {");
                    printWriter.println("      ba[i] = bb.get(offset+i);");
                    printWriter.println("      if( (byte)0 == ba[i] ) break;");
                    printWriter.println("    }");
                    printWriter.println("    return new String(ba, 0, i);");
                    printWriter.println("  }");
                } else {
                    this.generateGetterSignature(printWriter, type2, false, false, string6 + "[]", string3, string11, "final int offset, " + string6 + " result[]", string14);
                    printWriter.println(" {");
                    printWriter.println("    final int arrayLength = " + string14 + ";");
                    printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
                    printWriter.println("    return accessor.get" + string12 + "sAt(" + string3 + "_offset[mdIdx] + (Buffers.SIZEOF_" + string13 + " * offset), result);");
                    printWriter.println("  }");
                    printWriter.println();
                }
            }
        } else if (bl4) {
            object2 = new FunctionType(dummyFuncTypeName, SizeThunk.POINTER, type2, 0);
            ((FunctionType)object2).addArgument(type.newCVVariant(type.getCVAttributes() | 1), CMethodBindingEmitter.cThisArgumentName());
            ((FunctionType)object2).addArgument(int32Type, nativeArrayElemOffsetArg);
            aSTLocusTagProvider = new FunctionSymbol("get" + string11, (FunctionType)object2);
            printWriter2.println();
            printWriter2.print("static " + ((FunctionSymbol)aSTLocusTagProvider).toString(false));
            printWriter2.println("{");
            printWriter2.println("  return " + CMethodBindingEmitter.cThisArgumentName() + "->" + field.getName() + "+" + nativeArrayElemOffsetArg + ";");
            printWriter2.println("}");
            printWriter2.println();
            this.generateArrayPointerCode(set, printWriter, printWriter2, string, string2, type, javaType, n, (FunctionSymbol)aSTLocusTagProvider, string4, string14, nativeArrayLengthONE);
            printWriter.println();
            if (bl12) {
                this.generateGetterSignature(printWriter, type2, false, false, string6, string3, string11, null, string14);
                printWriter.println(" {");
                printWriter.println("    final ByteBuffer source = getBuffer();");
                printWriter.println("    final ByteBuffer _res = get" + string11 + "0(source, 0);");
                printWriter.println("    if (_res == null) return null;");
                printWriter.println("    return " + string6 + ".create(_res);");
                printWriter.println("  }");
            } else {
                this.generateGetterSignature(printWriter, type2, false, false, string6 + "[]", string3, string11, "final int offset, " + string6 + " result[]", string14);
                printWriter.println(" {");
                printWriter.println("    final int arrayLength = " + string14 + ";");
                printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
                printWriter.println("    final ByteBuffer source = getBuffer();");
                printWriter.println("    for(int index=0; index<result.length; index++) {");
                printWriter.println("      final ByteBuffer _res = get" + string11 + "0(source, offset+index);");
                printWriter.println("      if (_res == null) return null;");
                printWriter.println("      result[index] = " + string6 + ".create(_res);");
                printWriter.println("    }");
                printWriter.println("    return result;");
                printWriter.println("  }");
            }
        } else if (bl12) {
            this.generateGetterSignature(printWriter, type2, false, false, string6, string3, string11, null, string14);
            printWriter.println(" {");
            printWriter.println("    return " + string6 + ".create(accessor.slice(" + string3 + "_offset[mdIdx], " + string6 + ".size()));");
            printWriter.println("  }");
        } else {
            this.generateGetterSignature(printWriter, type2, false, false, string6 + "[]", string3, string11, "final int offset, " + string6 + " result[]", string14);
            printWriter.println(" {");
            printWriter.println("    final int arrayLength = " + string14 + ";");
            printWriter.println("    if( offset + result.length > arrayLength ) { throw new IndexOutOfBoundsException(\"offset \"+offset+\" + result.length \"+result.length+\" > array-length \"+arrayLength); };");
            printWriter.println("    final int elemSize = " + string6 + ".size();");
            printWriter.println("    int bOffset = " + string3 + "_offset[mdIdx] + ( elemSize * offset );");
            printWriter.println("    for(int index=0; index<result.length; index++) {");
            printWriter.println("      result[index] = " + string6 + ".create(accessor.slice(bOffset, elemSize));");
            printWriter.println("      bOffset += elemSize;");
            printWriter.println("    }");
            printWriter.println("    return result;");
            printWriter.println("  }");
        }
    }

    private JavaType typeToJavaType(Type type, MachineDataInfo machineDataInfo) {
        JavaType javaType = this.typeToJavaTypeImpl(type, machineDataInfo);
        this.LOG.log(Level.FINE, type.getASTLocusTag(), "typeToJavaType: {0} -> {1}", type, javaType);
        return javaType;
    }

    private boolean isJNIEnvPointer(Type type) {
        PointerType pointerType = type.asPointer();
        return pointerType != null && pointerType.getTargetType().getName() != null && pointerType.getTargetType().getName().equals("JNIEnv");
    }

    private JavaType typeToJavaTypeImpl(Type type, MachineDataInfo machineDataInfo) {
        Object object;
        if (this.isJNIEnvPointer(type)) {
            return JavaType.createForJNIEnv();
        }
        TypeInfo typeInfo = this.cfg.typeInfo(type);
        if (typeInfo != null) {
            boolean bl = false;
            if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
                object = type.isPointer() ? type.asPointer().getTargetType() : type.asArray().getBaseElementType();
                if ((type.pointerDepth() == 2 || type.arrayDimension() == 2) && ((Type)object).isPointer()) {
                    bl = true;
                    if (GlueGen.debug()) {
                        Type type2 = ((Type)object).asPointer().getTargetType();
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "Opaque Type: {0}, targetType: {1}, bottomType: {2} is ptr-ptr", type, object, type2);
                    }
                }
            }
            if (!bl) {
                return typeInfo.javaType();
            }
        }
        if (type.isInt() || type.isEnum()) {
            switch ((int)type.getSize(machineDataInfo)) {
                case 1: {
                    return this.javaType(Byte.TYPE);
                }
                case 2: {
                    return this.javaType(Short.TYPE);
                }
                case 4: {
                    return this.javaType(Integer.TYPE);
                }
                case 8: {
                    return this.javaType(Long.TYPE);
                }
            }
            throw new GlueGenException("Unknown integer type of size " + type.getSize(machineDataInfo) + " and name " + type.getName(), type.getASTLocusTag());
        }
        if (type.isFloat()) {
            return this.javaType(Float.TYPE);
        }
        if (type.isDouble()) {
            return this.javaType(Double.TYPE);
        }
        if (type.isVoid()) {
            return this.javaType(Void.TYPE);
        }
        if (type.pointerDepth() > 0 || type.arrayDimension() > 0) {
            Type type3 = type.isPointer() ? type.asPointer().getTargetType() : type.asArray().getBaseElementType();
            if (type.pointerDepth() == 1 || type.arrayDimension() == 1) {
                if (type3.isVoid()) {
                    return JavaType.createForCVoidPointer();
                }
                if (type3.isInt()) {
                    object = type3.getSize();
                    if (null != object && SizeThunk.POINTER == object) {
                        return JavaType.forNIOPointerBufferClass();
                    }
                    switch ((int)type3.getSize(machineDataInfo)) {
                        case 1: {
                            return JavaType.createForCCharPointer();
                        }
                        case 2: {
                            return JavaType.createForCShortPointer();
                        }
                        case 4: {
                            return JavaType.createForCInt32Pointer();
                        }
                        case 8: {
                            return JavaType.createForCInt64Pointer();
                        }
                    }
                    throw new GlueGenException("Unknown integer array type of size " + type.getSize(machineDataInfo) + " and name " + type.getName() + ", " + type.getDebugString(), type.getASTLocusTag());
                }
                if (type3.isFloat()) {
                    return JavaType.createForCFloatPointer();
                }
                if (type3.isDouble()) {
                    return JavaType.createForCDoublePointer();
                }
                if (type3.isCompound()) {
                    if (type.isArray()) {
                        return JavaType.createForCArray(type3);
                    }
                    if (type.getName() != null && type.getName().equals("jobject")) {
                        return this.javaType(Object.class);
                    }
                    if (!type3.isTypedef() && type.isTypedef()) {
                        object = type.getName();
                    } else {
                        object = type3.getName();
                        if (null == object && (object = type.getName()) == null) {
                            throw new GlueGenException("Couldn't find a proper type name for pointer type " + type.getDebugString(), type.getASTLocusTag());
                        }
                    }
                    return JavaType.createForCStruct(this.cfg.renameJavaType((String)object));
                }
                throw new GlueGenException("Don't know how to convert pointer/array type \"" + type.getDebugString() + "\"", type.getASTLocusTag());
            }
            if (type.pointerDepth() == 2 || type.arrayDimension() == 2) {
                if (type3.isPointer()) {
                    object = type3.asPointer().getTargetType();
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3, object);
                    }
                    return JavaType.forNIOPointerBufferClass();
                }
                if (type3.isArray()) {
                    object = type3.asArray().getBaseElementType();
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr.array): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3, object);
                    }
                } else {
                    object = type3;
                    if (GlueGen.debug()) {
                        this.LOG.log(Level.INFO, type.getASTLocusTag(), "typeToJavaType(ptr-ptr.primitive): {0}, targetType: {1}, bottomType: {2}", type.getDebugString(), type3, object);
                    }
                }
                if (((Type)object).isPrimitive()) {
                    if (((Type)object).isInt()) {
                        switch ((int)((Type)object).getSize(machineDataInfo)) {
                            case 1: {
                                return this.javaType(ArrayTypes.byteBufferArrayClass);
                            }
                            case 2: {
                                return this.javaType(ArrayTypes.shortBufferArrayClass);
                            }
                            case 4: {
                                return this.javaType(ArrayTypes.intBufferArrayClass);
                            }
                            case 8: {
                                return this.javaType(ArrayTypes.longBufferArrayClass);
                            }
                        }
                        throw new GlueGenException("Unknown two-dimensional integer array type of element size " + ((Type)object).getSize(machineDataInfo) + " and name " + ((Type)object).getName() + ", " + ((Type)object).getDebugString(), ((Type)object).getASTLocusTag());
                    }
                    if (((Type)object).isFloat()) {
                        return this.javaType(ArrayTypes.floatBufferArrayClass);
                    }
                    if (((Type)object).isDouble()) {
                        return this.javaType(ArrayTypes.doubleBufferArrayClass);
                    }
                    throw new GlueGenException("Unexpected primitive type " + ((Type)object).getDebugString() + " in two-dimensional array", ((Type)object).getASTLocusTag());
                }
                if (((Type)object).isVoid()) {
                    return this.javaType(ArrayTypes.bufferArrayClass);
                }
                if (type3.isPointer() && type3.pointerDepth() == 1 && type3.asPointer().getTargetType().isCompound()) {
                    return JavaType.createForCArray((Type)object);
                }
                throw new GlueGenException("Could not convert C type \"" + type.getDebugString() + "\" " + "to appropriate Java type; need to add more support for " + "depth=2 pointer/array types [debug info: targetType=\"" + type3 + "\"]", type.getASTLocusTag());
            }
            throw new GlueGenException("Could not convert C pointer/array \"" + type.getDebugString() + "\" to " + "appropriate Java type; types with pointer/array depth " + "greater than 2 are not yet supported [debug info: " + "pointerDepth=" + type.pointerDepth() + " arrayDimension=" + type.arrayDimension() + " targetType=\"" + type3 + "\"]", type.getASTLocusTag());
        }
        if (type.isCompound()) {
            String string = type.getName();
            if (string == null && (string = type.asCompound().getStructName()) == null) {
                throw new GlueGenException("Couldn't find a proper type name for pointer type " + type.getDebugString(), type.getASTLocusTag());
            }
            return JavaType.createForCStruct(this.cfg.renameJavaType(string));
        }
        throw new GlueGenException("Could not convert C type \"" + type.getDebugString() + "\" (class " + type.getClass().getName() + ") to appropriate Java type", type.getASTLocusTag());
    }

    private static boolean isIntegerType(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE;
    }

    private StructLayout getLayout() {
        if (this.layout == null) {
            this.layout = StructLayout.create(0);
        }
        return this.layout;
    }

    protected PrintWriter openFile(String string, String string2) throws IOException {
        File file = new File(string);
        String string3 = file.getParent();
        if (string3 != null) {
            new File(string3).mkdirs();
        }
        return new PrintWriter(new BufferedWriter(new FileWriter(file)));
    }

    private boolean isOpaque(Type type) {
        return null != this.cfg.typeInfo(type);
    }

    private String compatiblePrimitiveJavaTypeName(Type type, JavaType javaType, MachineDataInfo machineDataInfo) {
        Class<?> clazz = javaType.getJavaClass();
        if (!JavaEmitter.isIntegerType(clazz)) {
            throw new GlueGenException("Can't yet handle opaque definitions of structs' fields to non-integer types (byte, short, int, long, etc.): type: " + type + ", javaType " + javaType + ", javaClass " + clazz, type.getASTLocusTag());
        }
        switch ((int)type.getSize(machineDataInfo)) {
            case 1: {
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 8: {
                return "long";
            }
        }
        throw new GlueGenException("Can't handle opaque definitions if the starting type isn't compatible with integral types", type.getASTLocusTag());
    }

    private void openWriters() throws IOException {
        String string = null;
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            string = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        String string2 = null;
        if (!this.cfg.allStatic()) {
            string2 = this.cfg.javaOutputDir() + File.separator + CodeGenUtils.packageAsPath(this.cfg.implPackageName());
        }
        String string3 = this.cfg.nativeOutputDir();
        if (this.cfg.nativeOutputUsesJavaHierarchy()) {
            string3 = string3 + File.separator + CodeGenUtils.packageAsPath(this.cfg.packageName());
        }
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaFileName = string + File.separator + this.cfg.className() + ".java";
            this.javaWriter = this.openFile(this.javaFileName, this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaFileName = string2 + File.separator + this.cfg.implClassName() + ".java";
            this.javaImplWriter = this.openFile(this.javaFileName, this.cfg.implClassName());
        }
        if (this.cfg.emitImpl()) {
            this.cFileName = string3 + File.separator + this.cfg.implClassName() + "_JNI.c";
            this.cWriter = this.openFile(this.cFileName, this.cfg.implClassName());
        }
        if (this.javaWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaWriter, this);
        }
        if (this.javaImplWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.javaImplWriter, this);
        }
        if (this.cWriter != null) {
            CodeGenUtils.emitAutogeneratedWarning(this.cWriter, this);
        }
    }

    protected String javaFileName() {
        return this.javaFileName;
    }

    protected PrintWriter javaWriter() {
        if (!this.cfg.allStatic() && !this.cfg.emitInterface()) {
            throw new InternalError("Should not call this");
        }
        return this.javaWriter;
    }

    protected PrintWriter javaImplWriter() {
        if (this.cfg.allStatic() || !this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.javaImplWriter;
    }

    protected String cFileName() {
        return this.cFileName;
    }

    protected PrintWriter cWriter() {
        if (!this.cfg.emitImpl()) {
            throw new InternalError("Should not call this");
        }
        return this.cWriter;
    }

    private void closeWriter(PrintWriter printWriter) throws IOException {
        printWriter.flush();
        printWriter.close();
    }

    private void closeWriters() throws IOException {
        if (this.javaWriter != null) {
            this.closeWriter(this.javaWriter);
        }
        if (this.javaImplWriter != null) {
            this.closeWriter(this.javaImplWriter);
        }
        if (this.cWriter != null) {
            this.closeWriter(this.cWriter);
        }
        this.javaWriter = null;
        this.javaImplWriter = null;
        this.cWriter = null;
    }

    protected String getJavaOutputDir() {
        return this.cfg.javaOutputDir();
    }

    protected String getJavaPackageName() {
        return this.cfg.packageName();
    }

    protected String getImplPackageName() {
        return this.cfg.implPackageName();
    }

    protected void emitCustomJavaCode(PrintWriter printWriter, String string) throws Exception {
        List<String> list = this.cfg.customJavaCodeForClass(string);
        if (list.isEmpty()) {
            return;
        }
        printWriter.println();
        printWriter.println("  // --- Begin CustomJavaCode .cfg declarations");
        for (String string2 : list) {
            printWriter.println(string2);
        }
        printWriter.println("  // ---- End CustomJavaCode .cfg declarations");
    }

    public String[] getClassAccessModifiers(String string) {
        String[] stringArray;
        MethodAccess methodAccess = this.cfg.accessControl(string);
        if (MethodAccess.PUBLIC_ABSTRACT == methodAccess) {
            stringArray = new String[]{MethodAccess.PUBLIC.getJavaName(), MethodAccess.PUBLIC_ABSTRACT.getJavaName()};
        } else if (MethodAccess.PACKAGE_PRIVATE == methodAccess) {
            stringArray = new String[]{MethodAccess.PACKAGE_PRIVATE.getJavaName()};
        } else {
            if (MethodAccess.PRIVATE == methodAccess) {
                throw new IllegalArgumentException("Class access " + string + " cannot be private");
            }
            stringArray = MethodAccess.PROTECTED == methodAccess ? new String[]{MethodAccess.PROTECTED.getJavaName()} : new String[]{MethodAccess.PUBLIC.getJavaName()};
        }
        return stringArray;
    }

    protected void emitAllFileHeaders() throws IOException {
        try {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            List<String> list;
            ArrayList<String> arrayList = new ArrayList<String>(this.cfg.imports());
            arrayList.add(this.cfg.gluegenRuntimePackage() + ".*");
            arrayList.add(DynamicLookupHelper.class.getPackage().getName() + ".*");
            arrayList.add(Buffers.class.getPackage().getName() + ".*");
            arrayList.add(Buffer.class.getPackage().getName() + ".*");
            if (this.cfg.allStatic() || this.cfg.emitInterface()) {
                list = null;
                list = this.cfg.emitInterface() ? this.cfg.extendedInterfaces(this.cfg.className()) : this.cfg.implementedInterfaces(this.cfg.className());
                stringArray2 = new String[list.size()];
                list.toArray(stringArray2);
                stringArray = this.cfg.javadocForClass(this.cfg.className());
                object = new CodeGenUtils.EmissionCallback((List)stringArray){
                    final /* synthetic */ List val$intfDocs;
                    {
                        this.val$intfDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$intfDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                String[] stringArray3 = this.getClassAccessModifiers(this.cfg.className());
                CodeGenUtils.emitJavaHeaders(this.javaWriter, this.cfg.packageName(), this.cfg.className(), this.cfg.allStatic(), arrayList, stringArray3, stringArray2, this.cfg.extendedParentClass(this.cfg.className()), (CodeGenUtils.EmissionCallback)object);
            }
            if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
                stringArray2 = this.cfg.javadocForClass(this.cfg.implClassName());
                list = new CodeGenUtils.EmissionCallback((List)stringArray2){
                    final /* synthetic */ List val$implDocs;
                    {
                        this.val$implDocs = list;
                    }

                    @Override
                    public void emit(PrintWriter printWriter) {
                        Iterator iterator = this.val$implDocs.iterator();
                        while (iterator.hasNext()) {
                            printWriter.println((String)iterator.next());
                        }
                    }
                };
                object = null;
                object = this.cfg.implementedInterfaces(this.cfg.implClassName());
                int n = 0;
                if (this.cfg.className() != null) {
                    n = 1;
                }
                stringArray = new String[n + object.size()];
                object.toArray(stringArray);
                if (n == 1) {
                    stringArray[object.size()] = this.cfg.className();
                }
                String[] stringArray4 = this.getClassAccessModifiers(this.cfg.implClassName());
                CodeGenUtils.emitJavaHeaders(this.javaImplWriter, this.cfg.implPackageName(), this.cfg.implClassName(), true, arrayList, stringArray4, stringArray, this.cfg.extendedParentClass(this.cfg.implClassName()), (CodeGenUtils.EmissionCallback)((Object)list));
            }
            if (this.cfg.emitImpl()) {
                this.emitCHeader(this.cWriter(), this.getImplPackageName(), this.cfg.implClassName());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Error emitting all file headers: cfg.allStatic()=" + this.cfg.allStatic() + " cfg.emitImpl()=" + this.cfg.emitImpl() + " cfg.emitInterface()=" + this.cfg.emitInterface(), exception);
        }
    }

    protected void emitCHeader(PrintWriter printWriter, String string, String string2) {
        printWriter.println("#include <jni.h>");
        printWriter.println("#include <stdlib.h>");
        printWriter.println("#include <string.h>");
        printWriter.println();
        if (this.getConfig().emitImpl()) {
            printWriter.println("#include <assert.h>");
            printWriter.println();
            printWriter.println("static jobject JVMUtil_NewDirectByteBufferCopy(JNIEnv *env, void * source_address, jlong capacity); /* forward decl. */");
            printWriter.println();
        }
        for (String string3 : this.cfg.customCCode()) {
            printWriter.println(string3);
        }
        printWriter.println();
    }

    protected void emitCInitCode(PrintWriter printWriter, String string, String string2) {
        if (this.requiresStaticInitialization(string2)) {
            printWriter.println(staticClassInitCodeCCode);
            printWriter.println("JNIEXPORT jboolean JNICALL " + JavaEmitter.getJNIMethodNamePrefix(string, string2) + "_initializeImpl(JNIEnv *env, jclass _unused) {");
            printWriter.println("    return _initClazzAccess(env);");
            printWriter.println("}");
            printWriter.println();
            printWriter.println("JNIEXPORT jint JNICALL " + JavaEmitter.getJNIMethodNamePrefix(string, string2) + "_getCStringLengthImpl(JNIEnv *env, jclass _unused, jlong pString) {");
            printWriter.println("    return 0 != pString ? strlen((const char*)(intptr_t)pString) : 0;");
            printWriter.println("}");
            printWriter.println();
        }
    }

    protected void emitJavaInitCode(PrintWriter printWriter, String string) {
        if (null != printWriter && this.requiresStaticInitialization(string)) {
            printWriter.println();
            printWriter.println("  private static native boolean initializeImpl();");
            printWriter.println();
            printWriter.println();
            printWriter.println("  private static native int getCStringLengthImpl(final long pString);");
            printWriter.println();
            if (!this.cfg.manualStaticInitCall(string)) {
                printWriter.println(staticClassInitCallJavaCode);
            }
        }
    }

    protected void emitAllFileFooters() {
        if (this.cfg.allStatic() || this.cfg.emitInterface()) {
            this.javaWriter().println();
            this.javaWriter().println("} // end of class " + this.cfg.className());
        }
        if (!this.cfg.allStatic() && this.cfg.emitImpl()) {
            this.javaImplWriter().println();
            this.javaImplWriter().println("} // end of class " + this.cfg.implClassName());
        }
    }

    private JavaType javaType(Class<?> clazz) {
        return JavaType.createForClass(clazz);
    }

    private MethodBinding bindFunction(FunctionSymbol functionSymbol, boolean bl, MachineDataInfo machineDataInfo, JavaType javaType, Type type) {
        Object object;
        Object object2;
        String string;
        String string2 = string = null == javaType && null == type ? this.cfg.getDelegatedImplementation(functionSymbol) : null;
        if (!bl && null != string) {
            functionSymbol = FunctionSymbol.cloneWithDeepAliases(functionSymbol);
            functionSymbol.addAliasedName(string);
        }
        String string3 = functionSymbol.getName();
        if (this.cfg.returnsString(functionSymbol)) {
            object2 = functionSymbol.getReturnType().asPointer();
            if (object2 == null || ((PointerType)object2).getTargetType().asInt() == null || ((PointerType)object2).getTargetType().getSize(machineDataInfo) != 1L) {
                throw new GlueGenException("Cannot apply ReturnsString configuration directive to \"" + functionSymbol + "\". ReturnsString requires native method to have return type \"char *\"", functionSymbol.getASTLocusTag());
            }
            object = this.javaType(String.class);
        } else {
            object2 = this.cfg.getOpaqueReturnType(functionSymbol);
            object = null != object2 ? object2 : this.typeToJavaType(functionSymbol.getReturnType(), machineDataInfo);
        }
        object2 = new ArrayList<JavaType>();
        List<Integer> list = this.cfg.stringArguments(string3);
        for (int i = 0; i < functionSymbol.getNumArguments(); ++i) {
            Type type2 = functionSymbol.getArgumentType(i);
            JavaType javaType2 = this.typeToJavaType(type2, machineDataInfo);
            if (list != null && list.contains(i)) {
                if (javaType2.isCVoidPointerType() || javaType2.isCCharPointerType() || javaType2.isCShortPointerType() || javaType2.isNIOPointerBuffer() || javaType2.isArray() && javaType2.getJavaClass() == ArrayTypes.byteBufferArrayClass || javaType2.getJavaClass() == ArrayTypes.shortBufferArrayClass) {
                    javaType2 = javaType2.isArray() || javaType2.isNIOPointerBuffer() ? this.javaType(ArrayTypes.stringArrayClass) : this.javaType(String.class);
                } else {
                    throw new GlueGenException("Cannot apply ArgumentIsString configuration directive to argument " + i + " of \"" + functionSymbol + "\": argument type is not " + "a \"void*\", \"char *\", \"short *\", \"char**\", or \"short**\" equivalent", functionSymbol.getASTLocusTag());
                }
            }
            object2.add((JavaType)javaType2);
        }
        MethodBinding methodBinding = new MethodBinding(functionSymbol, string, (JavaType)object, (List<JavaType>)object2, javaType, type);
        this.mangleBinding(methodBinding);
        return methodBinding;
    }

    private MethodBinding lowerMethodBindingPointerTypes(MethodBinding methodBinding, boolean bl, boolean[] blArray) {
        MethodBinding methodBinding2 = methodBinding;
        boolean bl2 = false;
        for (int i = 0; i < methodBinding.getNumArguments(); ++i) {
            JavaType javaType = methodBinding.getJavaArgumentType(i);
            if (!javaType.isCPrimitivePointerType()) continue;
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOBufferClass());
                continue;
            }
            if (javaType.isCCharPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.byteArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOByteBufferClass());
                continue;
            }
            if (javaType.isCShortPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.shortArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOShortBufferClass());
                continue;
            }
            if (javaType.isCInt32PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.intArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOIntBufferClass());
                continue;
            }
            if (javaType.isCInt64PointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.longArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOLongBufferClass());
                continue;
            }
            if (javaType.isCFloatPointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.floatArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIOFloatBufferClass());
                continue;
            }
            if (javaType.isCDoublePointerType()) {
                bl2 = true;
                if (bl) {
                    methodBinding2 = methodBinding2.replaceJavaArgumentType(i, this.javaType(ArrayTypes.doubleArrayClass));
                    continue;
                }
                methodBinding2 = methodBinding2.replaceJavaArgumentType(i, JavaType.forNIODoubleBufferClass());
                continue;
            }
            throw new GlueGenException("Unknown C pointer type " + javaType);
        }
        JavaType javaType = methodBinding2.getJavaReturnType();
        if (javaType.isCPrimitivePointerType()) {
            if (javaType.isCVoidPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCCharPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOByteBufferClass());
            } else if (javaType.isCShortPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOShortBufferClass());
            } else if (javaType.isCInt32PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOIntBufferClass());
            } else if (javaType.isCInt64PointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOLongBufferClass());
            } else if (javaType.isCFloatPointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIOFloatBufferClass());
            } else if (javaType.isCDoublePointerType()) {
                methodBinding2 = methodBinding2.replaceJavaArgumentType(-1, JavaType.forNIODoubleBufferClass());
            } else {
                throw new GlueGenException("Unknown C pointer type " + javaType, methodBinding2.getCReturnType().getASTLocusTag());
            }
        }
        if (blArray != null) {
            blArray[0] = bl2;
        }
        return methodBinding2;
    }

    protected void mangleBinding(MethodBinding methodBinding) {
    }

    protected List<MethodBinding> expandMethodBinding(MethodBinding methodBinding) {
        ArrayList<MethodBinding> arrayList = new ArrayList<MethodBinding>();
        boolean[] blArray = new boolean[1];
        if (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCVoidPointers() || methodBinding.signatureUsesCArrays()) {
            arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, false, blArray));
            if (blArray[0] && (methodBinding.signatureUsesCPrimitivePointers() || methodBinding.signatureUsesCArrays()) && !this.cfg.useNIOOnly(methodBinding.getName())) {
                arrayList.add(this.lowerMethodBindingPointerTypes(methodBinding, true, null));
            }
        } else {
            arrayList.add(methodBinding);
        }
        return arrayList;
    }

    private Type canonicalize(Type type) {
        Type type2 = this.canonMap.get(type);
        if (type2 != null) {
            return type2;
        }
        this.canonMap.put(type, type);
        return type;
    }

    private final String capitalizeString(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    class ConstFuncRenamer
    implements SymbolFilter {
        private List<ConstantDefinition> constants;
        private List<FunctionSymbol> functions;

        ConstFuncRenamer() {
        }

        @Override
        public List<ConstantDefinition> getConstants() {
            return this.constants;
        }

        @Override
        public List<FunctionSymbol> getFunctions() {
            return this.functions;
        }

        private <T extends TypeComparator.AliasedSemanticSymbol> List<T> filterSymbolsInt(List<T> list, List<T> list2) {
            JavaConfiguration javaConfiguration = JavaEmitter.this.getConfig();
            HashMap<String, TypeComparator.AliasedSemanticSymbol> hashMap = new HashMap<String, TypeComparator.AliasedSemanticSymbol>(100);
            for (TypeComparator.AliasedSemanticSymbol aliasedSemanticSymbol : list) {
                TypeComparator.AliasedSemanticSymbol aliasedSemanticSymbol2;
                String string = aliasedSemanticSymbol.getName();
                String string2 = javaConfiguration.getJavaSymbolRename(string);
                if (null != string2) {
                    aliasedSemanticSymbol2 = (TypeComparator.AliasedSemanticSymbol)hashMap.get(string2);
                    if (null != aliasedSemanticSymbol2) {
                        aliasedSemanticSymbol.rename(string2);
                    }
                } else {
                    aliasedSemanticSymbol2 = (TypeComparator.AliasedSemanticSymbol)hashMap.get(string);
                }
                if (null != aliasedSemanticSymbol2 && !aliasedSemanticSymbol2.equalSemantics(aliasedSemanticSymbol)) {
                    ASTLocusTag aSTLocusTag = aliasedSemanticSymbol instanceof ASTLocusTag.ASTLocusTagProvider ? ((ASTLocusTag.ASTLocusTagProvider)((Object)aliasedSemanticSymbol)).getASTLocusTag() : null;
                    String string3 = aliasedSemanticSymbol2 instanceof ASTLocusTag.ASTLocusTagProvider ? String.format(",%n  %s: previous definition is here", ((ASTLocusTag.ASTLocusTagProvider)((Object)aliasedSemanticSymbol2)).getASTLocusTag().toString(new StringBuilder(), "note", true)) : "";
                    String string4 = null != string2 ? "alias" : "orig";
                    String string5 = String.format("Duplicate Name (%s) w/ incompatible value:%n  this '%s',%n  have '%s'%s", string4, aliasedSemanticSymbol.getAliasedString(), aliasedSemanticSymbol2.getAliasedString(), string3);
                    throw new GlueGenException(string5, aSTLocusTag);
                }
                if (null != string2) {
                    if (null != aliasedSemanticSymbol2) {
                        aliasedSemanticSymbol2.addAliasedName(string);
                        continue;
                    }
                    aliasedSemanticSymbol.rename(string2);
                    hashMap.put(string2, aliasedSemanticSymbol);
                    continue;
                }
                if (null != aliasedSemanticSymbol2) continue;
                hashMap.put(string, aliasedSemanticSymbol);
            }
            list2.addAll(hashMap.values());
            Collections.sort(list2, new Comparator<T>(){

                @Override
                public int compare(T t, T t2) {
                    return t.getName().compareTo(t2.getName());
                }
            });
            return list2;
        }

        @Override
        public void filterSymbols(List<ConstantDefinition> list, List<FunctionSymbol> list2) {
            this.constants = this.filterSymbolsInt(list, new ArrayList(100));
            this.functions = this.filterSymbolsInt(list2, new ArrayList(100));
        }
    }

    public static enum MethodAccess {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private"),
        PACKAGE_PRIVATE("/* pp */"),
        PUBLIC_ABSTRACT("abstract");

        private final String javaName;

        public final String getJavaName() {
            return this.javaName;
        }

        private MethodAccess(String string2) {
            this.javaName = string2;
        }
    }

    public static enum EmissionStyle {
        AllStatic,
        InterfaceAndImpl,
        InterfaceOnly,
        ImplOnly;

    }
}

