/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.loaders.lw3d.LwsBackground;
import com.sun.j3d.loaders.lw3d.LwsCamera;
import com.sun.j3d.loaders.lw3d.LwsFog;
import com.sun.j3d.loaders.lw3d.LwsLight;
import com.sun.j3d.loaders.lw3d.LwsObject;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Background;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Fog;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;

public class Lw3dLoader
extends TextfileParser
implements Loader {
    Vector objectList;
    Vector lightList;
    BranchGroup sceneGroupNode;
    Color3f ambientColor = new Color3f(0.0f, 0.0f, 0.0f);
    LwsCamera camera = null;
    LwsFog fog = null;
    LwsBackground background = null;
    int loadFlags = 0;
    int loadBehaviors = 0;
    Vector sceneBehaviors;
    SceneBase scene = null;
    String basePath = null;
    String internalBasePath = null;
    URL baseUrl = null;
    String internalBaseUrl = null;
    static final int FILE_TYPE_NONE = 0;
    static final int FILE_TYPE_URL = 1;
    static final int FILE_TYPE_FILENAME = 2;
    static final int FILE_TYPE_READER = 4;
    int fileType = 0;

    public Lw3dLoader() {
        this.objectList = new Vector();
        this.lightList = new Vector();
        this.debugPrinter.setValidOutput(0);
    }

    public Lw3dLoader(int n) {
        this();
        this.loadFlags = n;
        this.loadBehaviors = this.loadFlags & 8;
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStreamReader inputStreamReader;
        this.fileType = 1;
        this.setInternalBaseUrl(uRL);
        try {
            inputStreamReader = new InputStreamReader(new BufferedInputStream(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        Scene scene = this.load(inputStreamReader);
        this.fileType = 0;
        return scene;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.fileType = 2;
        this.setInternalBasePath(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        Scene scene = this.load(bufferedReader);
        this.fileType = 0;
        return scene;
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        if (this.fileType == 0) {
            this.fileType = 4;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(reader);
        this.setupTokenizer(streamTokenizer);
        this.getAndCheckString(streamTokenizer, "LWSC");
        this.getNumber(streamTokenizer);
        this.getAndCheckString(streamTokenizer, "FirstFrame");
        int n = (int)this.getNumber(streamTokenizer);
        this.getAndCheckString(streamTokenizer, "LastFrame");
        int n2 = (int)this.getNumber(streamTokenizer);
        this.skipUntilString(streamTokenizer, "FramesPerSecond");
        double d = this.getNumber(streamTokenizer);
        float f = (float)(n2 - n) / (float)d;
        boolean bl = false;
        block6: while (!bl) {
            int n3;
            try {
                n3 = streamTokenizer.nextToken();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
            switch (streamTokenizer.ttype) {
                case -1: {
                    bl = true;
                    break;
                }
                case -3: {
                    this.debugOutputLn(2, "  String = " + streamTokenizer.sval);
                    if (streamTokenizer.sval.equals("AddNullObject")) {
                        LwsObject lwsObject = new LwsObject(streamTokenizer, false, n, n2, f, this, this.debugPrinter.getValidOutput());
                        lwsObject.createJava3dObject(null, this.loadBehaviors);
                        this.objectList.addElement(lwsObject);
                        break;
                    }
                    if (streamTokenizer.sval.equals("LoadObject")) {
                        String string = this.getString(streamTokenizer);
                        streamTokenizer.pushBack();
                        this.debugOutputLn(32, "loading " + string + " at " + System.currentTimeMillis());
                        LwsObject lwsObject = new LwsObject(streamTokenizer, true, n, n2, f, this, this.debugPrinter.getValidOutput());
                        this.debugOutputLn(32, "done loading at " + System.currentTimeMillis());
                        LwsObject lwsObject2 = null;
                        Enumeration enumeration = this.objectList.elements();
                        while (enumeration.hasMoreElements()) {
                            LwsObject lwsObject3 = (LwsObject)enumeration.nextElement();
                            if (lwsObject3.fileName == null || !lwsObject3.fileName.equals(string)) continue;
                            lwsObject2 = lwsObject3;
                            break;
                        }
                        lwsObject.createJava3dObject(lwsObject2, this.loadBehaviors);
                        this.objectList.addElement(lwsObject);
                        break;
                    }
                    if (streamTokenizer.sval.equals("AmbientColor")) {
                        this.ambientColor.x = (float)this.getNumber(streamTokenizer) / 255.0f;
                        this.ambientColor.y = (float)this.getNumber(streamTokenizer) / 255.0f;
                        this.ambientColor.z = (float)this.getNumber(streamTokenizer) / 255.0f;
                        break;
                    }
                    if (streamTokenizer.sval.equals("AmbIntensity")) {
                        float f2 = (float)this.getNumber(streamTokenizer);
                        this.ambientColor.x *= f2;
                        this.ambientColor.y *= f2;
                        this.ambientColor.z *= f2;
                        break;
                    }
                    if (streamTokenizer.sval.equals("AddLight")) {
                        LwsLight lwsLight = new LwsLight(streamTokenizer, n2, f, this.debugPrinter.getValidOutput());
                        lwsLight.createJava3dObject(this.loadBehaviors);
                        this.lightList.addElement(lwsLight);
                        break;
                    }
                    if (streamTokenizer.sval.equals("ShowCamera")) {
                        this.camera = new LwsCamera(streamTokenizer, n, n2, f, this.debugPrinter.getValidOutput());
                        this.camera.createJava3dObject(this.loadBehaviors);
                        break;
                    }
                    if (streamTokenizer.sval.equals("FogType")) {
                        int n4 = (int)this.getNumber(streamTokenizer);
                        if (n4 == 0) continue block6;
                        this.fog = new LwsFog(streamTokenizer, this.debugPrinter.getValidOutput());
                        this.fog.createJava3dObject();
                        break;
                    }
                    if (!streamTokenizer.sval.equals("SolidBackdrop")) continue block6;
                    this.background = new LwsBackground(streamTokenizer, this.debugPrinter.getValidOutput());
                    this.background.createJava3dObject();
                    break;
                }
                default: {
                    this.debugOutputLn(2, "  Unknown ttype, token = " + streamTokenizer.ttype + ", " + n3);
                }
            }
        }
        this.sceneGroupNode = new BranchGroup();
        this.sceneBehaviors = new Vector();
        this.parentObjects();
        this.constructScene();
        return this.scene;
    }

    void constructScene() {
        this.scene = new SceneBase();
        if ((this.loadFlags & 1) != 0) {
            this.addLights();
            this.addAmbient();
        }
        if ((this.loadFlags & 2) != 0) {
            this.addFog();
        }
        if ((this.loadFlags & 4) != 0) {
            this.addBackground();
        }
        if ((this.loadFlags & 0x10) != 0) {
            this.addCamera();
        }
        if (this.loadBehaviors != 0) {
            this.addBehaviors();
        }
        this.scene.setSceneGroup(this.sceneGroupNode);
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            LwsObject lwsObject = (LwsObject)enumeration.nextElement();
            if (lwsObject.fileName != null) {
                this.scene.addNamedObject(lwsObject.fileName, lwsObject.getObjectNode());
                continue;
            }
            if (lwsObject.objName == null) continue;
            this.scene.addNamedObject(lwsObject.objName, lwsObject.getObjectNode());
        }
    }

    void setInternalBaseUrl(URL uRL) {
        StringTokenizer stringTokenizer = new StringTokenizer(uRL.toString(), "\\/");
        int n = stringTokenizer.countTokens() - 1;
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = 0; i < n; ++i) {
            String string = stringTokenizer.nextToken();
            if (i == 0 && !string.regionMatches(true, 0, "file:", 0, 5)) {
                stringBuffer.append(string);
                stringBuffer.append('/');
                stringBuffer.append('/');
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append('/');
        }
        this.internalBaseUrl = stringBuffer.toString();
    }

    void setInternalBasePath(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        int n = stringTokenizer.countTokens() - 1;
        StringBuffer stringBuffer = new StringBuffer(80);
        if (string != null && string.startsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        for (int i = 0; i < n; ++i) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            stringBuffer.append(File.separator);
        }
        this.internalBasePath = stringBuffer.toString();
    }

    String getInternalBasePath() {
        return this.internalBasePath;
    }

    String getInternalBaseUrl() {
        return this.internalBaseUrl;
    }

    int getFileType() {
        return this.fileType;
    }

    void parentObjects() {
        this.debugOutputLn(1, "parentObjects()");
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            LwsObject lwsObject = (LwsObject)enumeration.nextElement();
            if (lwsObject.getParent() != -1) {
                LwsObject lwsObject2 = (LwsObject)this.objectList.elementAt(lwsObject.getParent() - 1);
                lwsObject2.addChild(lwsObject);
                this.debugOutputLn(2, "added child successfully");
            } else if (lwsObject.getObjectNode() != null) {
                this.sceneGroupNode.addChild(lwsObject.getObjectNode());
            }
            if (this.loadBehaviors == 0 || lwsObject.getObjectBehaviors().isEmpty()) continue;
            this.sceneBehaviors.addAll(lwsObject.getObjectBehaviors());
        }
        this.debugOutputLn(8, "Done with parentObjects()");
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public void setBasePath(String string) {
        this.basePath = string;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = this.basePath + File.separator;
        }
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setFlags(int n) {
        this.loadFlags = n;
    }

    public int getFlags() {
        return this.loadFlags;
    }

    public TransformGroup getObject(String string) {
        Object object;
        this.debugOutputLn(1, "getObject()");
        int n = -1;
        int n2 = 0;
        String string2 = string;
        if (string.indexOf("[") != -1) {
            int n3 = string.indexOf("[");
            string2 = string.substring(0, n3);
            object = string.substring(n3);
            int n4 = ((String)object).indexOf("]");
            String string3 = ((String)object).substring(1, n4);
            n = new Integer(string3);
        }
        Enumeration enumeration = this.objectList.elements();
        while (enumeration.hasMoreElements()) {
            object = (LwsObject)enumeration.nextElement();
            this.debugOutputLn(2, "tempObj, file, objname = " + object + ((LwsObject)object).fileName + ((LwsObject)object).objName);
            if ((((LwsObject)object).fileName == null || ((LwsObject)object).fileName.indexOf(string2) == -1) && (((LwsObject)object).objName == null || ((LwsObject)object).objName.indexOf(string2) == -1)) continue;
            if (n < 0 || n == n2) {
                return ((LwsObject)object).getObjectNode();
            }
            ++n2;
        }
        this.debugOutputLn(2, " no luck - wanted " + string + " returning null");
        return null;
    }

    void setupTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(97, 122);
        streamTokenizer.wordChars(65, 90);
        streamTokenizer.wordChars(160, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.commentChar(47);
        streamTokenizer.quoteChar(34);
        streamTokenizer.quoteChar(39);
        streamTokenizer.wordChars(48, 57);
        streamTokenizer.wordChars(46, 46);
        streamTokenizer.wordChars(45, 45);
        streamTokenizer.wordChars(47, 47);
        streamTokenizer.wordChars(92, 92);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(38, 38);
        streamTokenizer.ordinaryChar(40);
        streamTokenizer.ordinaryChar(41);
        streamTokenizer.whitespaceChars(13, 13);
        streamTokenizer.wordChars(58, 58);
        streamTokenizer.wordChars(126, 126);
    }

    void addAmbient() {
        AmbientLight ambientLight = new AmbientLight(this.ambientColor);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        ambientLight.setInfluencingBounds(boundingSphere);
        this.sceneGroupNode.addChild(ambientLight);
        ambientLight.addScope(this.sceneGroupNode);
        this.scene.addLightNode(ambientLight);
    }

    void addLights() {
        Enumeration enumeration = this.lightList.elements();
        while (enumeration.hasMoreElements()) {
            this.debugOutputLn(8, "adding light to scene group");
            LwsLight lwsLight = (LwsLight)enumeration.nextElement();
            if (lwsLight.getObjectNode() != null) {
                lwsLight.getLight().addScope(this.sceneGroupNode);
                if (lwsLight.getParent() != -1) {
                    LwsObject lwsObject = (LwsObject)this.objectList.elementAt(lwsLight.getParent() - 1);
                    lwsObject.addChild(lwsLight);
                } else {
                    this.sceneGroupNode.addChild(lwsLight.getObjectNode());
                }
                if (this.loadBehaviors != 0 && !lwsLight.getObjectBehaviors().isEmpty()) {
                    this.sceneBehaviors.addAll(lwsLight.getObjectBehaviors());
                }
                this.scene.addLightNode(lwsLight.getLight());
                continue;
            }
            this.debugOutputLn(8, "light object null?");
        }
    }

    void addCamera() {
        if (this.camera != null) {
            if (this.camera.getParent() != -1) {
                this.debugOutputLn(2, "camera parent = " + this.camera.getParent());
                LwsObject lwsObject = (LwsObject)this.objectList.elementAt(this.camera.getParent() - 1);
                lwsObject.addChild(this.camera);
                this.debugOutputLn(2, "added child successfully");
            } else {
                this.sceneGroupNode.addChild(this.camera.getObjectNode());
            }
            if (this.loadBehaviors != 0 && !this.camera.getObjectBehaviors().isEmpty()) {
                this.sceneBehaviors.addAll(this.camera.getObjectBehaviors());
            }
            this.scene.addViewGroup(this.camera.getObjectNode());
        }
    }

    void addFog() {
        Fog fog;
        if (this.fog != null && (fog = this.fog.getObjectNode()) != null) {
            this.sceneGroupNode.addChild(fog);
            this.scene.addFogNode(fog);
        }
    }

    void addBehaviors() {
        if (!this.sceneBehaviors.isEmpty()) {
            Enumeration enumeration = this.sceneBehaviors.elements();
            while (enumeration.hasMoreElements()) {
                this.scene.addBehaviorNode((Behavior)enumeration.nextElement());
            }
        }
    }

    void addBackground() {
        Background background;
        if (this.background != null && (background = this.background.getObjectNode()) != null) {
            this.sceneGroupNode.addChild(background);
            this.scene.addBackgroundNode(background);
        }
    }
}

