/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.gluegen;

import com.jogamp.gluegen.ConstantDefinition;
import com.jogamp.gluegen.GlueEmitter;
import com.jogamp.gluegen.GlueEmitterControls;
import com.jogamp.gluegen.JavaConfiguration;
import com.jogamp.gluegen.cgram.types.CompoundType;
import com.jogamp.gluegen.cgram.types.FunctionSymbol;
import com.jogamp.gluegen.cgram.types.Type;
import com.jogamp.gluegen.cgram.types.TypeDictionary;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DebugEmitter
implements GlueEmitter {
    protected JavaConfiguration cfg;

    @Override
    public void readConfigurationFile(String string) throws IOException {
        this.cfg = this.createConfig();
        this.cfg.read(string);
    }

    @Override
    public JavaConfiguration getConfiguration() {
        return this.cfg;
    }

    @Override
    public void beginEmission(GlueEmitterControls glueEmitterControls) {
        System.out.println("----- BEGIN EMISSION OF GLUE CODE -----");
    }

    @Override
    public void endEmission() {
        System.out.println("----- END EMISSION OF GLUE CODE -----");
    }

    @Override
    public void beginDefines() {
    }

    @Override
    public void emitDefine(ConstantDefinition constantDefinition, String string) {
        String string2 = constantDefinition.getName();
        String string3 = constantDefinition.getValue();
        System.out.println("#define " + string2 + " " + string3 + (string != null ? "// " + string : ""));
    }

    @Override
    public void endDefines() {
    }

    @Override
    public void beginFunctions(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) {
        Set<String> set = typeDictionary.keySet();
        for (String string : set) {
            Type type = typeDictionary.get(string);
            System.out.println("typedef " + type + " " + string + ";");
        }
    }

    @Override
    public Iterator<FunctionSymbol> emitFunctions(List<FunctionSymbol> list) throws Exception {
        for (FunctionSymbol functionSymbol : list) {
            this.emitSingleFunction(functionSymbol);
        }
        return list.iterator();
    }

    public void emitSingleFunction(FunctionSymbol functionSymbol) {
        System.out.println(functionSymbol);
        System.out.println(" -> " + functionSymbol.toString());
    }

    @Override
    public void endFunctions() {
    }

    @Override
    public void beginStructLayout() throws Exception {
    }

    @Override
    public void layoutStruct(CompoundType compoundType) throws Exception {
    }

    @Override
    public void endStructLayout() throws Exception {
    }

    @Override
    public void beginStructs(TypeDictionary typeDictionary, TypeDictionary typeDictionary2, Map<Type, Type> map) {
    }

    @Override
    public void emitStruct(CompoundType compoundType, Type type) {
        String string = compoundType.getName();
        if (string == null && type != null) {
            string = type.getName();
        }
        System.out.println("Referenced type \"" + string + "\"");
    }

    @Override
    public void endStructs() {
    }

    protected JavaConfiguration createConfig() {
        return new JavaConfiguration();
    }
}

