package xml.xacml;

import futils.Futil;

import java.io.File;
import java.io.IOException;

import gui.In;
import xml.adbk.AddressBook;
import xml.adbk.ParseAml;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

/**
 * Copyright 2005, DocJava, Inc.
 * User: dlyon
 * Date: Nov 15, 2005
 * Time: 3:46:26 PM
 */
public class XAcmlParser {
    public static void main(String[] args) {
           File f = Futil.getReadFile("select an xacml file");
           try {
               String uri = f.toURL().toString();
               Acl ab = read(uri);
               System.out.println("done with parse!");
               ab.print();
               System.out.println("done!");
               System.exit(0);
           } catch (SAXException e) {
               e.printStackTrace();

           } catch (ParserConfigurationException e) {
               e.printStackTrace();

           } catch (IOException e) {
               e.printStackTrace();

           }
       }
       public static Acl read(String uri)
               throws
               SAXParseException,
               SAXException,
               ParserConfigurationException,
               IOException {

           SAXParserFactory spf
                   = SAXParserFactory.newInstance();
           spf.setValidating(true);

           SAXParser sp = spf.newSAXParser();

           Handler dh = new Handler();
           sp.parse(uri, dh);
           return dh.getAcl();
       }

}
