package xml.xacml;

import org.xml.sax.helpers.DefaultHandler;

import java.util.Vector;

/**
 * ParseAml is p <code>DocumentHandler</code>
 * that can parse AddressBook Markup Language
 */
public class Handler
        extends DefaultHandler {

    private Acl acl = new Acl();
    private Person p = new Person();
    private Vector stringVector = new Vector();

    public Acl getAcl() {
        return acl;
    }

    public String getLastValue() {
        if (stringVector.size() == 0) return null;

        return (String) stringVector.elementAt(stringVector.size() - 1);
    }

    public void endElement(String s1, String s2, String name) {
        //System.out.println("name="+name);
        String sa[] = new String[stringVector.size()];
        stringVector.copyInto(sa);
        /*
                (userId | password |
                title | firstName| lastName)*,
            (streetAddress|address1 | address2| address3 )*,
            (homePage | emailAddress)*,
            (homePhone | businessPhone | faxPhone)*,
            city,
            state,
            zip?)>
        */
        /*
          ...
          <userId>blah blah blah </userId>
        */
        if (name.equals("uid"))
            p.setUid(getLastValue());
        if (name.equals("password"))
            p.setPw(getLastValue());
        if (name.equals("email"))
            p.setEmail(getLastValue());

        // if </Address>, we are done with this record
        if (name.equals("person"))
            addPerson();
    }

    public void addPerson() {
        //System.out.println("adding record:" + p.toXml());
        acl.add(p);
        p = new Person();
    }

    /**
     * when characters are found, we add them to
     * the string vector for latter use.
     */
    public void characters(char buf [], int offset, int len) {
        String s = new String(buf, offset, len);
        stringVector.addElement(s);
    }

    public void ignorableWhitespace(
            char buf [], int offset, int len) {
    }

    /**
     * The processingInstruction is
     * called back when p non XML
     * declaration is made.
     */
    public void processingInstruction(
            String target,
            String data) {
    }
}
