package xml.fix;

import futils.Futil;
import gui.In;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import xml.adbk.AddressBook;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.File;
import java.io.IOException;

/**
 * xml.Xml2Address reads AML and makes address books.
 */

public class Main {
    public static void main(String[] args) {
        File f = Futil.getReadFile("select an xml file");
        try {
            String uri = f.toURL().toString();
            In.message("uri="+uri);
            read(uri);
        } catch (SAXException e) {
            e.printStackTrace();

        } catch (ParserConfigurationException e) {
            e.printStackTrace();

        } catch (IOException e) {
            e.printStackTrace();

        }
    }
    public static AddressBook read(String uri)
            throws
            SAXParseException,
            SAXException,
            ParserConfigurationException,
            IOException {

        SAXParserFactory spf
                = SAXParserFactory.newInstance();
        spf.setValidating(true);

        SAXParser sp = spf.newSAXParser();

        FixDataHandler dh = new FixDataHandler();
        sp.parse(uri, dh);
        return dh.getAddressBook();
    }

}


