package xml.adbk;

import java.beans.XMLEncoder;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;


public class SimpleAddress implements Comparable,
        Serializable {
    private String name = null;
    private String address = null;
    private String info = null;
    private String homePhone = null;
    private String businessPhone = null;
    private String faxPhone = null;

    public SimpleAddress() {
    }

    public int compareTo(Object o1) {
        SimpleAddress a = (SimpleAddress) o1;
        String hisLastName = a.name.toLowerCase();
        String lastNameMine = getName().toLowerCase();
        return lastNameMine.compareTo(hisLastName);
    }

    public static void main(String args[]) {
        SimpleAddress a = new SimpleAddress();
        //3Com;
        // Palm Computing, Inc.  5400 Bayfront Plaza     Box 58007       Santa Clara, CA 95052-8007
        // ;                                       ;;;;
        a.setName("3Com");
        a.setAddress("Palm Computing, Inc.  5400 Bayfront Plaza " +
                "    Box 58007       Santa Clara, CA 95052-8007");
        System.out.println("a=" + a);
    }

    public String toString() {
        return this.toXml();
    }

    public void setInfo(String s) {
        info = s;
    }

    public void setHomePhone(String s) {
        homePhone = s;
    }

    public void setBusinessPhone(String s) {
        businessPhone = s;
    }

    public void setFaxPhone(String s) {
        faxPhone = s;
    }

    public void setAddress(String s) {
        address = s;
    }

    public void setName(String s) {
        name = s;
    }

    public String toXml() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(baos);
        e.writeObject(this);
        e.flush();
        return baos.toString();
    }

    public String getName() {
        return name;
    }

    public String getAddress() {
        return address;
    }

    public String getInfo() {
        return info;
    }

    public String getHomePhone() {
        return homePhone;
    }

    public String getBusinessPhone() {
        return businessPhone;
    }

    public String getFaxPhone() {
        return faxPhone;
    }
}