package video.jsnap;

import gui.In;
import gui.dialogs.ProgressDialog;
import j2d.ImageUtils;
import j2d.animation.ColorSafeAnimationEncoder;
import j2d.io.gif.neuquantAnimation.AnimatedGifEncoder;
import sound.Oscillator;

import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Nov 26, 2004
 * <p/>
 * Time: 9:05:43 AM
 */
public class OneFrameAtATimeCapture {

    public static void neuquantImageStreamToAFile(
            NeuquantCaptureBean ncb) {

        if (ncb.isColorSafe()) {
            try {
                colorSafeCapture(ncb);
            } catch (FileNotFoundException e) {
                In.message(e);
            }
            return;
        }
        Dimension outputDim = ncb.getOutputSize();
        AnimatedGifEncoder age = new AnimatedGifEncoder();

        if (ncb.isLooped()) age.setRepeat(0);
        age.setDelay((int) ncb.getSecondsPerFrame() * 1000);
        age.setTransparent(Color.BLACK);
        age.start(ncb.getOutputFile());

        Vector imageBufferVector = new Vector();
        long totalProcessingTime=0;

        int frameNumber = 1;
        long dt ;
        do {
            long start = System.currentTimeMillis();
            grabNextFrame(
                    ncb,
                    outputDim,
                    imageBufferVector,
                    age);
            frameNumber++;
            dt = System.currentTimeMillis() - start;
            totalProcessingTime = totalProcessingTime + dt;


        } while (In.getBoolean(
                "Processed in:" +dt+" ms "+
                "ready for frame#" +
                frameNumber +
                "?"));
        if (ncb.isBuffered()) {
            compressBufferedImages(
                    imageBufferVector, age,
                    ncb);
        }

        age.finish();
        In.message("average time (ms):" + totalProcessingTime / frameNumber);
    }

    private static void colorSafeCapture(NeuquantCaptureBean ncb)
            throws FileNotFoundException {
        Dimension outputDim = ncb.getOutputSize();
        ColorSafeAnimationEncoder csae = new ColorSafeAnimationEncoder(ncb);
        long totalProcessingTime = 0;


        int frameNumber = 1;
        do {
            long start = System.currentTimeMillis();

            BufferedImage bi = ImageUtils.captureScreen(
                    ncb.getInputRectangle(), outputDim);
            csae.writeImage(ImageUtils.getImage(bi));
            long dt = System.currentTimeMillis() - start;
            totalProcessingTime += dt;
            System.out.println("Grab Time (ms):" + dt);
            frameNumber++;
            beep(ncb);

        } while (In.getBoolean(
                "ready for frame#" +
                frameNumber +
                "?"));
        csae.close();
        In.message("average time (ms):"+totalProcessingTime/frameNumber);
    }

    private static void grabNextFrame(
            NeuquantCaptureBean ncb,
            Dimension outputDim,
            Vector imageBufferVector,
            AnimatedGifEncoder age) {

        BufferedImage bi = ImageUtils.captureScreen(
                ncb.getInputRectangle(), outputDim);

        if (ncb.isBuffered())
            imageBufferVector.addElement(bi);
        else
            addImageToEncoder(age, bi, ncb);

        beep(ncb);


    }

    private static void compressBufferedImages(
            Vector v,
            AnimatedGifEncoder age,
            NeuquantCaptureBean ncb) {
        ProgressDialog pd = ProgressDialog.getInstance();
        pd.setTitle("saving images...");
        pd.setVisible(true);
        final int n = v.size();
        for (int i = 0; i < n; i++) {
            pd.setAmountDone(i * 100 / n);
            addImageToEncoder(age, (BufferedImage) v.elementAt(i), ncb);
        }
        pd.setVisible(false);
    }

    private static void beep(NeuquantCaptureBean ncb) {
        if (ncb.isSilentOnCapture()) return;
        Oscillator.beep();
    }


    private static void addImageToEncoder(
            AnimatedGifEncoder age,
            BufferedImage bi,
            NeuquantCaptureBean ncb) {
        if (age.addFrame(bi) == false)
            In.message("problem adding image");
    }


}
