package utils;

import gui.In;

import java.io.File;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA. User: lyon Date: Jun 9, 2005 Time: 11:17:58 AM
 * Copyright 2005, DocJava, Inc.
 */
public class UnixCommands {
    public static void main(String[] args) {

        checkUnixPermission();

    }

    public static void checkUnixPermission() {
        if (!isRxtxConfigured()) {
            In.message(
                    "user is not in uucp and lock groups.\n" +
                    "To fix this access problem use:\n" +
                    "sudo usermod -G uucp,lock <uid>");
        }
    }

    public static boolean isRxtxConfigured() {
        String s[] = groups();
        return StringUtils.contains( s[0],"uucp") &&
                StringUtils.contains(s[0], "lock");
    }


    public static String[] groups() {
        String command =
                "groups ";
        try {
            return OsUtils.executeCommand(command);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++) {
            System.out.println(o[i]);
        }
    }

    public static void tarXvf(File f) {
        String command =
                "tar " +
                " -xf " +
                f.getAbsolutePath();
        try {
            OsUtils.executeCommand(command);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void chmodPlusX(File f) {
        String command =
                "chmod " +
                " +x " +
                f.getAbsolutePath();
        try {
            OsUtils.executeCommand(command);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
