/*
 * Copyright (c) 2005 DocJava, Inc. All Rights Reserved.
 */
package utils;

import java.awt.*;
import java.awt.geom.Rectangle2D;

/**
 *  given a string, returns the longest substring
 delimited by space that will fit into the given
 width using the given font.
 */

public class StringWacker {
    private String sub;
    private Rectangle2D rect;
    private String delimiters = " ,\\/|?!@#$%^&*()~";
    private Font font;
    private Graphics2D g;
    private int width;

    public StringWacker(
            int width,
            String s,
            Font f,
            Graphics2D g) {
        this.width = width;
        this.sub = s;
        this.font= f;
        this.g = g;
        this.rect = font.getStringBounds(s,
                0,
                s.length(),
                g.getFontRenderContext());
    }
    private void setString(String s){
        sub = s;
        rect = font.getStringBounds(sub,
                0,
                sub.length(),
                g.getFontRenderContext());
    }
    private boolean shortenString(char delimiter){
        int n = sub.lastIndexOf(delimiter);
        if (n < 0) return false;
        setString(sub.substring(0, n));
        return true;
    }
    private void shortenString(int amount){
        setString(sub.substring(0, sub.length() - amount));
    }
    private void shortStringPass(){
        char c[] = delimiters.toCharArray();
        for (int i=0; i < c.length; i++){
            if (shortenString(c[i])) return;
        }
        shortenString(5);
    }
    public String getShortString(){
        while (rect.getWidth() > width)
            shortStringPass();
        return sub;
    }

    public String getDelimiters() {
        return delimiters;
    }

    public void setDelimiters(String delimiters) {
        this.delimiters = delimiters;
    }
}
