package utils;

import java.io.PrintStream;

public class StopWatch {
    private long baseTime;
    private long elapsedTime;

    private static double UNIT = 1000;

    public StopWatch() {
        clear();
    }
    /**
     * record the current time in milliseconds
     * at the start point.
     */
    public void start() {
        baseTime = System.currentTimeMillis();
    }
    /**
     * Zero the elapsedTime
     */
    public void clear() {
        elapsedTime = 0;
    }
    /**
     * Compute the difference between the mark'd time
     * and the current time, in milliseconds.
     * The record method computes the elapsed_time.
     *
     */
    public void stop() {
        elapsedTime = (System.currentTimeMillis() - baseTime);
    }
    /**
     * This is the time between a mark and a record.
     * @return the time in seconds as a float
     */
    public double getElapsedTime() {
        return ((double) elapsedTime) / UNIT;
    }

    public long getTimeInMs(){
        return elapsedTime;
    }
    /**
     * Run the runnable <code>r</code> <code>n</code>
     * times and return the average time in ms.
     * @param r
     * @param n
     * @return
     */
    public static long benchMark(Runnable r, int n){
        StopWatch t = new StopWatch();
        t.start();
        for (int i=0; i < n; i++) {
            r.run();
        }
        t.stop();
        return t.elapsedTime /n;

    }

    public void report(PrintStream ps) {
        double elapsed_seconds = getElapsedTime();
        ps.println("Time " + elapsed_seconds + " sec");
    }

    public static void main(String[] args) {
        StopWatch t = new StopWatch();
        t.start();
        double j = Math.PI;
        int n = 10000000;
        for (int i=0; i < n; i++){
            j /= Math.E;
        }
        t.stop();

        double f = t.getElapsedTime();
        double flops = n / f;
        System.out.println("you machine is running at "+flops/1000000 +" mflops");
    }
    /**
     * Report the elapsed time between the mark and the record
     * invocations to the <code>System.out</code>.
     */
    public void report() {
        report(System.out);
    }

    public void print(double N, String message) {
        elapsedTime = (System.currentTimeMillis() - baseTime);
        double s = elapsedTime;
        System.out.println(
                message
                + " "
                + s + " ms "
                + N / s + "  ops per ms");
        baseTime = System.currentTimeMillis();
    }

    public void print(String message) {

        System.out.println(
                message
                + " "
                + getElapsedTime() + " seconds "
        );
        start();
    }

}

