/*
 * Copyright (c) 2005 Your Corporation. All Rights Reserved.
 */
package utils;

import java.io.*;
import java.util.prefs.Preferences;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Apr 30, 2005
 * <p/>
 * Time: 4:28:24 PM
 */
public class PreferencesUtils {
    public PreferencesUtils(String key) {
        this.key = key;
    }

    private String key;

    /**
     * saves the properties to the Preferences of the userRoot
     */
    public void save(Serializable obj) {
        try {
            Preferences p = Preferences.userRoot();
            ByteArrayOutputStream baos = new
                    ByteArrayOutputStream();
            ObjectOutputStream oos = new
                    ObjectOutputStream(baos);
            oos.writeObject(obj);
            baos.close();
            p.putByteArray(key, baos.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString(Serializable obj) {
        return CompactJava.toXml(obj);
    }

    /**
     * restores the properties from the preference in the user root.
     * @return null unless key is found
     */
    public Object restore() {
        try {
            Preferences p = Preferences.userRoot();
            byte b [] = p.getByteArray(key, null);
            if (b == null)
                return null;
            ByteArrayInputStream bais = new
                    ByteArrayInputStream(b);
            ObjectInputStream ois = new
                    ObjectInputStream(bais);
            Object o = ois.readObject();
            bais.close();
            return o;
        } catch (IOException e) {
            //e.printStackTrace();
        } catch (ClassNotFoundException e) {
            // e.printStackTrace();
        }
        return null;
    }
}
