package utils;

import gui.In;

import java.awt.*;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;
import java.util.Properties;
import java.util.Vector;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 17, 2004
 * <p/>
 * Time: 9:20:42 AM
 */
public class OsUtils {
    public static boolean isOsKnown() {
        if (isLinux()) return true;
        if (isMacOs()) return true;
        if (isWindows()) return true;
        if (isSolaris()) return true;
        return false;
    }


    public static double get15MinuteLoad() {
        if (!isOsKnown()) return -1;
        // what is this OS?
        if (isWindows()) return -1;
        //windows has no implemention, yet.
        try {
            return get15MinuteLoad(executeCommand("uptime")[0]);
        } catch (IOException e) {
            e.printStackTrace();

        }
        return -1;
    }

    /**
     * Input is returned by the uptime command. Typically: 09:34:56  up 15
     * days, 35 min,  2 users,  load average: 0.01, 0.04, 0.10 The last
     * number is the one of interest, showing the past 15 minutes of load.
     * The last number changes position, based on OS!
     *
     * @param s
     * @return
     */
    private static double get15MinuteLoad(String s) {
        System.out.println(s);
        int i = s.lastIndexOf(' ');
        String ss = s.substring(i);
        if (isMacOs()) {
            return Double.parseDouble(ss);
        }
        if (isLinux()) {
            return Double.parseDouble(ss);
        }
        System.out.println("os not implemented for get15MinuteLoad");
        System.out.println("s=" + s);
        print(s.split(" "));
        return -1;
    }

    public  static void print(String[] strings) {
        for (int i = 0; i < strings.length; i++)
            System.out.println(i + ":" + strings[i]);
    }

    public static String getOsName() {
        Properties prop = System.getProperties();
        return prop.getProperty("os.name");
    }

    public static boolean isMacOs() {
        final String prefix = "mac";
        return isOsPrefix(prefix);
    }

    public static boolean isLinux() {
        return isOsPrefix("linux");
    }

    public static boolean isNetBsd() {
        return isOsPrefix("NetBSD");
    }

    public static boolean isFreeBsd() {
        return isOsPrefix("FreeBSD");
    }

    //
    public static boolean isSolaris() {
        return isOsPrefix("SunOS") || isOsPrefix("Solaris");
    }

    public static boolean isWindows() {
        return isOsPrefix("win");
    }

    /**
     * Execute a command on the local OS
     *
     * @param com
     * @return an array of string for output from the command.
     * @throws java.io.IOException
     */
    public static String[] executeCommand(String com)
            throws java.io.IOException {
        System.out.println("Exec:"+com);
        Runtime rt = Runtime.getRuntime();
        Vector v = new Vector();
        Process p =
                rt.exec(com);
        BufferedReader br
                = new BufferedReader(new InputStreamReader(
                        p.getErrorStream()));
        String s = null;
        v.addElement("-----errorStream------");
        while ((s = br.readLine()) != null)
            v.addElement(s);
        readInputStream(p, v);
        String sa[] = new String[v.size()];
        v.copyInto(sa);
        return sa;
    }

    private static void readInputStream(Process p, Vector v)
            throws IOException {
        BufferedReader br;
        String s;
        br = new BufferedReader(new InputStreamReader(p.getInputStream()));
        s = null;
        v.addElement("-------inputStream------");
        while ((s = br.readLine()) != null)
            v.addElement(s);
    }

    public static boolean isOsPrefix(final String prefix) {
        String os = getOsName();
        return os != null && os.toLowerCase().startsWith(prefix) ?
                true :
                false;
    }

    public static void testListProperties() {
        final Toolkit tk = Toolkit.getDefaultToolkit();

        final String propertyName = //"win.propNames";
                "";
        String propnames[] = (String[]) tk
                .getDesktopProperty(propertyName);
        System.out.println("Supported windows property names:");
        for (int i = 0; i < propnames.length; i++) {
            System.out.println(propnames[i]);
        }

    }

    public static void main(String[] args) {
        try {
            final String com =
                    SystemUtils.getJavaCommand().getAbsolutePath()+" -version";
            System.out.println("command:"+com);
            print(OsUtils.executeCommand(
                    com));
        } catch (IOException e) {
            In.message(e);

        }
    }
}
