package thread;
import java.util.Vector;

public class Util {
    public static void main(String args[]){
        print(getThreads());
    }

    public static ThreadGroup getSystemThreadGroup() {
        ThreadGroup systemThreadGroup;
        ThreadGroup parentThreadGroup;
        systemThreadGroup = Thread.currentThread().getThreadGroup();
        while ((parentThreadGroup = systemThreadGroup.getParent()) != null)
            systemThreadGroup = parentThreadGroup;
        return systemThreadGroup;
    }

    /**
     * List all the threads that are known and active in the system
     * @return  the list of all threads in all groups.
     */
    public static Thread[] getThreads() {
        ThreadGroup tg[] = getThreadGroups();
        Vector v = new Vector();
        for (int i=0; i < tg.length; i++){
            Thread t[]= getThreads(tg[i]);
            for (int j=0; j < t.length; j++ ){
                if (t[j]!=null)
                v.addElement(t[j]);
            }
        }
        Thread ta[] = new Thread[v.size()];
        v.copyInto(ta);
        return ta;

    }

    private static Thread[] getThreads(ThreadGroup stg) {
        Thread ta[] = new Thread[stg.activeCount()];
        stg.enumerate(ta, true);
        return ta;
    }

    public static ThreadGroup[] getThreadGroups() {
        ThreadGroup stg = getSystemThreadGroup();
        int nog = stg.activeGroupCount() + 1;
        ThreadGroup tga[] = new ThreadGroup[nog];
        stg.enumerate(tga);
        tga[tga.length - 1] = stg;
        return tga;
    }

    public static void setName(String name, ThreadGroup tg) {
        setName(name, getThreads(tg));
    }
    public static void setName(String name, Thread ta[]) {
        for (int i=0; i < ta.length; i++)
            ta[i].setName(name);
    }
    public static void print(ThreadGroup tg) {
        print(getThreads(tg));
    }

    public static void print(Thread o[]) {
        for (int i = 0; i < o.length; i++) {
            System.out.println(o[i] +
                    " isAlive=" +
                    o[i].isAlive() +
                    " name=" +
                    o[i].getName() +
                    " isDaemon=" +
                    o[i].isDaemon() +
                    " priority=" +
                    o[i].getPriority());
        }
    }


    public static void setPriority(Thread ta[], int p) {
        for (int i = 0; i < ta.length; i++)
            ta[i].setPriority(p);
    }

    public static void setName(Thread ta[], String n) {
        for (int i = 0; i < ta.length; i++)
            ta[i].setName(n);
    }

    public static void setDaemon(Thread ta[], boolean on) {
        for (int i = 0; i < ta.length; i++)
            setDaemon(ta[i], on);
    }

    private static void setDaemon(Thread t, boolean on) {
        if (t.isAlive() == true) {
            System.out.println(
                    "The selected threads are in alive"
                    + "state ; so you can't change the daemon");
            return;
        }
        t.setDaemon(on);
    }
}

